/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.bean.AssetAllotOutEntity;
import com.ejianc.business.asset.service.IAssetAllotOutService;
import com.ejianc.business.asset.vo.AssetAllotOutVO;
import com.ejianc.business.consts.AllocatEnum;
import com.ejianc.business.consts.AllocationState;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"assetAllotOut"})
@Api(value="\u56fa\u5b9a\u8d44\u4ea7\u8c03\u51fa\u8868", tags={"\u56fa\u5b9a\u8d44\u4ea7\u8c03\u51fa\u8868"})
public class AssetAllotOutController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ASSET_ALLOT_OUT";
    @Autowired
    private IAssetAllotOutService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICostDetailApi costDetailApi;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AssetAllotOutVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody AssetAllotOutVO saveOrUpdateVO) {
        AssetAllotOutEntity entity = (AssetAllotOutEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AssetAllotOutEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                entity.setProportionFlag("0");
                entity.setRelationFlag("0");
                entity.setReceiveState(Integer.parseInt(AllocationState.TO_RECEIVING.getCode()));
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        this.service.saveCost(entity, 0);
        AssetAllotOutVO vo = (AssetAllotOutVO)BeanMapper.map((Object)((Object)entity), AssetAllotOutVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/checkParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody AssetAllotOutVO vo) {
        ParamsCheckVO paramsCheckVO = this.service.checkParams(vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AssetAllotOutVO> queryDetail(@RequestParam Long id) {
        AssetAllotOutEntity entity = (AssetAllotOutEntity)((Object)this.service.selectById(id));
        AssetAllotOutVO vo = (AssetAllotOutVO)BeanMapper.map((Object)((Object)entity), AssetAllotOutVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AssetAllotOutVO> vos) {
        Collection list = this.service.listByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        list.forEach(e -> {
            CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(e.getId());
            this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        });
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AssetAllotOutVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("inOrgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AssetAllotOutVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AssetAllotOutVO> pushCost(AssetAllotOutVO allotOutVO) {
        return this.service.pushCost(allotOutVO);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("inOrgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List assetAllotOutVOS = BeanMapper.mapList((Iterable)list, AssetAllotOutVO.class);
        assetAllotOutVOS.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            if (vo.getReceiveState() != null) {
                if (Integer.valueOf(AllocationState.TO_RECEIVING.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.TO_RECEIVING.getDescription());
                } else if (Integer.valueOf(AllocationState.RECEIVED.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.RECEIVED.getDescription());
                } else if (Integer.valueOf(AllocationState.REJECT.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.REJECT.getDescription());
                }
            }
            if (vo.getAllocatType() != null) {
                if (Integer.valueOf(AllocatEnum.ASSETS.getCode()).equals(vo.getAllocatType())) {
                    vo.setAllocatTypeName(AllocatEnum.ASSETS.getDescription());
                } else {
                    vo.setAllocatTypeName(AllocatEnum.HOMEMADE.getDescription());
                }
            }
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", assetAllotOutVOS);
        ExcelExport.getInstance().export("AssetAllotOut-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refAssetAllotOutData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<AssetAllotOutVO>> refAssetAllotOutData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AssetAllotOutVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

