/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.bean.AssetScrapDetailEntity;
import com.ejianc.business.asset.bean.AssetScrapEntity;
import com.ejianc.business.asset.service.IAssetRecordService;
import com.ejianc.business.asset.service.IAssetScrapService;
import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.business.asset.vo.AssetScrapVO;
import com.ejianc.business.decorator.IAssetRecord;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="assetScrap")
public class AssetScrapBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAssetService assetService;
    @Autowired
    private IAssetScrapService assetScrapService;
    @Autowired
    private IAssetRecordService assetRecordService;
    @Autowired
    private IAttachmentApi attachmentApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        AssetScrapEntity assetScrapEntity = (AssetScrapEntity)((Object)this.assetScrapService.selectById(billId));
        if (assetScrapEntity != null && CollectionUtils.isNotEmpty(assetScrapEntity.getAssetScrapDetailList())) {
            List assetIds = assetScrapEntity.getAssetScrapDetailList().stream().map(AssetScrapDetailEntity::getAssetId).collect(Collectors.toList());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", assetIds);
            queryWrapper.eq((Object)"asset_status", (Object)1);
            List assetEntities = this.assetService.list((Wrapper)queryWrapper);
            if (assetEntities.size() > 0) {
                return CommonResponse.error((String)"\u8bbe\u5907\u4fe1\u606f\u4e2d\u5b58\u5728\u8bbe\u5907\u5df2\u7ecf\u88ab\u62a5\u5e9f\u4e0d\u80fd\u518d\u88ab\u62a5\u5e9f!");
            }
            assetScrapEntity.getAssetScrapDetailList().forEach(item -> {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.set(AssetEntity::getAssetStatus, (Object)1);
                wrapper.eq(BaseEntity::getId, (Object)item.getAssetId());
                this.assetService.update((Wrapper)wrapper);
                this.logger.info("\u590d\u5236\u56fa\u5b9a\u8d44\u4ea7\u5904\u7f6e\u7167\u7247\u5230\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247:" + JSONObject.toJSONString((Object)item));
                CommonResponse commonResponse = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(assetScrapEntity.getId()), "EJCBT202206000089", "ScrapPhoto002", String.valueOf(item.getAssetId()), "EJCBT202206000070", "AssetScrapPhoto002");
                this.logger.info("\u590d\u5236\u56fe\u7247\u662f\u5426\u6210\u529f:" + commonResponse.isSuccess());
            });
            AssetScrapVO assetScrapVO = (AssetScrapVO)BeanMapper.map((Object)((Object)assetScrapEntity), AssetScrapVO.class);
            this.assetRecordService.saveRecord((IAssetRecord)assetScrapVO);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        AssetScrapEntity assetScrapEntity = (AssetScrapEntity)((Object)this.assetScrapService.selectById(billId));
        if (assetScrapEntity != null) {
            assetScrapEntity.getAssetScrapDetailList().forEach(item -> {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.set(AssetEntity::getAssetStatus, (Object)0);
                wrapper.eq(BaseEntity::getId, (Object)item.getAssetId());
                this.assetService.update((Wrapper)wrapper);
                this.logger.info("\u5f03\u5ba1\u5220\u9664\u56fa\u5b9a\u8d44\u4ea7\u5904\u7f6e\u7167\u7247:" + JSONObject.toJSONString((Object)item));
                CommonResponse commonResponse = this.attachmentApi.deleteFileByParam(item.getAssetId(), "EJCBT202206000070", "AssetScrapPhoto002");
                this.logger.info("\u5f03\u5ba1\u5220\u9664\u56fa\u5b9a\u8d44\u4ea7\u5904\u7f6e\u7167\u7247\u662f\u5426\u6210\u529f:" + commonResponse.isSuccess());
            });
            this.assetRecordService.delRecord(billId);
        }
        return CommonResponse.success();
    }
}

