package com.ejianc.business.asset.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.asset.bean.AmortizeSetEntity;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.bean.HandleEntity;
import com.ejianc.business.asset.service.IAmortizeSetService;
import com.ejianc.business.asset.service.IAssetRecordService;
import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.business.asset.vo.AssetVO;
import com.ejianc.business.decorator.IAssetRecord;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.*;

@Service("asset") 
public class AssetBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private IAssetService service;
	@Autowired
	private IAssetRecordService assetRecordService;
	@Autowired
	private IAmortizeSetService amortizeSetService;
	@Autowired
	private IExecutionApi executionApi;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		AssetEntity assetEntity = service.selectById(billId);
		AssetVO vo = BeanMapper.map(assetEntity, AssetVO.class);
		logger.info("新增推送设备流转记录的信息:"+ JSONObject.toJSONString(vo));
		assetRecordService.saveRecord(vo);
		//推送目标责任成本
		ExecutionVO executionVO = service.targetCost(BeanMapper.map(assetEntity, AssetVO.class));
		logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
		CommonResponse<String> response = executionApi.aggPush(executionVO);
		if (!response.isSuccess()) {
			throw new BusinessException("目标成本推送失败," + response.getMsg());
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO 固定资产 是否被下游引用
		CommonResponse<String> checkCommonResponse = billTypeApi.checkQuote(billTypeCode,billId );
		boolean success = checkCommonResponse.isSuccess();
		if (!success){
			return CommonResponse.error(checkCommonResponse.getMsg());
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO 弃审删除设备流转记录
		assetRecordService.delRecord(billId);
		//推送目标责任成本
		AssetEntity assetEntity = service.selectById(billId);
		List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
		ExecutionVO executionVO = service.targetCost(BeanMapper.map(assetEntity, AssetVO.class));
		logger.info("目标成本删除数据" + JSON.toJSONString(executionVO));
		totalExecutionVOList.add(executionVO.getTotalVO());
		CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
		if (!response.isSuccess()) {
			throw new BusinessException("目标成本推送失败," + response.getMsg());
		}
		return CommonResponse.success();
	}

}
