package com.ejianc.business.settlement.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.settlement.vo.BillPushStatusEnum;
import com.ejianc.business.settlement.vo.ContractSettlementRecordVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.share.vo.SupplierProVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.settlement.bean.PurchaseSettlementEntity;
import com.ejianc.business.settlement.service.IPurchaseSettlementService;
import com.ejianc.business.settlement.vo.PurchaseSettlementVO;

/**
 * 设备采购结算表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("purchaseSettlement")
@Api(value = "设备采购结算表", tags = {"设备采购结算表"})
public class PurchaseSettlementController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IExecutionApi executionApi;

    @Autowired
    private IPurchaseSettlementService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IShareCooperateApi shareCooperateApi;

    private static final String BILL_CODE = "CGJS_CODE";//此处需要根据实际修改
    private static final String BILL_TYPE = "EJCBT202204000012";//此处需要根据实际修改
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proequipment/proEquipments/equipmentPurchase/card";


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchaseSettlementVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody PurchaseSettlementVO saveOrUpdateVO) {
    	return service.saveOrUpdate(saveOrUpdateVO);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchaseSettlementVO> queryDetail(@RequestParam Long id) {
    	PurchaseSettlementEntity entity = service.selectById(id);
    	PurchaseSettlementVO vo = BeanMapper.map(entity, PurchaseSettlementVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @ApiOperation("同步结算池接口")
    @RequestMapping(value = "/syncSettle", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> pushSettle(@RequestParam Long id) {
        PurchaseSettlementEntity entity = service.selectById(id);
        boolean pool = service.pushSettleToPool(BeanMapper.map(entity, PurchaseSettlementVO.class));
        if(!pool){
            throw new BusinessException("推送结算池失败");
        }
        return CommonResponse.success("同步成功");
    }

    @ApiOperation("获取最近一次结算日期和结算金额、结算次数")
    @RequestMapping(value = "/getDateMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map> getDateMny(@RequestParam Long contractId) {
        return service.getDateMny(contractId);
    }


    @ApiOperation("供方签字确认信息回写")
    @PostMapping(value = "/supSignSync")
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }

    @ApiOperation("获取协同链接")
    @RequestMapping(value = "/getBillShareLink", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        PurchaseSettlementEntity entity = service.selectById(id);
        String billTypeCode = BILL_TYPE;
        String url = mobileBillShareFrontUrl;
        CommonResponse<SupplierProVO> supplierResp = proSupplierApi.getSupplierInfo(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            logger.error("根据供应商主键-{}查询失败，{}", entity.getSupplierId(), supplierResp.getMsg());
            return CommonResponse.error("单据获取供方信息失败，生成分享连接失败！");
        }
        SupplierProVO supplierVO = supplierResp.getData();
        if(null!=supplierVO&&StringUtils.isNotEmpty(supplierVO.getSystemId())&&supplierVO.getCoordination()){
        }else{
            return CommonResponse.error("该供应商未开通协同权限，无法协同分享。");
        }
        if(BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            //查询该单据是否支持协同分享，则向供方协同服务推送该单据
            CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode);
            if (!cooperateResp.isSuccess()) {
                logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", billTypeCode, cooperateResp.getMsg());
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            } else {
                //未曾成功推送单据，则先向供方推送单据
                boolean pushResult = service.pushBillToSupCenter(entity,billTypeCode);
                logger.info("获取推送供方结果--"+pushResult);
                if(!pushResult) {
                    logger.error("单据-{}推送给供应商supplierId-{}失败！", id, entity.getSupplierId());
                    return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
                } else {
                    entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                    service.saveOrUpdate(entity, false);
                }
            }
        }


        return shareCooperateApi.getShareLink(id, billTypeCode, entity.getSupplierId().toString(), url,null);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseSettlementVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            for (PurchaseSettlementVO vo : vos) {
                // 删除策划成本
                PurchaseSettlementEntity purchaseSettlementEntity = service.selectById(vo.getId());
                ExecutionVO executionVO = service.targetCost(BeanMapper.map(purchaseSettlementEntity, PurchaseSettlementVO.class),"", false);
                totalExecutionVOList.add(executionVO.getTotalVO());
            }
            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()){
                throw new BusinessException(response.getMsg());
            }
        }
        service.removeByIds(vos.stream().map(PurchaseSettlementVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PurchaseSettlementVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();

        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");

        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<PurchaseSettlementEntity> page = service.queryPage(param,false);
        IPage<PurchaseSettlementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseSettlementVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();

        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");

        fuzzyFields.add("billCode");
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PurchaseSettlementEntity> list = service.queryList(param);
        //todo:字段翻译等等
        ArrayList<PurchaseSettlementVO> settlementVOS = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            for (PurchaseSettlementEntity entity : list) {
                PurchaseSettlementVO map = BeanMapper.map(entity, PurchaseSettlementVO.class);
                if(entity.getSettlementDate()!=null){
                    map.setSettlementDate(entity.getSettlementDate());
                }
                switch (entity.getSignStatus()){
                    case 0: map.setSignStatusName("未签字");break;
                    case 1: map.setSignStatusName("已签字");break;
                }
                //TODO  待补充 --签章
                if (entity.getSignatureStatus() == 0) {
                    map.setSignatureStatusName("未签章");
                }
                switch (entity.getBillState()){
                    case 0: map.setBillStateName("自由态");break;
                    case 1: map.setBillStateName("已提交");break;
                    case 2: map.setBillStateName("审批中");break;
                    case 3: map.setBillStateName("审批通过");break;
                    case 4: map.setBillStateName("审批驳回");break;
                    case 5: map.setBillStateName("审批中");break;
                }
                settlementVOS.add(map);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", settlementVOS);
        ExcelExport.getInstance().export("PurchaseSettlement-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refPurchaseSettlementData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PurchaseSettlementVO>> refPurchaseSettlementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PurchaseSettlementEntity> page = service.queryPage(param,false);
        IPage<PurchaseSettlementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseSettlementVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    /**
     * 单据管控-累计结算金额大于合同金额
     * @return
     */
    @RequestMapping(value = "/checkParams", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody PurchaseSettlementVO vo) {
        return CommonResponse.success("参数校验成功！", service.checkParams(vo));
    }
    /**
     * 查询合同结算记录
     *
     * @return
     */
    @GetMapping(value = "/queryDetailRecord")
    @ResponseBody
    public CommonResponse<ContractSettlementRecordVO> queryDetailRecord(Long id) {
        ContractSettlementRecordVO vo = service.queryDetailRecord(id);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    /**
     * 结算推送策划成本（不限制结算状态）
     * @param id
     * @return
     */
    @RequestMapping(value = "/pushSettlementTargetCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> pushSettlementTargetCost(Long id) {
        return service.pushSettlementTargetCost(id);
    }


    /**
     * 全购置合同结算结算推送策划成本数据
     *
     * @param projectId 项目id
     *
     * @return CommonResponse
     */
    @GetMapping(value = "/allPurchaseSettlementPushTargetCost")
    @ResponseBody
    public CommonResponse<String> allPurchaseSettlementPushTargetCost(@RequestParam(value = "projectId", required = false) Long projectId) {
        QueryWrapper<PurchaseSettlementEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("id");
        if (null != projectId){
            queryWrapper.eq("project_id", projectId);
        }
        List<PurchaseSettlementEntity> settlementEntityList = service.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(settlementEntityList)){
            for (PurchaseSettlementEntity settleEntity : settlementEntityList) {
                service.pushSettlementTargetCost(settleEntity.getId());
            }
        }
        logger.info("全购置合同结算结算推送策划成本数据{}条", settlementEntityList.size());
        return CommonResponse.success("全购置合同结算结算推送策划成本数据成功 "+ settlementEntityList.size() +" 条！");
    }
}
