package com.ejianc.business.asset.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.vo.AssetVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.asset.bean.AssetEntity;
import org.apache.ibatis.annotations.Param;

import javax.xml.crypto.Data;
import java.util.List;
import java.util.Map;

/**
 *  固定资产
 * 
 * @author generator
 * 
 */
@Mapper
public interface AssetMapper extends BaseCrudMapper<AssetEntity> {

    List<AssetVO> queryAssetPage(Page<AssetVO> page,
                                 @Param(Constants.WRAPPER) QueryWrapper wrapper,
                                 @Param("orgIds")List<Long> orgIds);

    /**
     * 按 asset_type_id 分组统计资产数据
     * @param orgIds 组织ID列表
     * @return List<List<String>> 每行数据以 List<String> 存储
     */
    List<Map<String, Object>> getGroupByAssetTypeId(
            @Param("orgIds") List<Long> orgIds
    );

    List<Map<String, Object>> getSituationStatistics(@Param("orgIds") List<Long> orgIds);

    List<Map<String, Object>> getUsage(@Param("orgIds") List<Long> orgIds);

    List<Map<String, Object>> getAnnounce(@Param(value = "checkDay")String formattedDate,@Param("orgIds") List<Long> orgIds);

    List<Map<String, Object>> getEquipmentUsage(@Param("orgIds") List<Long> orgIds);
}
