package com.ejianc.business.acceptance.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.acceptance.service.IPurchaseAcceptanceService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 设备采购
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@RestController
@RequestMapping(value = "/api/purchaseAcceptance")
public class PurchaseAcceptanceApi {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private final IPurchaseAcceptanceService service;

	public PurchaseAcceptanceApi(IPurchaseAcceptanceService service) {
		this.service = service;
	}


	/**
	 * 根据项目id、验收日期查询设备采购单据数量
	 *
	 * @param jsonObject 参数
	 *
	 * @return CommonResponse<Integer>
	 */
	@ApiOperation(value = "根据项目id、验收日期查询设备采购单据数量")
	@PostMapping(value = "/countBillNum")
	public CommonResponse<Integer> countBillNum(@RequestBody JSONObject jsonObject) {
		if (!jsonObject.containsKey("projectId")) {
			throw new BusinessException("项目id不能为空！");
		}
		if (!jsonObject.containsKey("fillDate")) {
			throw new BusinessException("填报日期不能为空！");
		}
		return CommonResponse.success("查询成功！", service.countBillNum(jsonObject.getLong("projectId"), jsonObject.getDate("fillDate")));
	}

}
