package com.ejianc.business.asset.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.asset.bean.AssetAmortizeFinanceDetailEntity;
/**
 * 固定资产摊销（财务）
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipment_asset_amortize_finance")
public class AssetAmortizeFinanceEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_date")
    private Date billDate; // 办理日期
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="finance_push_state")
    private Integer financePushState; // 财务推送状态1已推送0未推送
    @TableField(value="project_id")
    private Long projectId; // 项目(摊销单位)
    @TableField(value="project_code")
    private String projectCode; // 项目编号(摊销单位编码)
    @TableField(value="project_name")
    private String projectName; // 项目名称(摊销单位名称)
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 所属组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 所属组织名称
    @TableField(value="org_id")
    private Long orgId; // 所属项目部
    @TableField(value="org_code")
    private String orgCode; // 所属项目部编码
    @TableField(value="org_name")
    private String orgName; // 所属项目部名称
    @TableField(value="effect_time")
    private Date effectTime; // 单据生效时间
    @TableField(value="amortize_date")
    private String amortizeDate; // 摊销周期
    @TableField(value="last_amortize_date")
    private String lastAmortizeDate; // 上次摊销周期
    @TableField(value="amortize_mny")
    private BigDecimal amortizeMny; // 摊销金额
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 经办部门
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="category_name")
    private String categoryName; // 材料分类名称
    @TableField(value="relation_flag")
    private String relationFlag; // 关联状态(1:是，0：否)
    @TableField(value="proportion_flag")
    private String proportionFlag; // 分摊状态(1:是，0：否)
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="assetAmortizeFinanceDetailService")
    private List<AssetAmortizeFinanceDetailEntity> assetAmortizeFinanceDetailList = new ArrayList<>(); // 固定资产摊销明细（财务）

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getFinancePushState() {
        return financePushState;
    }

    public void setFinancePushState(Integer financePushState) {
        this.financePushState = financePushState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getEffectTime() {
        return effectTime;
    }

    public void setEffectTime(Date effectTime) {
        this.effectTime = effectTime;
    }

    public String getAmortizeDate() {
        return amortizeDate;
    }

    public void setAmortizeDate(String amortizeDate) {
        this.amortizeDate = amortizeDate;
    }

    public String getLastAmortizeDate() {
        return lastAmortizeDate;
    }

    public void setLastAmortizeDate(String lastAmortizeDate) {
        this.lastAmortizeDate = lastAmortizeDate;
    }

    public BigDecimal getAmortizeMny() {
        return amortizeMny;
    }

    public void setAmortizeMny(BigDecimal amortizeMny) {
        this.amortizeMny = amortizeMny;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    

    public List<AssetAmortizeFinanceDetailEntity> getAssetAmortizeFinanceDetailList() {
        return assetAmortizeFinanceDetailList;
    }

    public void setAssetAmortizeFinanceDetailList(List<AssetAmortizeFinanceDetailEntity> assetAmortizeFinanceDetailList) {
        this.assetAmortizeFinanceDetailList = assetAmortizeFinanceDetailList;
    }
}
