package com.ejianc.business.asset.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.asset.bean.AssetAmortizeEntity;
import com.ejianc.business.asset.vo.AssetAmortizeDetailVO;
import com.ejianc.business.asset.vo.AssetAmortizeFinanceDetailVO;
import com.ejianc.business.asset.vo.AssetAmortizeVO;
import com.ejianc.business.consts.AssetAmortizeEnum;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.business.settlement.vo.PurchaseSettlementVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.utils.DateUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.asset.bean.AssetAmortizeFinanceEntity;
import com.ejianc.business.asset.service.IAssetAmortizeFinanceService;
import com.ejianc.business.asset.vo.AssetAmortizeFinanceVO;

/**
 * 固定资产摊销（财务）
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("assetAmortizeFinance")
public class AssetAmortizeFinanceController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ASSET_AMORTIZE_CW_CODE";//此处需要根据实际修改

    @Autowired
    private IAssetAmortizeFinanceService service;

    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value = "/test", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<AssetAmortizeFinanceDetailVO>> test(@RequestParam String projectId,List<String> period) {
        List<AssetAmortizeFinanceDetailVO> assetAmortizeFinanceDetailVOS = new ArrayList<>();
        AssetAmortizeFinanceDetailVO detailVO = new AssetAmortizeFinanceDetailVO();
        detailVO.setFinanceTypeCode("caiwucs");
        detailVO.setFinanceTypeName("caiwucs");
        detailVO.setDetailAmortizeDate(DateFormatUtils.format(new Date(),"yyyy-mm"));
        detailVO.setDetailAmortizeMny(new BigDecimal("100"));
        assetAmortizeFinanceDetailVOS.add(detailVO);
        return CommonResponse.success("查询详情数据成功！", assetAmortizeFinanceDetailVOS);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AssetAmortizeFinanceVO> saveOrUpdate(@RequestBody AssetAmortizeFinanceVO saveOrUpdateVO) {
        AssetAmortizeFinanceVO vo = service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AssetAmortizeFinanceVO> queryDetail(Long id) {
    	AssetAmortizeFinanceEntity entity = service.selectById(id);
    	AssetAmortizeFinanceVO vo = BeanMapper.map(entity, AssetAmortizeFinanceVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AssetAmortizeFinanceVO> vos) {
        service.delete(vos);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AssetAmortizeFinanceVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "employeeName", "categoryName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        Parameter amortizeDatePara = param.getParams().get("amortizeDate");
        if (amortizeDatePara != null) {
            Object value = amortizeDatePara.getValue();
            if (value != null) {
                String[] split = String.valueOf(value).split(",");
                List<String> monthBetween = DateUtil.getMonthBetween(split[0], split[1]);
                param.getParams().put("amortizeDate", new Parameter(QueryParam.IN, monthBetween));
            }
        }
        IPage<AssetAmortizeFinanceEntity> page = service.queryPage(param,false);
        IPage<AssetAmortizeFinanceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AssetAmortizeFinanceVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "employeeName", "categoryName"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        Parameter amortizeDatePara = param.getParams().get("amortizeDate");
        if (amortizeDatePara != null) {
            Object value = amortizeDatePara.getValue();
            if (value != null) {
                String[] split = String.valueOf(value).split(",");
                List<String> monthBetween = DateUtil.getMonthBetween(split[0], split[1]);
                param.getParams().put("amortizeDate", new Parameter(QueryParam.IN, monthBetween));
            }
        }
        List<AssetAmortizeFinanceEntity> list = service.queryList(param);
        List<AssetAmortizeFinanceVO> assetAmortizeFinanceVOS = BeanMapper.mapList(list, AssetAmortizeFinanceVO.class);
        assetAmortizeFinanceVOS.forEach(
                t -> {
                    t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription());
                }

        );
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", assetAmortizeFinanceVOS);
        ExcelExport.getInstance().export("AssetAmortizeFinance-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refAssetAmortizeFinanceData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AssetAmortizeFinanceVO>> refAssetAmortizeFinanceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<AssetAmortizeFinanceEntity> page = service.queryPage(param,false);
        IPage<AssetAmortizeFinanceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AssetAmortizeFinanceVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @param projectId
     * @param billId
     * @description: 查上次摊销周期
     * @return: String
     */
    @RequestMapping(value = "/getLastAmortizeDate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> getLastAmortizeDate(Long projectId, Long billId) {
        String lastAmortizeDate = null;
        LambdaQueryWrapper<AssetAmortizeFinanceEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(AssetAmortizeFinanceEntity::getProjectId, projectId);
        wrapper.orderByDesc(AssetAmortizeFinanceEntity::getCreateTime);
        if(null!=billId){
            wrapper.ne(AssetAmortizeFinanceEntity::getId, billId);
        }
        List<AssetAmortizeFinanceEntity> list = service.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){
            lastAmortizeDate = list.get(0).getAmortizeDate();
        }
        return CommonResponse.success("查询上次摊销周期成功！", lastAmortizeDate);
    }

    /**
     * 参数控制
     * @return ParamsCheckVO
     */
    @RequestMapping(value = "/checkParams", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody AssetAmortizeFinanceVO vo) {
        return CommonResponse.success("参数校验成功！", service.checkParams(vo));
    }

    /**
     * 成本改造
     * 关联保存接口
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AssetAmortizeFinanceVO> pushCost(@RequestBody AssetAmortizeFinanceVO vo) {
        return  service.pushCost(vo);
    }
}
