package com.ejianc.business.asset.service;

import com.ejianc.business.asset.vo.AssetAmortizeFinanceVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.settlement.vo.PurchaseSettlementVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.asset.bean.AssetAmortizeFinanceEntity;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 固定资产摊销（财务）
 * 
 * @author generator
 * 
 */
public interface IAssetAmortizeFinanceService extends IBaseService<AssetAmortizeFinanceEntity> {
    /*
     * 新增保存*/
    AssetAmortizeFinanceVO saveOrUpdate( AssetAmortizeFinanceVO saveOrUpdateVO);
    /*
    * 删除*/
    void delete( List<AssetAmortizeFinanceVO> vos);
    /*
    *参数控制 合并方法
     */
    ParamsCheckVO checkParams(AssetAmortizeFinanceVO vo);
    /*
    *项目累计摊销总金额/项目预估摊销总金额 比例
     */
    List<ParamsCheckVO> checkParamsRatio(AssetAmortizeFinanceVO vo);
/*
* 关联保存*/
    CommonResponse<AssetAmortizeFinanceVO> pushCost(AssetAmortizeFinanceVO vo);
    /*
    * 推送实际成本*/
    void costPush(AssetAmortizeFinanceEntity entity);
}
