package com.ejianc.business.asset.service;

import com.ejianc.business.asset.bean.AmortizeSetEntity;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.vo.AssetAmortizeDetailVO;
import com.ejianc.business.asset.vo.AssetAmortizeVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.asset.bean.AssetAmortizeEntity;

import java.util.Date;
import java.util.List;

/**
 * 固定资产摊销
 * 
 * @author generator
 * 
 */
public interface IAssetAmortizeService extends IBaseService<AssetAmortizeEntity> {

    ParamsCheckVO checkParams(AssetAmortizeVO assetAmortizeVO);

    /**
     * @description: 获取摊销设置
     * @return: void
     * @author songlx
     * @date: 2022/7/19
     */
    void getAmortizeSet(List<AssetAmortizeDetailVO> detailList, Long orgId);

    /**
     * @param detailList
     * @param amortizeDate
     * @description: 计算本次摊销金额
     * @return: void
     * @author songlx
     * @date: 2022/7/19
     */
    void caclAmortizeMny(List<AssetAmortizeDetailVO> detailList, Date amortizeDate);

    void costPush(AssetAmortizeEntity assetAmortizeEntity1);

    CommonResponse<AssetAmortizeVO> pushCost(AssetAmortizeVO assetAmortizeVO);


    void saveCost(AssetAmortizeEntity assetAmortizeEntity,Integer effectiveStatus);

    void autoGenerateAmortize(List<AmortizeSetEntity> setList, List<AssetEntity> assetList);
}
