package com.ejianc.business.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.asset.bean.*;
import com.ejianc.business.asset.service.*;
import com.ejianc.business.asset.vo.AssetAllotInVO;
import com.ejianc.business.asset.vo.AssetAllotOutVO;
import com.ejianc.business.consts.AllocationState;
import com.ejianc.business.consts.NoticeEnum;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service("assetAllotOut") 
public class AssetAllotOutBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAssetAllotOutService service;
	@Autowired
	private ICostDetailApi costDetailApi;
    @Autowired
    private IAssetAllotOutDetailService assetAllotOutDetailService;
	@Autowired
    private IAssetAllotInService assetAllotInService;

	@Autowired
	private AssetAllotInMessageService allotInMessageService;

	@Autowired
	private IAssetRecordService assetRecordService;

	private static final String BILL_CODE = "ASSET_ALLOT_IN";//此处需要根据实际修改

	@Autowired
	private IBillCodeApi billCodeApi;

	@Autowired
	private JedisPool jedisPool;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//加锁防止生成多个调拨入库 提交前进行
		Jedis jedis = jedisPool.getResource();
		boolean locked = false;
		locked = RedisTool.tryLock(jedis,String.valueOf(billId),"generateAssetAllotIn",1000);
		logger.info("判断单据单据锁结果------"+locked);
		try{
			if (locked){

			}
			else{
				return CommonResponse.success("出现并发操作,请稍后重试！");
			}
		}catch (Exception e){
			e.printStackTrace();
		} finally {
			if(locked) {
				RedisTool.releaseLock(jedis, String.valueOf(billId), "generateAssetAllotIn");
			}
			jedis.close();
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.error("该单据不支持弃审和撤回");
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		AssetAllotOutEntity assetAllotOutEntity = service.selectById(billId);
		if (!Objects.isNull(assetAllotOutEntity)){
			//提交时判断子表是否在数据库中已存在
			if(CollectionUtils.isNotEmpty(assetAllotOutEntity.getAssetAllotOutDetailList())){
				List<Long> longs = assetAllotOutEntity.getAssetAllotOutDetailList().stream().map(AssetAllotOutDetailEntity::getAssetId).collect(Collectors.toList());
				QueryWrapper<AssetAllotOutDetailEntity> detailWrapper = new QueryWrapper<>();
				detailWrapper.in("asset_id",longs);
				detailWrapper.ne("allocat_id",assetAllotOutEntity.getId());
				detailWrapper.eq("dr",0);
				List<AssetAllotOutDetailEntity> list = assetAllotOutDetailService.list(detailWrapper);
				if(list.size()>0){
					return CommonResponse.error("设备信息中存在设备已经被调出不能再被调出!");
				}
			}

			if (assetAllotOutEntity.getReceiveState().equals(Integer.parseInt(AllocationState.REJECT.getCode()))){
				LambdaUpdateWrapper<AssetAllotOutEntity> allotOutWrapper = new LambdaUpdateWrapper<>();
				allotOutWrapper.eq(AssetAllotOutEntity::getId, billId);
				allotOutWrapper.set(AssetAllotOutEntity::getReceiveState, Integer.parseInt(AllocationState.TO_RECEIVING.getCode()));
				allotOutWrapper.set(AssetAllotOutEntity::getReturnReason,null);
				allotOutWrapper.set(AssetAllotOutEntity::getReceiverPersonId,null);
				allotOutWrapper.set(AssetAllotOutEntity::getReceiverPerson,null);
				service.update(allotOutWrapper);
			}
			//生成固定资产调出
			AssetAllotInEntity assetAllotInEntity = new AssetAllotInEntity();
			//调出信息
			assetAllotInEntity.setOutAllocatRange(assetAllotOutEntity.getAllocatRange());//调出范围
			assetAllotInEntity.setAllocatRange(assetAllotOutEntity.getInAllocatRange()); //调入范围
			assetAllotInEntity.setOutProjectId(assetAllotOutEntity.getProjectId());
			assetAllotInEntity.setOutProjectName(assetAllotOutEntity.getProjectName());
			assetAllotInEntity.setOutOrgId(assetAllotOutEntity.getOrgId());
			assetAllotInEntity.setOutOrgName(assetAllotOutEntity.getOrgName());
			assetAllotInEntity.setOutOrgCode(assetAllotOutEntity.getOrgCode());
			assetAllotInEntity.setOutParentOrgId(assetAllotOutEntity.getParentOrgId());
			assetAllotInEntity.setOutParentOrgName(assetAllotOutEntity.getParentOrgName());
			assetAllotInEntity.setOutParentOrgCode(assetAllotOutEntity.getParentOrgCode());
			assetAllotInEntity.setOutTaxMny(assetAllotOutEntity.getOutTaxMny());
			assetAllotInEntity.setProjectId(assetAllotOutEntity.getInProjectId());
			assetAllotInEntity.setProjectName(assetAllotOutEntity.getInProjectName());
			assetAllotInEntity.setParentOrgId(assetAllotOutEntity.getInParentOrgId());
			assetAllotInEntity.setParentOrgName(assetAllotOutEntity.getInParentOrgName());
			assetAllotInEntity.setParentOrgCode(assetAllotOutEntity.getInParentOrgCode());
			assetAllotInEntity.setOrgId(assetAllotOutEntity.getInOrgId());
			assetAllotInEntity.setOrgCode(assetAllotOutEntity.getInOrgCode());
			assetAllotInEntity.setOrgName(assetAllotOutEntity.getInOrgName());
			assetAllotInEntity.setAllocatOutId(assetAllotOutEntity.getId());
			assetAllotInEntity.setOutMny(assetAllotOutEntity.getOutMny());
			assetAllotInEntity.setOutDate(assetAllotOutEntity.getOutDate());
			assetAllotInEntity.setEmployeeId(assetAllotOutEntity.getEmployeeId());
			assetAllotInEntity.setEmployeeName(assetAllotOutEntity.getEmployeeName());
			assetAllotInEntity.setDepartmentId(assetAllotOutEntity.getDepartmentId());
			assetAllotInEntity.setDepartmentName(assetAllotOutEntity.getDepartmentName());
			assetAllotInEntity.setNotifyReceiverId(assetAllotOutEntity.getReceiverId());
			assetAllotInEntity.setReceiverName(assetAllotOutEntity.getReceiverName());
			assetAllotInEntity.setAllocatType(assetAllotOutEntity.getAllocatType());
			assetAllotInEntity.setMemo(assetAllotOutEntity.getMemo());
			assetAllotInEntity.setEquipmentNames(assetAllotOutEntity.getEquipmentNames());
			assetAllotInEntity.setReceiveState(Integer.valueOf(AllocationState.TO_RECEIVING.getCode()));
			long id = IdWorker.getId();
			if (CollectionUtils.isNotEmpty(assetAllotOutEntity.getAssetAllotOutDetailList())){
				List<AssetAllotInDetailEntity> inDetailEntities = BeanMapper.mapList(assetAllotOutEntity.getAssetAllotOutDetailList(), AssetAllotInDetailEntity.class);
				inDetailEntities.forEach(item->{
					item.setId(null);
					item.setAllocatId(id);
				});
				assetAllotInEntity.setAssetAllotInDetailList(inDetailEntities);
				logger.info("子表信息："+inDetailEntities.toString());
			}
			AssetAllotInVO vo = BeanMapper.map(assetAllotInEntity, AssetAllotInVO.class);
			BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),vo);
			CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
			if(billCode.isSuccess()) {
				assetAllotInEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
			}else{
				throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
			}
			assetAllotInEntity.setId(id);
			boolean b = assetAllotInService.saveOrUpdate(assetAllotInEntity,false);
			if (b){
				AssetAllotInEntity allot = assetAllotInService.selectById(id);
				if ((allot!=null) && (allot.getNotifyReceiverId()!=null)){
					//通知收料人收料
					String[] notifyReceive = {String.valueOf(allot.getNotifyReceiverId())};
					allotInMessageService.sendMsg(allot,notifyReceive, NoticeEnum.ALLOTIN_ENROLL);
				}
				//生成设备流转记录
				AssetAllotOutVO allotOutVO = BeanMapper.map(assetAllotOutEntity, AssetAllotOutVO.class);
				assetRecordService.saveRecord(allotOutVO);
			}
		}
		logger.info("推送成本---");
		AssetAllotOutEntity entity = service.selectById(billId);
		List<AssetAllotOutDetailEntity> allotOutDetailList = entity.getAssetAllotOutDetailList();
		if (CollectionUtils.isNotEmpty(allotOutDetailList)){
			BigDecimal sumAllocatDiffMny = allotOutDetailList.stream().map(AssetAllotOutDetailEntity::getAllocatDiffMny).reduce(BigDecimal.ZERO, BigDecimal::add);
			BigDecimal sumAllocatDiffTaxMny = allotOutDetailList.stream().map(AssetAllotOutDetailEntity::getAllocatDiffTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
			LambdaUpdateWrapper<AssetAllotOutEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.in(AssetAllotOutEntity::getId, entity.getId());
			updateWrapper.set(AssetAllotOutEntity::getSumAllocatDiffMny, sumAllocatDiffMny);
			updateWrapper.set(AssetAllotOutEntity::getSumAllocatDiffTaxMny, sumAllocatDiffTaxMny);
			service.update(updateWrapper);
			logger.info("sumAllotDiffMny---"+sumAllocatDiffMny);
			logger.info("sumAllotDiffTaxMny---"+sumAllocatDiffTaxMny);
		}
		AssetAllotOutEntity allotOutEntity1 = service.selectById(billId);
		service.costPush(allotOutEntity1);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该单据不支持弃审和撤回");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {



		//		logger.info("删除成本---");
//		CommonResponse<String> stringCommonResponse = costDetailApi.updateCostDetail(billId,0);
//		logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
//		if(!stringCommonResponse.isSuccess()){
//			throw new BusinessException(stringCommonResponse.getMsg());
//		}
		//删除实际成本
		CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(billId);
		logger.info("结果" + JSONObject.toJSONString(stringCommonResponse));
		if (!stringCommonResponse.isSuccess()) {
			throw new BusinessException(stringCommonResponse.getMsg());
		}
		//更新是否关联
		LambdaUpdateWrapper<AssetAllotOutEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.in(AssetAllotOutEntity::getId, billId);
		updateWrapper.set(AssetAllotOutEntity::getRelationFlag, 0);//(1:是，0：否)
		service.update(updateWrapper);
		//TODO
		//TODO 弃审删除设备流转记录
		assetRecordService.delRecord(billId);
		return CommonResponse.success();
	}

}
