package com.ejianc.business.pricelib.controller;

import java.io.Serializable;

import com.ejianc.business.pricelib.vo.PriceContractCollectVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;

import com.ejianc.business.pricelib.service.IPriceContractCollectService;

/**
 * 设备购置价格库-根据清单id汇总表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("priceContractCollect")
public class PriceContractCollectController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPriceContractCollectService service;


    /**
     * @Description shelfGoods 价格库列表数据到历史表定时任务
     */
    @RequestMapping(value = "/savePriceContractCollect", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> savePriceContractCollect(HttpServletRequest request) {
        service.savePriceContractToHistoryByTiming();
        return CommonResponse.success("价格库列表数据到历史表定时任务处理成功");
    }


    //查询多个档案清单历史价格
    @PostMapping("/getPriceContractByDocIds")
    @ResponseBody
    public CommonResponse<List<PriceContractCollectVO>> getPriceContractByDocIds(@RequestBody List<Long> docIds){
        logger.info("档案id集合【{}】", docIds);
        List<PriceContractCollectVO> PriceContractCollectVOList = service.getPriceContractByDocIds(docIds);
        return CommonResponse.success("查询成功！",PriceContractCollectVOList);
    }

}
