package com.ejianc.business.pricelib.mapper;

import com.ejianc.business.purchase.bean.EquipmentDetailedEntity;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.pricelib.bean.PriceContractEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

/**
 * 设备价格库清单明细实体
 * 
 * @author generator
 * 
 */
@Mapper
public interface PriceContractMapper extends BaseCrudMapper<PriceContractEntity> {
    @Select("select * from ejc_proequipment_purchase_contract where create_time >= #{time} or update_time >= #{time}")
    List<PurchaseContractEntity> getContractListByTime(Date time);

    @Select({
            "<script>",
            "select * from ejc_proequipment_equipment_detailed where contract_id in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<EquipmentDetailedEntity> getContractDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);
}
