package com.ejianc.business.purchase.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.purchase.bean.ChangePurchaseContractEntity;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.enums.ChangeStatusEnum;
import com.ejianc.business.purchase.enums.SignatureStatusEnum;
import com.ejianc.business.purchase.service.IChangePurchaseContractService;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.business.purchase.vo.ChangePurchaseContractVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 购置合同-变更表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("changePurchaseContract")
public class ChangePurchaseContractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BT220323000000002";//此处需要根据实际修改

    @Autowired
    private IChangePurchaseContractService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IPurchaseContractService contractService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangePurchaseContractVO> saveOrUpdate(@RequestBody ChangePurchaseContractVO saveOrUpdateVO) {
        ChangePurchaseContractVO vo = service.insertOrUpdate(saveOrUpdateVO,false);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangePurchaseContractVO> queryDetail(Long id) {
        ChangePurchaseContractVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangePurchaseContractVO> vos) {
        return service.deleteById(vos.get(0).getId());
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangePurchaseContractVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if(!orgResp.isSuccess()) {
            return CommonResponse.error("查询失败，获取本下组织信息失败！");
        }
//        param.getParams().put("orgId",new Parameter(QueryParam.IN, orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ChangePurchaseContractEntity> page = service.queryPage(param,false);
        IPage<ChangePurchaseContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangePurchaseContractVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryDetailRecord 查询当前合同下变更列表
     * @param id
     */
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangePurchaseContractVO> queryDetailRecord(Long id) {
        ChangePurchaseContractVO vo = service.queryDetailRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Author yangst
     * @Description  新增根据合同主键查询变更需要的主合同字段
     * @param contractId
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangePurchaseContractVO> addConvertByConId(Long contractId, Long changeId) {
        ChangePurchaseContractVO vo = service.addConvertByConId(contractId, changeId);
        return CommonResponse.success("新增转换数据成功！",vo);
    }

    /**
     * @Author yangst
     * @Description  查询变更对比
     * @param
     */
    @RequestMapping(value = "/queryChangeCompare", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map> queryChangeCompare(Long id) {
        Map returnMap = service.queryChangeCompare(id);
        return CommonResponse.success("新增转换数据成功！", returnMap);
    }

    /**
     * @Author yangst
     * @Description  查询变更记录
     * @param
     */
    @RequestMapping(value = "/queryChangeRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangePurchaseContractVO> queryChangeRecord(Long contractId, Long changeId) {
        ChangePurchaseContractVO vo = service.queryChangeRecord(contractId, changeId);
        return CommonResponse.success("变更记录查询成功！",vo);
    }

    /**
     * 变更合同签章流程
     * @param
     * @return
     */
    @RequestMapping(value = "/changeSignatureProcess", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> changeSignatureProcess(Long id) {
        /*
            后期修改：签章流程暂定为点击就改为已签章
         */
        ChangePurchaseContractEntity changeEntity = service.selectById(id);
        if (changeEntity != null){
            changeEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode().toString());
            changeEntity.setEffectiveDate(new Date());
            changeEntity.setContractPerformanceState(ContractPerformanceStateEnum.履约中.getStateCode());
            service.saveOrUpdate(changeEntity);

            //回写主合同（变更合同签章状态，主合同变更状态）
            LambdaUpdateWrapper<PurchaseContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(PurchaseContractEntity::getId, changeEntity.getContractId());
            updateWrapper.set(PurchaseContractEntity::getChangeContractSignatureStatus, Integer.valueOf(changeEntity.getSignatureStatus()));
            updateWrapper.set(PurchaseContractEntity::getChangeStatus, ChangeStatusEnum.已变更.getCode());
            contractService.update(contractService.selectById(changeEntity.getContractId()), updateWrapper, false);
        }
        return CommonResponse.success();
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ChangePurchaseContractEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ChangePurchaseContract-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refChangePurchaseContractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ChangePurchaseContractVO>> refChangePurchaseContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ChangePurchaseContractEntity> page = service.queryPage(param,false);
        IPage<ChangePurchaseContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangePurchaseContractVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/targetCostCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody ChangePurchaseContractVO changeContractVO) {
        return CommonResponse.success("参数校验成功！", service.targetCostCtrl(changeContractVO));
    }

    @GetMapping(value = "/viewTargetCostCtrlInfo")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("参数校验成功！", service.viewTargetCostCtrlInfo(id));
    }
}
