package com.ejianc.business.purchase.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.purchase.bean.PurchaseRecordDetaileEntity;
import com.ejianc.business.purchase.bean.PurchaseRecordOtherDetailedEntity;
import com.ejianc.business.purchase.service.IPurchaseRecordDetaileService;
import com.ejianc.business.purchase.service.IPurchaseRecordOtherDetailedService;
import com.ejianc.business.purchase.vo.EquipmentDetailedVO;
import com.ejianc.business.purchase.vo.OtherDetailedVO;
import com.ejianc.business.purchase.vo.PurchaseContractVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.purchase.mapper.PurchaseContractRecordMapper;
import com.ejianc.business.purchase.bean.PurchaseContractRecordEntity;
import com.ejianc.business.purchase.service.IPurchaseContractRecordService;

import java.util.ArrayList;
import java.util.List;

/**
 * 购置合同-记录表
 *
 * @author generator
 */
@Service("purchaseContractRecordService")
public class PurchaseContractRecordServiceImpl extends BaseServiceImpl<PurchaseContractRecordMapper, PurchaseContractRecordEntity> implements IPurchaseContractRecordService {

    @Autowired
    private IPurchaseRecordDetaileService recordDetailService;

    @Autowired
    private IPurchaseRecordOtherDetailedService recordOtherCostService;

    @Override
    public PurchaseContractVO queryDetail(Long id) {
        LambdaQueryWrapper<PurchaseContractRecordEntity> lambda = Wrappers.<PurchaseContractRecordEntity>lambdaQuery();
        lambda.eq(PurchaseContractRecordEntity::getChangeId, id);

        PurchaseContractRecordEntity recordEntity = super.getOne(lambda);

        PurchaseContractVO contractVO = BeanMapper.map(recordEntity, PurchaseContractVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("recordId", new Parameter(QueryParam.EQ, recordEntity.getId()));
        List<PurchaseRecordDetaileEntity> detailEntityListDb = recordDetailService.queryList(queryParam, false);
        List<PurchaseRecordDetaileEntity> detailEntityList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (PurchaseRecordDetaileEntity cdEntity : detailEntityList) {
//                cdEntity.setTid(cdEntity.getSrcTableId().toString());
//                cdEntity.setId(cdEntity.getSrcTableId());
//                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List<EquipmentDetailedVO> resultMapList = BeanMapper.mapList(detailEntityList, EquipmentDetailedVO.class);
            contractVO.setDetailList(resultMapList);
        }


        //设置其他花费内容
        List<PurchaseRecordOtherDetailedEntity> otherCostEntityListDb = recordOtherCostService.queryList(queryParam, false);
        List<PurchaseRecordOtherDetailedEntity> otherCostEntityList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(otherCostEntityListDb)) {
            otherCostEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType()) {
                    otherCostEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(otherCostEntityList)) {
            for (PurchaseRecordOtherDetailedEntity ocEntity : otherCostEntityList) {
                ocEntity.setRowState("edit");
            }
            List<OtherDetailedVO> resultMapList = BeanMapper.mapList(otherCostEntityList, OtherDetailedVO.class);
            contractVO.setOtherCostList(resultMapList);
        }

        return contractVO;
    }
}
