/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.controller;

import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"assetCountNums"})
@Api(value=" \u56fa\u5b9a\u8d44\u4ea7\u6570\u636e\u7edf\u8ba1", tags={" \u56fa\u5b9a\u8d44\u4ea7"})
public class AssetCountNumsController {
    @Autowired
    private IAssetService assetService;
    @Autowired
    private IOrgApi iOrgApi;

    @ApiOperation(value="\u5404\u7c7b\u578b\u56fa\u5b9a\u8d44\u4ea7\u8bbe\u5907\u7edf\u8ba1\u60c5\u51b5")
    @RequestMapping(value={"/equipmentStatistics"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> equipmentStatistics() {
        List<Long> orgIds = this.getOrgIds();
        List<Map<String, Object>> ans = this.assetService.getGroupByAssetTypeId(orgIds);
        return CommonResponse.success((String)"\u6570\u636e\u67e5\u8be2\u6210\u529f", ans);
    }

    @ApiOperation(value="\u5404\u5355\u4f4d\u56fa\u5b9a\u8d44\u4ea7\u60c5\u51b5\u7edf\u8ba1\u8868")
    @RequestMapping(value={"/situationStatistics"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> situationStatistics() {
        List<Long> orgIds = this.getOrgIds();
        List<Map<String, Object>> maps = this.assetService.getSituationStatistics(orgIds);
        return CommonResponse.success((String)"\u6570\u636e\u67e5\u8be2\u6210\u529f", maps);
    }

    @ApiOperation(value="\u56fa\u5b9a\u8d44\u4ea7\u8bbe\u5907\u4f7f\u7528\u60c5\u51b5")
    @RequestMapping(value={"/usage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> usage() {
        List<Long> orgIds = this.getOrgIds();
        List<Map<String, Object>> ans = this.assetService.getUsage(orgIds);
        return CommonResponse.success((String)"\u6570\u636e\u67e5\u8be2\u6210\u529f", ans);
    }

    @ApiOperation(value="\u5404\u5355\u4f4d\u56fa\u5b9a\u8d44\u4ea7\u8bbe\u5907\u4f7f\u7528\u60c5\u51b5")
    @RequestMapping(value={"/equipmentUsage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> equipmentUsage() {
        List<Long> orgIds = this.getOrgIds();
        List<Map<String, Object>> ans = this.assetService.getEquipmentUsage(orgIds);
        return CommonResponse.success((String)"\u6570\u636e\u67e5\u8be2\u6210\u529f", ans);
    }

    @ApiOperation(value="\u56fa\u5b9a\u8d44\u4ea7\u8bbe\u5907\u91c7\u8d2d\u62a5\u5e9f\u60c5\u51b5")
    @RequestMapping(value={"/announce"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> announce(@RequestParam(required=false) String data) {
        String formattedDate = null;
        if (data != null && !data.isEmpty()) {
            try {
                if (data.length() >= 7) {
                    formattedDate = data.substring(0, 7);
                }
            }
            catch (Exception e) {
                formattedDate = null;
            }
        }
        List<Long> orgIds = this.getOrgIds();
        List<Map<String, Object>> ans = this.assetService.getAnnounce(formattedDate, orgIds);
        return CommonResponse.success((String)"\u6570\u636e\u67e5\u8be2\u6210\u529f", ans);
    }

    private List<Long> getOrgIds() {
        Long parentOrgId = InvocationInfoProxy.getOrgId();
        List<Long> orgIds = ((List)this.iOrgApi.findChildrenByParentId(parentOrgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        return orgIds;
    }
}

