package com.ejianc.business.pricelib.controller.api;

import com.ejianc.business.pricelib.service.IPriceContractCollectService;
import com.ejianc.business.pricelib.vo.PriceContractCollectVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;

/**
 * 设备购置合同实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("api/priceContractCollectApi")
public class PurchasePriceContractCollectApiController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPriceContractCollectService priceContractCollectService;

    //查询多个档案清单历史价格
    @PostMapping("/getPriceContractByDocIds")
    @ResponseBody
    public CommonResponse<List<PriceContractCollectVO>> getPriceContractByDocIds(@RequestBody List<Long> docIds){
        logger.info("档案id集合【{}】", docIds);
        List<PriceContractCollectVO> PriceContractCollectVOList = priceContractCollectService.getPriceContractByDocIds(docIds);
        return CommonResponse.success("查询成功！",PriceContractCollectVOList);
    }

}
