package com.ejianc.business.purchaseplan.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.purchaseplan.bean.PurchasePlanDetailedEntity;
import com.ejianc.business.purchaseplan.mapper.PurchasePlanDetailedMapper;
import com.ejianc.business.purchaseplan.service.IPurchasePlanDetailedService;
import com.ejianc.business.rent.vo.DisposalVo;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 购置计划-计划清单表
 * 
 * @author generator
 * 
 */
@Service("purchasePlanDetailedService")
public class PurchasePlanDetailedServiceImpl extends BaseServiceImpl<PurchasePlanDetailedMapper, PurchasePlanDetailedEntity> implements IPurchasePlanDetailedService{

    @Autowired
    private PurchasePlanDetailedMapper purchasePlanDetailedMapper;
    @Override
    public IPage<PurchasePlanDetailedEntity> queryData(QueryParam param, Page<Object> objectPage,Long planId) {
        List<PurchasePlanDetailedEntity> purchasePlanDetailedEntities=purchasePlanDetailedMapper.queryData(changeToQueryWrapper(param), objectPage,planId);
        IPage<PurchasePlanDetailedEntity> pageData = new Page<>(objectPage.getCurrent(), objectPage.getSize(), objectPage.getTotal());
        pageData.setRecords(purchasePlanDetailedEntities);
        return pageData;
    }
}
