package com.ejianc.business.profinance.common.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 单据处理类型
 *
 * @author CJ
 * @Description:
 * @date 2022/6/17 17:37
 */
public enum BillHandleTypeEnum {

    付款申请单("paymentApply", "付款申请单", "pMPayService"),
    工人工资支付申请单("salaryPayApply", "工人工资支付申请单", "salaryPayApplyService");

    BillHandleTypeEnum(String typeCode, String typeName, String handleServiceName) {
        this.typeCode = typeCode;
        this.typeName = typeName;
        this.handleServiceName = handleServiceName;
    }

    /**
     * 类型编码
     */
    private String typeCode;
    /**
     * 类型名称
     */
    private String typeName;
    /**
     * 结果处理服务名称
     */
    private String handleServiceName;
    private static Map<String, BillHandleTypeEnum> enumMap = new HashMap<>();


    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getHandleServiceName() {
        return handleServiceName;
    }

    public void setHandleServiceName(String handleServiceName) {
        this.handleServiceName = handleServiceName;
    }

    static {
        enumMap = EnumSet.allOf(BillHandleTypeEnum.class).stream().collect(Collectors.toMap(BillHandleTypeEnum::getTypeCode, Function.identity(), (k1, k2) -> k2));
    }

    public static BillHandleTypeEnum getByCode(String typeCode) {
        return enumMap.get(typeCode);
    }
}
