package com.ejianc.business.receipt.api;

import com.ejianc.business.receipt.hystrix.ReceiptRegisterHystrix;
import com.ejianc.business.receipt.vo.ReceiptRegisterVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

/**
 * 收款登记API
 */
@FeignClient(name = "ejc-profinance-web", url = "${common.env.feign-client-url}", path = "ejc-profinance-web", fallback = ReceiptRegisterHystrix.class)
public interface IReceiptRegisterApi {

    /**
     * 通过项目id查询相应的累计收款金额
     * @param projectId
     * @return
     */
    @GetMapping(value = "/api/receiptRegisterApi/queryRecMnyByProjectId")
    CommonResponse<BigDecimal> queryRecMnyByProjectId(@RequestParam(value = "projectId") Long projectId);


    /**
     * 通用查询收款列表-无分页
     * @param param
     * @return
     */
    @PostMapping(value = "/api/receiptRegisterApi/queryReceiptRegisterList")
    CommonResponse<List<ReceiptRegisterVO>> queryReceiptRegisterList(@RequestBody QueryParam queryParam);

    /**
     * 更新或保存收款列表
     * @param
     * @return
     */
    @PostMapping(value = "/api/receiptRegisterApi/saveOrUpdateReceiptRegisterList")
    CommonResponse<Boolean> saveOrUpdateReceiptRegisterList(@RequestBody List<ReceiptRegisterVO> vos);
}
