package com.ejianc.business.profinance.projectloan.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 借款管理-项目借款实体
 *
 * @author baipengyan
 */
public class ProjectLoanVO extends BaseVO {
	private static final long serialVersionUID = -1578032804284589117L;

	private Date commitDate; // 提交日期
	private String commitUserName; // 提交人名称
	private String commitUserCode; // 提交人账号
	private Date effectiveDate; // 生效日期
	private String billCode; // 单据编号
	private String billName; // 单据名称
	private Integer billState; // 单据状态
	private String billStateName; // 单据状态名称
	private Long employeeId; // 经办人id
	private String employeeName; // 经办人名称
	private Long departmentId; // 经办部门id
	private String departmentName; // 经办部门名称
	private Long borrowingUnitId; // 借款单位id
	private String borrowingUnitCode; // 借款单位编码
	private String borrowingUnitName; // 借款单位名称
	private Long loanUnitId; // 出借单位id
	private String loanUnitCode; // 出借单位编码
	private String loanUnitName; // 出借单位名称
	private Long loanTypeId; // 借款类型id
	private String loanTypeCode; // 借款类型编码
	private String loanTypeName; // 借款类型名称
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date loanDate; // 借款日期
	private BigDecimal loanMny; // 借款金额
	private BigDecimal repaidLoanMny; // 已还款金额
	private BigDecimal leftLoanMny; // 借款余额
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date expectRepayDate; // 预计还款日期
	private Long expectRepayDays; // 预计还款天数
	private Long settleTypeId; // 结算方式id
	private String settleTypeCode; // 结算方式编码
	private String settleTypeName; // 结算方式名称
	private String memo; // 借款用途
	private String refStatus;//引用状态

	public String getRefStatus() {
		return refStatus;
	}

	public void setRefStatus(String refStatus) {
		this.refStatus = refStatus;
	}

	public Date getCommitDate() {
		return commitDate;
	}

	public void setCommitDate(Date commitDate) {
		this.commitDate = commitDate;
	}

	public String getCommitUserName() {
		return commitUserName;
	}

	public void setCommitUserName(String commitUserName) {
		this.commitUserName = commitUserName;
	}

	public String getCommitUserCode() {
		return commitUserCode;
	}

	public void setCommitUserCode(String commitUserCode) {
		this.commitUserCode = commitUserCode;
	}

	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillName() {
		return billName;
	}

	public void setBillName(String billName) {
		this.billName = billName;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

	public Long getEmployeeId() {
		return employeeId;
	}

	@ReferDeserialTransfer
	public void setEmployeeId(Long employeeId) {
		this.employeeId = employeeId;
	}

	public String getEmployeeName() {
		return employeeName;
	}

	public void setEmployeeName(String employeeName) {
		this.employeeName = employeeName;
	}

	public Long getDepartmentId() {
		return departmentId;
	}

	@ReferDeserialTransfer
	public void setDepartmentId(Long departmentId) {
		this.departmentId = departmentId;
	}

	public String getDepartmentName() {
		return departmentName;
	}

	public void setDepartmentName(String departmentName) {
		this.departmentName = departmentName;
	}

	public Long getBorrowingUnitId() {
		return borrowingUnitId;
	}

	@ReferDeserialTransfer
	public void setBorrowingUnitId(Long borrowingUnitId) {
		this.borrowingUnitId = borrowingUnitId;
	}

	public String getBorrowingUnitCode() {
		return borrowingUnitCode;
	}

	public void setBorrowingUnitCode(String borrowingUnitCode) {
		this.borrowingUnitCode = borrowingUnitCode;
	}

	public String getBorrowingUnitName() {
		return borrowingUnitName;
	}

	public void setBorrowingUnitName(String borrowingUnitName) {
		this.borrowingUnitName = borrowingUnitName;
	}

	public Long getLoanUnitId() {
		return loanUnitId;
	}

	@ReferDeserialTransfer
	public void setLoanUnitId(Long loanUnitId) {
		this.loanUnitId = loanUnitId;
	}

	public String getLoanUnitCode() {
		return loanUnitCode;
	}

	public void setLoanUnitCode(String loanUnitCode) {
		this.loanUnitCode = loanUnitCode;
	}

	public String getLoanUnitName() {
		return loanUnitName;
	}

	public void setLoanUnitName(String loanUnitName) {
		this.loanUnitName = loanUnitName;
	}

	public Long getLoanTypeId() {
		return loanTypeId;
	}

	@ReferDeserialTransfer
	public void setLoanTypeId(Long loanTypeId) {
		this.loanTypeId = loanTypeId;
	}

	public String getLoanTypeCode() {
		return loanTypeCode;
	}

	public void setLoanTypeCode(String loanTypeCode) {
		this.loanTypeCode = loanTypeCode;
	}

	public String getLoanTypeName() {
		return loanTypeName;
	}

	public void setLoanTypeName(String loanTypeName) {
		this.loanTypeName = loanTypeName;
	}

	public Date getLoanDate() {
		return loanDate;
	}

	public void setLoanDate(Date loanDate) {
		this.loanDate = loanDate;
	}

	public BigDecimal getLoanMny() {
		return loanMny;
	}

	public void setLoanMny(BigDecimal loanMny) {
		this.loanMny = loanMny;
	}

	public BigDecimal getRepaidLoanMny() {
		return repaidLoanMny;
	}

	public void setRepaidLoanMny(BigDecimal repaidLoanMny) {
		this.repaidLoanMny = repaidLoanMny;
	}

	public BigDecimal getLeftLoanMny() {
		return leftLoanMny;
	}

	public void setLeftLoanMny(BigDecimal leftLoanMny) {
		this.leftLoanMny = leftLoanMny;
	}

	public Date getExpectRepayDate() {
		return expectRepayDate;
	}

	public void setExpectRepayDate(Date expectRepayDate) {
		this.expectRepayDate = expectRepayDate;
	}

	public Long getExpectRepayDays() {
		return expectRepayDays;
	}

	public void setExpectRepayDays(Long expectRepayDays) {
		this.expectRepayDays = expectRepayDays;
	}

	public Long getSettleTypeId() {
		return settleTypeId;
	}

	@ReferDeserialTransfer
	public void setSettleTypeId(Long settleTypeId) {
		this.settleTypeId = settleTypeId;
	}

	public String getSettleTypeCode() {
		return settleTypeCode;
	}

	public void setSettleTypeCode(String settleTypeCode) {
		this.settleTypeCode = settleTypeCode;
	}

	public String getSettleTypeName() {
		return settleTypeName;
	}

	public void setSettleTypeName(String settleTypeName) {
		this.settleTypeName = settleTypeName;
	}

	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}

}
