package com.ejianc.business.profinance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.profinance.vo.PayrollRegisterDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 工资发放登记主实体
 * 
 * @author generator
 * 
 */
public class PayrollRegisterVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long orgId; // 项目部id
    private String orgCode; // 项目部编码
    private String orgName; // 项目部名称
    private Long parentOrgId; // 项目部所属组织id
    private String parentOrgCode; // 项目部所属组织编码
    private String parentOrgName; // 项目部所属组织名称
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private String contractCode; // 合同编码
    private String contractType; // 合同类型：0-劳务合同 1-专业合同
    private Integer supplementFlag; // 合同类别：0-主合同 1-补充协议
    private Long projectId; // 项目Id
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private Long supplierId; // 乙方id
    private String supplierName; // 乙方名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date provideDate; // 发放日期：默认显示当天
    private Integer provideType; // 发放类型：0：劳务公司直发，1：第三方垫付，2：总包代发
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门id
    private String departmentName; // 经办部门名称
    private String memo; // 非必填，0-2000字
    private BigDecimal totalActualMny; // 本期实发金额（子表汇总）
    private Long accountId; // 银行账户id
    private String accountNum; // 银行账号
    private String accountName; // 账户名称
    private String bankName; // 开户行
    private Long salaryPayApplyId; // 付款申请单id
    private Integer sourceType; // 数据来源方式 （0-手动确认支付结果为成功时推送，1-直接新增，2-财务推送）
    private String billStateName;
    private String provideTypeName;

    private String groupName;//班组名称
    private String contractLinkUrl; //合同详情页面
    private String salaryPayApplyCode; //付款申请单编码

    private Integer payType; // 支付类型(1：总包代发，2：劳务班组垫付，3：劳务公司直发)

    private List<PayrollRegisterDetailVO> payrollRegisterDetailList = new ArrayList<>(); // 工资发放登记子实体


    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getProvideDate() {
        return provideDate;
    }

    public void setProvideDate(Date provideDate) {
        this.provideDate = provideDate;
    }
    public Integer getProvideType() {
        return provideType;
    }

    public void setProvideType(Integer provideType) {
        this.provideType = provideType;
    }

    @ReferDeserialTransfer
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getTotalActualMny() {
        return totalActualMny;
    }

    public void setTotalActualMny(BigDecimal totalActualMny) {
        this.totalActualMny = totalActualMny;
    }

    @ReferDeserialTransfer
    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }
    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    
     public List<PayrollRegisterDetailVO> getPayrollRegisterDetailList() {
        return payrollRegisterDetailList;
     }

     public void setPayrollRegisterDetailList(List<PayrollRegisterDetailVO> payrollRegisterDetailList) {
        this.payrollRegisterDetailList = payrollRegisterDetailList;
     }

    public Long getSalaryPayApplyId() {
        return salaryPayApplyId;
    }

    public void setSalaryPayApplyId(Long salaryPayApplyId) {
        this.salaryPayApplyId = salaryPayApplyId;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getProvideTypeName() {
        return provideTypeName;
    }

    public void setProvideTypeName(String provideTypeName) {
        this.provideTypeName = provideTypeName;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getContractLinkUrl() {
        return contractLinkUrl;
    }

    public void setContractLinkUrl(String contractLinkUrl) {
        this.contractLinkUrl = contractLinkUrl;
    }

    public String getSalaryPayApplyCode() {
        return salaryPayApplyCode;
    }

    public void setSalaryPayApplyCode(String salaryPayApplyCode) {
        this.salaryPayApplyCode = salaryPayApplyCode;
    }
}
