package com.ejianc.business.profinance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.profinance.vo.SalaryDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 工人工资单主实体
 * 
 * @author generator
 * 
 */
public class SalaryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Integer billState; // 单据状态
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private String contractCode; // 合同编码
    private String contractType; // 合同类型：劳务合同-laborsub，专业合同-prosub
    private Integer supplementFlag; // 合同类别：0-主合同  1-补充协议
    private Long orgId; // 所属项目部Id
    private String orgCode; // 项目部编码
    private String orgName; // 所属项目部名称
    private Long parentOrgId; // 项目部上级组织Id
    private String parentOrgCode; // 项目部上级组织编码
    private String parentOrgName; // 项目部上级组织名称
    private Long projectId; // 所属项目Id
    private String projectName; // 所属项目名称
    private String projectCode; // 所属项目编码
    private Long supplierId; // 供应商Id（乙方id）
    private String supplierName; // 供应商名称（乙方名称）
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date belongMonth; // 所属年月
    private BigDecimal totalSalaryMny; // 工资单总金额
    private BigDecimal totalActualSalaryMny; // 工人工资(实发工资汇总)
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人
    private Long departmentId; // 经办人部门id
    private String departmentName; //  经办人部门
    private String memo; //  备注
    private String contractSourceType; // 合同所属大分类 proSub-专业分包合同，laborSub-劳务分包合同
    private String contractSourceTypeName; //合同所属大分类名称

    private String billStateName; //  单据状态名称
    private BigDecimal SumMny; //  汇总金额
    private Integer salaryDetailSourceType; // 子表数据来源方式 （0-同步劳务实名系统新增 1-直接新增）
    private Long settleId; //  结算单id（结算单引用工人工资单后回写此字段）
    private String contractLinkUrl; //合同详情页面
    private BigDecimal contractMny; // 合同金额
    private List<SalaryDetailVO> salaryDetailList = new ArrayList<>(); // 工人工资单子实体

    private BigDecimal totalProcessSettleTaxMny; // 累计履约结算(节点结算金额)
    private BigDecimal totalNodeSettleTaxMny; // 累计节点结算
    private BigDecimal totalSettleTaxMny; // 累计结算金额
    private BigDecimal payProcessSettleTaxMnyScale; // 工资占履约结算比例
    private BigDecimal totalApplyTaxMny; // 累计工人工资总额
    private BigDecimal lastApplyTaxMny; // 已申请工资金额
    private BigDecimal totalActualPaidTaxMny; // 工资实付金额
    private BigDecimal actualShouldPayScale; // 工资实付比例
    private Long decreaseSalaryId; // 冲减时工资单id


    public Long getDecreaseSalaryId() {
        return decreaseSalaryId;
    }

    public void setDecreaseSalaryId(Long decreaseSalaryId) {
        this.decreaseSalaryId = decreaseSalaryId;
    }
    public BigDecimal getTotalProcessSettleTaxMny() {
        return totalProcessSettleTaxMny;
    }

    public void setTotalProcessSettleTaxMny(BigDecimal totalProcessSettleTaxMny) {
        this.totalProcessSettleTaxMny = totalProcessSettleTaxMny;
    }

    public BigDecimal getTotalNodeSettleTaxMny() {
        return totalNodeSettleTaxMny;
    }

    public void setTotalNodeSettleTaxMny(BigDecimal totalNodeSettleTaxMny) {
        this.totalNodeSettleTaxMny = totalNodeSettleTaxMny;
    }

    public BigDecimal getTotalSettleTaxMny() {
        return totalSettleTaxMny;
    }

    public void setTotalSettleTaxMny(BigDecimal totalSettleTaxMny) {
        this.totalSettleTaxMny = totalSettleTaxMny;
    }

    public BigDecimal getPayProcessSettleTaxMnyScale() {
        return payProcessSettleTaxMnyScale;
    }

    public void setPayProcessSettleTaxMnyScale(BigDecimal payProcessSettleTaxMnyScale) {
        this.payProcessSettleTaxMnyScale = payProcessSettleTaxMnyScale;
    }

    public BigDecimal getTotalApplyTaxMny() {
        return totalApplyTaxMny;
    }

    public void setTotalApplyTaxMny(BigDecimal totalApplyTaxMny) {
        this.totalApplyTaxMny = totalApplyTaxMny;
    }

    public BigDecimal getLastApplyTaxMny() {
        return lastApplyTaxMny;
    }

    public void setLastApplyTaxMny(BigDecimal lastApplyTaxMny) {
        this.lastApplyTaxMny = lastApplyTaxMny;
    }

    public BigDecimal getTotalActualPaidTaxMny() {
        return totalActualPaidTaxMny;
    }

    public void setTotalActualPaidTaxMny(BigDecimal totalActualPaidTaxMny) {
        this.totalActualPaidTaxMny = totalActualPaidTaxMny;
    }

    public BigDecimal getActualShouldPayScale() {
        return actualShouldPayScale;
    }

    public void setActualShouldPayScale(BigDecimal actualShouldPayScale) {
        this.actualShouldPayScale = actualShouldPayScale;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getBelongMonth() {
        return belongMonth;
    }

    public void setBelongMonth(Date belongMonth) {
        this.belongMonth = belongMonth;
    }
    public BigDecimal getTotalSalaryMny() {
        return totalSalaryMny;
    }

    public void setTotalSalaryMny(BigDecimal totalSalaryMny) {
        this.totalSalaryMny = totalSalaryMny;
    }
    public BigDecimal getTotalActualSalaryMny() {
        return totalActualSalaryMny;
    }

    public void setTotalActualSalaryMny(BigDecimal totalActualSalaryMny) {
        this.totalActualSalaryMny = totalActualSalaryMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     public List<SalaryDetailVO> getSalaryDetailList() {
        return salaryDetailList;
     }

     public void setSalaryDetailList(List<SalaryDetailVO> salaryDetailList) {
        this.salaryDetailList = salaryDetailList;
     }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public BigDecimal getSumMny() {
        return SumMny;
    }

    public void setSumMny(BigDecimal sumMny) {
        SumMny = sumMny;
    }

    public Integer getSalaryDetailSourceType() {
        return salaryDetailSourceType;
    }

    public void setSalaryDetailSourceType(Integer salaryDetailSourceType) {
        this.salaryDetailSourceType = salaryDetailSourceType;
    }

    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }

    public String getContractLinkUrl() {
        return contractLinkUrl;
    }

    public void setContractLinkUrl(String contractLinkUrl) {
        this.contractLinkUrl = contractLinkUrl;
    }

    public String getContractSourceType() {
        return contractSourceType;
    }

    public void setContractSourceType(String contractSourceType) {
        this.contractSourceType = contractSourceType;
    }

    public String getContractSourceTypeName() {
        return contractSourceTypeName;
    }

    public void setContractSourceTypeName(String contractSourceTypeName) {
        this.contractSourceTypeName = contractSourceTypeName;
    }
}
