package com.ejianc.business.profinance.odd.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 零星费用分配子表
 * 
 * @author generator
 * 
 */
@ApiModel("零星费用分配子表")
public class OddAllocationDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("创建者名称")
    private String createUserName;
    @ApiModelProperty("修改者名称")
    private String updateUserName;
    @ApiModelProperty("单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中")
    private Integer billState;
    @ApiModelProperty("主表主键")
    private Long pid;
    @ApiModelProperty("核算对象id")
    private Long wbsId;
    @ApiModelProperty("核算对象名称")
    private String wbsName;
    @ApiModelProperty("核算对象编号")
    private String wbsCode;
    @ApiModelProperty("成本科目id")
    private Long subjectId;
    @ApiModelProperty("成本科目名称")
    private String subjectName;
    @ApiModelProperty("成本科目编号")
    private String subjectCode;
    @ApiModelProperty("备注")
    private String detailMemo;
    @ApiModelProperty("分摊金额")
    private BigDecimal detailAllocatedTaxMny;
    @ApiModelProperty("分摊金额(无税)")
    private BigDecimal detailAllocatedMny;
    @ApiModelProperty("分摊比例")
    private BigDecimal detailAllocatedRatio;
    

    /**
     * 创建者名称
     */
    public String getCreateUserName() {
        return createUserName;
    }

    /**
     * 创建者名称
     */
    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    /**
     * 修改者名称
     */
    public String getUpdateUserName() {
        return updateUserName;
    }

    /**
     * 修改者名称
     */
    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    /**
     * 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 主表主键
     */
    public Long getPid() {
        return pid;
    }
    /**
     * 主表主键
     */

    public void setPid(Long pid) {
        this.pid = pid;
    }
    /**
     * 核算对象id
     */
    @ReferSerialTransfer(referCode = "subject-project-wbs-ref")
    public Long getWbsId() {
        return wbsId;
    }

    /**
     * 核算对象id
     */
    @ReferDeserialTransfer
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }
    /**
     * 核算对象名称
     */
    public String getWbsName() {
        return wbsName;
    }

    /**
     * 核算对象名称
     */
    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }
    /**
     * 核算对象编号
     */
    public String getWbsCode() {
        return wbsCode;
    }

    /**
     * 核算对象编号
     */
    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }
    /**
     * 成本科目id
     */
    @ReferSerialTransfer(referCode = "subject-project-org-ref")
    public Long getSubjectId() {
        return subjectId;
    }

    /**
     * 成本科目id
     */
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }
    /**
     * 成本科目名称
     */
    public String getSubjectName() {
        return subjectName;
    }

    /**
     * 成本科目名称
     */
    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }
    /**
     * 成本科目编号
     */
    public String getSubjectCode() {
        return subjectCode;
    }

    /**
     * 成本科目编号
     */
    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }
    /**
     * 备注
     */
    public String getDetailMemo() {
        return detailMemo;
    }

    /**
     * 备注
     */
    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }
    /**
     * 分摊金额
     */
    public BigDecimal getDetailAllocatedTaxMny() {
        return detailAllocatedTaxMny;
    }

    /**
     * 分摊金额
     */
    public void setDetailAllocatedTaxMny(BigDecimal detailAllocatedTaxMny) {
        this.detailAllocatedTaxMny = detailAllocatedTaxMny;
    }
    /**
     * 分摊金额(无税)
     */
    public BigDecimal getDetailAllocatedMny() {
        return detailAllocatedMny;
    }

    /**
     * 分摊金额(无税)
     */
    public void setDetailAllocatedMny(BigDecimal detailAllocatedMny) {
        this.detailAllocatedMny = detailAllocatedMny;
    }
    /**
     * 分摊比例
     */
    public BigDecimal getDetailAllocatedRatio() {
        return detailAllocatedRatio;
    }

    /**
     * 分摊比例
     */
    public void setDetailAllocatedRatio(BigDecimal detailAllocatedRatio) {
        this.detailAllocatedRatio = detailAllocatedRatio;
    }
    
}
