package com.ejianc.business.financial.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 印花税管理-明细表
 * 
 * @author generator
 * 
 */
public class StampDutyDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private Long pid; // 主表id
    private Long contractId; // 合同id
    private String contractCode; // 合同编号
    private String contractName; // 合同名称
    private String contractUrl; // 合同地址
    private String contractType; // 合同类型
    @JsonFormat(locale="zh", pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date fillingTime; // 归档日期
    private BigDecimal stampDutyRate; // 印花税率
    private BigDecimal stampDutyMoney; // 印花税额
    private BigDecimal stampDutyRateCheck; // 确认印花税率
    private BigDecimal stampDutyMoneyCheck; // 确认印花税额
    private String memo; // 备注
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private BigDecimal contractMny; // 合同无税金额

    private String operationUnitName; //经营单位
    private String stampOrgName; // 上级单位
    private String cwAccountCode; // 财务账套编号

    private BigDecimal contractMnyOld; // 原合同无税金额


    public BigDecimal getContractMnyOld() {
        return contractMnyOld;
    }

    public void setContractMnyOld(BigDecimal contractMnyOld) {
        this.contractMnyOld = contractMnyOld;
    }

    public String getOperationUnitName() {
        return operationUnitName;
    }

    public void setOperationUnitName(String operationUnitName) {
        this.operationUnitName = operationUnitName;
    }

    public String getStampOrgName() {
        return stampOrgName;
    }

    public void setStampOrgName(String stampOrgName) {
        this.stampOrgName = stampOrgName;
    }

    public String getCwAccountCode() {
        return cwAccountCode;
    }

    public void setCwAccountCode(String cwAccountCode) {
        this.cwAccountCode = cwAccountCode;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractUrl() {
        return contractUrl;
    }

    public void setContractUrl(String contractUrl) {
        this.contractUrl = contractUrl;
    }
    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
    public Date getFillingTime() {
        return fillingTime;
    }

    public void setFillingTime(Date fillingTime) {
        this.fillingTime = fillingTime;
    }
    public BigDecimal getStampDutyRate() {
        return stampDutyRate;
    }

    public void setStampDutyRate(BigDecimal stampDutyRate) {
        this.stampDutyRate = stampDutyRate;
    }
    public BigDecimal getStampDutyMoney() {
        return stampDutyMoney;
    }

    public void setStampDutyMoney(BigDecimal stampDutyMoney) {
        this.stampDutyMoney = stampDutyMoney;
    }
    public BigDecimal getStampDutyRateCheck() {
        return stampDutyRateCheck;
    }

    public void setStampDutyRateCheck(BigDecimal stampDutyRateCheck) {
        this.stampDutyRateCheck = stampDutyRateCheck;
    }
    public BigDecimal getStampDutyMoneyCheck() {
        return stampDutyMoneyCheck;
    }

    public void setStampDutyMoneyCheck(BigDecimal stampDutyMoneyCheck) {
        this.stampDutyMoneyCheck = stampDutyMoneyCheck;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    
}
