package com.ejianc.business.profinance.vo;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 一建大屏-实时付款情况返回VO
 */

public class PaymentApplyMnyTopVO implements Serializable {

	private Long id; // 付款申请Id
	private String billCode; // 单据编码
	private Long contractId; // 合同id
	private String contractType; //  “合同类别”(如果是”有合同付款 时) /“无合同费用类型”字段值(如果是”无合同付款”时)
	private Boolean prepaidFlag = false; // 是否预付款
	private BigDecimal actualMny = BigDecimal.ZERO; // 实际付款金额
	private String projectName; // 项目名称
	@JsonFormat(locale="zh", pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date applyDate;//申请日期

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public Long getContractId() {
		return contractId;
	}

	public void setContractId(Long contractId) {
		this.contractId = contractId;
	}

	public String getContractType() {
		return contractType;
	}

	public void setContractType(String contractType) {
		this.contractType = contractType;
	}

	public Boolean getPrepaidFlag() {
		return prepaidFlag;
	}

	public void setPrepaidFlag(Boolean prepaidFlag) {
		this.prepaidFlag = prepaidFlag;
	}

	public BigDecimal getActualMny() {
		return actualMny;
	}

	public void setActualMny(BigDecimal actualMny) {
		this.actualMny = actualMny;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public Date getApplyDate() {
		return applyDate;
	}

	public void setApplyDate(Date applyDate) {
		this.applyDate = applyDate;
	}
}
