/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.profinance.bean.SalaryEntity;
import com.ejianc.business.profinance.service.IGlodonSalaryService;
import com.ejianc.business.profinance.service.ISalaryDetailService;
import com.ejianc.business.profinance.service.ISalaryService;
import com.ejianc.business.profinance.utils.ReferTool;
import com.ejianc.business.profinance.vo.SalaryDetailVO;
import com.ejianc.business.profinance.vo.SalarySettleVO;
import com.ejianc.business.profinance.vo.SalaryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"salary"})
public class SalaryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISalaryService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISalaryDetailService salaryDetailService;
    @Autowired
    private IGlodonSalaryService glodonSalaryService;
    private static final String SALARY = "/salaryV2/pageV2";
    private static final String WORKER_DETAIL = "/salaryV2/detailV2";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SalaryVO> saveOrUpdate(@RequestBody SalaryVO salaryVO) {
        SalaryVO vo = this.service.insertOrUpdate(salaryVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SalaryVO> queryDetail(Long id) {
        SalaryEntity entity = (SalaryEntity)((Object)this.service.selectById(id));
        SalaryVO vo = (SalaryVO)BeanMapper.map((Object)((Object)entity), SalaryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SalaryVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SalaryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("salaryDetailSourceType");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SalaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<SalaryVO>> commonResponse = this.queryList(param);
        List salaryVOList = new ArrayList();
        if (null != commonResponse.getData()) {
            salaryVOList = ((IPage)commonResponse.getData()).getRecords();
        }
        HashMap beans = new HashMap();
        beans.put("records", salaryVOList);
        ExcelExport.getInstance().export("salary-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryTotalMny"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SalaryVO> queryTotalMny(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage salaryEntityIPage = this.service.queryPage(param);
        List salaryEntities = salaryEntityIPage.getRecords();
        BigDecimal reduce = salaryEntities.stream().filter(s -> s.getTotalSalaryMny() != null).map(SalaryEntity::getTotalSalaryMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        SalaryVO salaryVO = new SalaryVO();
        salaryVO.setSumMny(reduce);
        return CommonResponse.success((String)"\u83b7\u53d6\u5de5\u8d44\u6c47\u603b\u6210\u529f\uff01", (Object)salaryVO);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"salaryDetail-import.xlsx", (String)"\u5de5\u4eba\u5de5\u8d44\u5355-\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = this.service.excelImport(request, response);
        return commonResponse;
    }

    @RequestMapping(value={"/salaryDetailExcelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void salaryDetailExcelExport(@RequestBody Map paramMap, HttpServletResponse response) {
        String salaryId = String.valueOf(paramMap.get("salaryId"));
        SalaryEntity salaryEntity = (SalaryEntity)((Object)this.service.selectById((Serializable)((Object)salaryId)));
        List salaryDetailVOList = new ArrayList();
        if (null != salaryEntity && CollectionUtils.isNotEmpty(salaryEntity.getSalaryDetailList())) {
            salaryDetailVOList = BeanMapper.mapList(salaryEntity.getSalaryDetailList(), SalaryDetailVO.class);
        }
        if (CollectionUtils.isNotEmpty(salaryDetailVOList)) {
            salaryDetailVOList.forEach(salaryDetailVO -> {
                if (salaryDetailVO.getMeasureType() != null) {
                    switch (salaryDetailVO.getMeasureType()) {
                        case 0: {
                            salaryDetailVO.setMeasureTypeName("\u6309\u5929");
                            break;
                        }
                        case 1: {
                            salaryDetailVO.setMeasureTypeName("\u8ba1\u4ef6");
                            break;
                        }
                        case 2: {
                            salaryDetailVO.setMeasureTypeName("\u6309\u5c0f\u65f6");
                            break;
                        }
                        case 3: {
                            salaryDetailVO.setMeasureTypeName("\u6309\u6708");
                        }
                    }
                }
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", salaryDetailVOList);
        if (salaryEntity.getSalaryDetailSourceType().equals(1)) {
            ExcelExport.getInstance().export("salaryDetail-export.xlsx", beans, response);
        } else {
            ExcelExport.getInstance().export("synchronizeSalaryDetail-export.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/refGlodonSalaryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> refGlodonSalaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText, String relyCondition) {
        if (null == condition || StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        String year = (String)conditionMap.get("year");
        String month = (String)conditionMap.get("month");
        Map<String, Parameter> parameterMap = ReferTool.parseCondition(relyCondition);
        HashMap projectMap = new HashMap();
        parameterMap.keySet().forEach(key -> projectMap.put(key, String.valueOf(((Parameter)parameterMap.get(key)).getValue())));
        String projectId = (String)projectMap.get("glodonProjectId");
        if (StringUtils.isBlank((CharSequence)projectId)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u53c2\u6570\u9879\u76eeid-glodonProjectId\uff01");
        }
        if (StringUtils.isBlank((CharSequence)year)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u53c2\u6570\u5e74\u4efd-year\uff01");
        }
        if (StringUtils.isBlank((CharSequence)month)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u53c2\u6570\u6708\u4efd-month\uff01");
        }
        JSONObject page = this.glodonSalaryService.getSalary(projectId, year, month);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/getGlodonSalaryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SalaryDetailVO>> getGlodonSalaryDetail(String projectId, String year, String month, String ids) {
        List<SalaryDetailVO> salaryDetailVOList = this.glodonSalaryService.getSalaryDetail(projectId, null, year, month, ids);
        return CommonResponse.success((String)"\u67e5\u8be2\u5de5\u4eba\u5de5\u8d44\u8be6\u60c5\u6210\u529f\uff01", salaryDetailVOList);
    }

    @RequestMapping(value={"/refSalaryDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SalaryDetailVO>> refSalaryDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        if (null == condition || StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        String contractId = (String)conditionMap.get("contractId");
        if (StringUtils.isBlank((CharSequence)contractId)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u53c2\u6570\u5408\u540cid-contractId\uff01");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        Page pageData = new Page();
        List salaryEntityList = this.service.queryList(param, false);
        ArrayList<Long> ids = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)salaryEntityList)) {
            for (SalaryEntity salaryEntity : salaryEntityList) {
                ids.add(salaryEntity.getId());
            }
            if (CollectionUtils.isNotEmpty(ids)) {
                QueryParam detailParam = new QueryParam();
                List fuzzyFields = detailParam.getFuzzyFields();
                fuzzyFields.add("salaryBillCode");
                fuzzyFields.add("belongMonth");
                fuzzyFields.add("workerName");
                fuzzyFields.add("teamName");
                fuzzyFields.add("groupName");
                fuzzyFields.add("bankName");
                fuzzyFields.add("workerIdCard");
                fuzzyFields.add("accountNum");
                detailParam.setPageSize(pageSize.intValue());
                detailParam.setPageIndex(pageNumber.intValue());
                detailParam.setSearchText(searchText);
                detailParam.setSearchObject(searchObject);
                detailParam.getParams().put("salary_id", new Parameter("in", ids));
                detailParam.getParams().put("worker_remainder_tax_mny", new Parameter("gt", (Object)0));
                IPage detailPage = this.salaryDetailService.queryPage(detailParam, false);
                pageData = new Page(detailPage.getCurrent(), detailPage.getSize(), detailPage.getTotal());
                pageData.setRecords(BeanMapper.mapList((Iterable)detailPage.getRecords(), SalaryDetailVO.class));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refSalaryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SalarySettleVO>> refSalaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        if (null == condition || StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        JSONObject _con = JSONObject.parseObject((String)condition);
        String contractId = _con.getString("contractId");
        if (StringUtils.isBlank((CharSequence)contractId)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u53c2\u6570\u5408\u540cid-contractId\uff01");
        }
        String settleDate = _con.getString("settleDate");
        if (StringUtils.isBlank((CharSequence)settleDate)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u53c2\u6570\u7ed3\u7b97\u65f6\u95f4-settleDate\uff01");
        }
        String settleType = _con.getString("settleType");
        if (StringUtils.isBlank((CharSequence)settleType)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u7f3a\u5c11\u53c2\u6570\u7ed3\u7b97\u7c7b\u578b-settleType\uff01");
        }
        String settleId = _con.getString("settleId");
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.eq(SalaryEntity::getContractId, (Object)contractId);
        lambda.in(SalaryEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        lambda.le(SalaryEntity::getBelongMonth, (Object)settleDate);
        if ("0".equals(settleType)) {
            if (StringUtils.isNotBlank((CharSequence)settleId)) {
                lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.isNull(SalaryEntity::getSettleId)).or(c -> (LambdaQueryWrapper)c.eq(SalaryEntity::getSettleId, (Object)settleId)));
            } else {
                lambda.isNull(SalaryEntity::getSettleId);
            }
        }
        lambda.orderByDesc(SalaryEntity::getBelongMonth);
        IPage salaryEntityIPage = this.service.page((IPage)new Page((long)pageNumber.intValue(), (long)pageSize.intValue()), (Wrapper)lambda);
        Page pageData = new Page(salaryEntityIPage.getCurrent(), salaryEntityIPage.getSize(), salaryEntityIPage.getTotal());
        List salaryEntityList = salaryEntityIPage.getRecords();
        ArrayList<SalarySettleVO> salarySettleVOList = new ArrayList<SalarySettleVO>();
        if (CollectionUtils.isNotEmpty((Collection)salaryEntityList)) {
            for (SalaryEntity salaryEntity : salaryEntityList) {
                SalarySettleVO salarySettleVO = new SalarySettleVO();
                salarySettleVO.setBelongMonth(salaryEntity.getBelongMonth());
                salarySettleVO.setContractId(salaryEntity.getContractId());
                salarySettleVO.setSalaryMny(salaryEntity.getTotalSalaryMny());
                salarySettleVO.setSumSalaryMny(salaryEntity.getTotalSalaryMny());
                salarySettleVO.setSourceId(salaryEntity.getId());
                salarySettleVO.setSourceBillCode(salaryEntity.getBillCode());
                salarySettleVOList.add(salarySettleVO);
            }
        }
        pageData.setRecords(salarySettleVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

