/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.profinance.plan.bean.PlanFeeEntity;
import com.ejianc.business.profinance.plan.mapper.PlanFeeMapper;
import com.ejianc.business.profinance.plan.service.IPlanFeeService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="planFeeService")
public class PlanFeeServiceImpl
extends BaseServiceImpl<PlanFeeMapper, PlanFeeEntity>
implements IPlanFeeService {
    private static final String FEE_ID = "fee_id";

    @Override
    public void updateBillState(Long planId, Integer billStateCode) {
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(PlanFeeEntity::getPlanId, (Object)planId);
        updateWrapper.set(PlanFeeEntity::getBillState, (Object)billStateCode);
        updateWrapper.set(PlanFeeEntity::getBillStateName, (Object)BillStateEnum.getEnumByStateCode((Integer)billStateCode).getDescription());
        super.update((Wrapper)updateWrapper);
    }

    @Override
    public Map<String, Object> fetchFeeValue(Collection<Long> feeIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.in((Object)FEE_ID, feeIds);
        queryWrapper.groupBy((Object[])new String[]{FEE_ID});
        queryWrapper.select(new String[]{"fee_id as feeId,ifnull(sum(fee_plan_payment_mny), 0) as feeAppliedMny"});
        List resultMap = super.listMaps((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)resultMap)) {
            return this.converToMap(resultMap);
        }
        return result;
    }

    private Map<String, Object> converToMap(List<Map<String, Object>> listMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Map<String, Object> map : listMap) {
            if (resultMap.containsKey(map.get("feeId").toString())) continue;
            resultMap.put(map.get("feeId").toString(), map.get("feeAppliedMny").toString());
        }
        return resultMap;
    }
}

