/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.pool.enums.ContractFlagEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleUltimateFlagEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.profinance.bean.ContractLawsuitEntity;
import com.ejianc.business.profinance.mapper.ContractLawsuitMapper;
import com.ejianc.business.profinance.service.IContractLawsuitService;
import com.ejianc.business.profinance.service.IContractLawsuitSubSettleService;
import com.ejianc.business.profinance.vo.ContractLawsuitVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="contractLawsuitService")
public class ContractLawsuitServiceImpl
extends BaseServiceImpl<ContractLawsuitMapper, ContractLawsuitEntity>
implements IContractLawsuitService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractLawsuitSubSettleService contractLawsuitSubSettleService;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;
    private static final String BILL_CODE = "CON_LASWUIT";

    @Override
    public BigDecimal queryTotalLawsuitMny(Long contractId) {
        Map<String, BigDecimal> resp = new HashMap();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)contractId));
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter("in", billStateList));
        QueryWrapper wrapper = ContractLawsuitServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"sum(lawsuit_work_mny) as lawsuitWorkMny"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("lawsuitWorkMny", BigDecimal.ZERO);
        }
        return (BigDecimal)resp.get("lawsuitWorkMny");
    }

    @Override
    public String pushLawsuitToPool(ContractLawsuitVO s) {
        SettlePoolVO spv = new SettlePoolVO();
        String pushResult = null;
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb");
            BeanConvertorUtil.convert((Object)s, (Object)spv);
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u7ed3\u675f\uff0c\u4e0b\u9762\u5f00\u59cb\u624b\u52a8\u8f6c\u6362");
            spv.setSourceType(SettleSourceTypeEnum.\u8bc9\u8bbc\u8d39\u7ed3\u7b97.getCode());
            spv.setSettleProperty(Integer.valueOf(0));
            spv.setUltimateFlag(Integer.valueOf(0));
            spv.setCurMny(s.getSettleMny());
            spv.setCurTax(BigDecimal.ZERO);
            spv.setCreateTime(s.getCreateTime());
            spv.setCreateUserCode(s.getCreateUserCode());
            spv.setBillCodeUrl("/ejc-profinance-frontend/#/lawsuitList/card?id=" + s.getId());
            spv.setHandleType(Integer.valueOf(0));
            spv.setContractFlag(ContractFlagEnum.\u6709\u5408\u540c\u7ed3\u7b97.getContractFlagCode());
            spv.setContractFlagName(ContractFlagEnum.\u6709\u5408\u540c\u7ed3\u7b97.getContractFlagCodeName());
            spv.setUltimateFlag(SettleUltimateFlagEnum.\u975e\u6700\u7ec8\u7ed3\u7b97.getCode());
            CommonResponse categoryResp = this.templateCategoryApi.queryTmplCategoryById(s.getContractCategoryId());
            if (!categoryResp.isSuccess()) {
                return "\u63a8\u9001\u5931\u8d25\uff0c\u83b7\u53d6\u5408\u540c\u5206\u7c7b\u4fe1\u606f\u5931\u8d25\uff01";
            }
            spv.setContractType(((TemplateCategoryVO)categoryResp.getData()).getCategoryProperty());
            spv.setContractTypeName(((TemplateCategoryVO)categoryResp.getData()).getpName());
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61:[{}] -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5b8c\u6210\uff0c\u4e0b\u9762\u5f00\u59cb:[{}]\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60", (Object)JSONObject.toJSONString((Object)s), (Object)JSONObject.toJSONString((Object)spv));
            CommonResponse res = this.settlePoolApi.saveOrUpdateSettle(spv);
            if (res.isSuccess()) {
                this.executeUpdatePool(s.getId(), true);
                this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u6210\u529f\uff01\u7ed3\u7b97\u5355id-{}", (Object)s.getId());
            } else {
                this.executeUpdatePool(s.getId(), false);
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)s.getId(), (Object)JSONObject.toJSONString((Object)res));
                pushResult = "\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25";
            }
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)s.getId(), (Object)e);
            pushResult = "\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25";
        }
        return pushResult;
    }

    @Override
    public void executeUpdatePool(Long id, Boolean flag) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)id);
        if (Boolean.TRUE.equals(flag)) {
            updateWrapper.set((Object)"push_pool_flag", (Object)BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        } else {
            updateWrapper.set((Object)"push_pool_flag", (Object)BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        super.update((Wrapper)updateWrapper);
    }

    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        spv.setSourceId(id);
        CommonResponse res = this.settlePoolApi.deleteSettle(spv);
        if (res.isSuccess()) {
            this.logger.info("\u5c06\u7ed3\u7b97\u5355\u4ece\u7ed3\u7b97\u6c60\u4e2d\u5220\u9664\u6210\u529f\uff01\u7ed3\u7b97\u5355id-{}", (Object)id);
            return true;
        }
        this.logger.error("\u5c06\u7ed3\u7b97\u5355\u4ece\u7ed3\u7b97\u6c60\u4e2d\u5220\u9664\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)id, (Object)res.getMsg());
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ContractLawsuitVO saveContractLawsuitVO(ContractLawsuitVO saveOrUpdateVO) {
        ContractLawsuitEntity entity = (ContractLawsuitEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ContractLawsuitEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setRelationFlag("0");
            entity.setProportionFlag("0");
        } else {
            this.contractLawsuitSubSettleService.deleteByLawsuitId(saveOrUpdateVO.getId());
        }
        super.saveOrUpdate((Object)entity, false);
        ContractLawsuitVO vo = (ContractLawsuitVO)BeanMapper.map((Object)((Object)entity), ContractLawsuitVO.class);
        return vo;
    }

    @Override
    public void costPush(ContractLawsuitEntity entity) {
        boolean b;
        this.logger.info("\u5f00\u59cbcostPush");
        String newRelationFlag = this.associatedFlag(entity);
        this.logger.info("newRelationFlag---{}", (Object)newRelationFlag);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        updateWrapper.set(ContractLawsuitEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = entity.getRelationFlag();
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                this.saveCost(entity);
            }
            if (!"1".equals(newRelationFlag)) {
                this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u9886\u6599\u51fa\u5e93Id---{}", (Object)entity.getId());
                CommonResponse commonResponse = this.costDetailApi.deleteSubject(entity.getId());
                this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)commonResponse));
                if (!commonResponse.isSuccess()) {
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        if ("0".equals(oldRelationFlag) && "1".equals(newRelationFlag) && !(b = this.saveCost(entity))) {
            throw new BusinessException("\u7f51\u7edc\u9519\u8bef \u63a8\u9001\u5b9e\u9645\u6210\u672c\u5931\u8d25");
        }
    }

    @Override
    public void costDeletePush(ContractLawsuitEntity entity) {
        this.logger.info("\u5f03\u5ba1\u63a8\u9001\u6210\u672c---");
        this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u7ed3\u7b97\u5355Id---{}", (Object)entity.getId());
        CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(entity.getId());
        this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        updateWrapper.set(ContractLawsuitEntity::getRelationFlag, (Object)"0");
        super.update((Wrapper)updateWrapper);
    }

    @Override
    public CommonResponse<ContractLawsuitVO> pushCost(ContractLawsuitVO vo) {
        ContractLawsuitEntity entity = (ContractLawsuitEntity)((Object)((ContractLawsuitMapper)this.baseMapper).selectById(vo.getId()));
        entity.setProjectWbsCode(vo.getProjectWbsCode());
        entity.setProjectWbsName(vo.getProjectWbsName());
        entity.setProjectWbsId(vo.getProjectWbsId());
        entity.setCostOfCourseCode(vo.getCostOfCourseCode());
        entity.setCostOfCourseName(vo.getCostOfCourseName());
        entity.setCostOfCourseId(vo.getCostOfCourseId());
        super.saveOrUpdate((Object)entity, false);
        this.costPush(entity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), ContractLawsuitVO.class));
    }

    private String associatedFlag(ContractLawsuitEntity entity) {
        String newRelationFlag = "1";
        if (null == entity.getProjectWbsId() || null == entity.getCostOfCourseId()) {
            newRelationFlag = "0";
        }
        return newRelationFlag;
    }

    private boolean saveCost(ContractLawsuitEntity entity) {
        this.logger.info("\u63a8\u9001\u8bc9\u8bbc\u7ed3\u7b97\u5b9e\u4f53\uff1a" + JSONObject.toJSONString((Object)((Object)entity)));
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        CostDetailVO costDetailVO = new CostDetailVO();
        costDetailVO.setSubjectId(entity.getCostOfCourseId());
        costDetailVO.setSubjectCode(entity.getCostOfCourseCode());
        costDetailVO.setSubjectName(entity.getCostOfCourseName());
        costDetailVO.setWbsId(entity.getProjectWbsId());
        costDetailVO.setWbsCode(entity.getProjectWbsCode());
        costDetailVO.setWbsName(entity.getProjectWbsName());
        costDetailVO.setSourceId(entity.getId());
        costDetailVO.setSourceDetailId(entity.getId());
        costDetailVO.setHappenTaxMny(entity.getOtherLawsuitMny());
        costDetailVO.setHappenMny(entity.getOtherLawsuitMny());
        costDetailVO.setSourceTabType("SET_LAWSUIT");
        costDetailVO.setSourceBillUrl("/ejc-profinance-frontend/#/lawsuitList/card?id=" + entity.getId());
        costDetailVO.setSourceBillCode(entity.getBillCode());
        costDetailVO.setSourceBillName("\u8bc9\u8bbc\u8d39\u7ed3\u7b97");
        costDetailVO.setSourceType("LAWSUIT_SET");
        costDetailVO.setHappenDate(entity.getSettleDate());
        costDetailVO.setCreateUserName(entity.getCreateUserCode());
        costDetailVO.setProjectId(entity.getProjectId());
        costDetailVOList.add(costDetailVO);
        if (CollectionUtils.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------\uff1a{}", (Object)JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------\uff1a{}", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                this.logger.error("\u7f51\u7edc\u9519\u8bef \u63a8\u9001\u5b9e\u9645\u6210\u672c\u5931\u8d25 \u5931\u8d25\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
                throw new BusinessException(JSONObject.toJSONString((Object)stringCommonResponse));
            }
        }
        return true;
    }
}

