/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.profinance.bean.PaymentApplyEntity;
import com.ejianc.business.profinance.service.IPaymentApplyService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="paymentApply")
public class PaymentApplyBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IPaymentApplyService service;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success((String)"\u4ed8\u6b3e\u7533\u8bf7-\u63d0\u4ea4\u524d\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PaymentApplyEntity entity = (PaymentApplyEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            // empty if block
        }
        entity.setActualApplyMny(entity.getApprovalMny());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4ed8\u6b3e\u7533\u8bf7\u7ec8\u5ba1\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u636ebillId-{}, state-{}, billTypeCode-{}\u64a4\u56de\u524d\u6821\u9a8c", new Object[]{billId, state, billTypeCode});
        PaymentApplyEntity paymentApplyEntity = (PaymentApplyEntity)((Object)this.service.selectById(billId));
        if (paymentApplyEntity == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u636e\u4fe1\u606f\uff01");
        }
        this.logger.info("\u64a4\u56de\u524d\u4ed8\u6b3e\u7533\u8bf7\u5b9e\u4f53\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)paymentApplyEntity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        if (paymentApplyEntity.getPaymentContractFlag() == 0) {
            QueryWrapper listQuery = new QueryWrapper();
            listQuery.eq((Object)"contract_id", (Object)paymentApplyEntity.getContractId());
            listQuery.eq((Object)"bill_state", (Object)BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            int resultCount = this.service.count((Wrapper)listQuery);
            if (resultCount > 0) {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5df2\u5b58\u5728\u81ea\u7531\u6001\u7684\u4ed8\u6b3e\u7533\u8bf7 \u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
            }
        }
        if (null != paymentApplyEntity.getCloseState() && paymentApplyEntity.getCloseState().equals(1)) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
        }
        if (null != paymentApplyEntity.getPaymentStatus() && paymentApplyEntity.getPaymentStatus().equals(2)) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u4ed8\u6b3e\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        if (paymentApplyEntity.getActualMny() != null && paymentApplyEntity.getActualMny().compareTo(BigDecimal.ZERO) == 1) {
            return CommonResponse.error((String)"\u5f53\u524d\u4ed8\u6b3e\u5355\u5df2\u5b58\u5728\u5b9e\u9645\u652f\u4ed8\u91d1\u989d\u65e0\u6cd5\u5f03\u5ba1");
        }
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }
}

