package com.ejianc.business.profinance.plan.service;

import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.profinance.plan.bean.PlanFeeEntity;

import java.util.Collection;
import java.util.Map;

/**
 * 项目资金计划-零星费用
 *
 * @author generator
 */
public interface IPlanFeeService extends IBaseService<PlanFeeEntity> {


	/**
	 * 根据项目资金计划id，修改项目资金计划-零星费用的单据状态
	 *
	 * @param planId        项目资金计划id
	 * @param billStateCode 单据状态
	 */
	void updateBillState(Long planId, Integer billStateCode);

	/**
	 * 已申请金额(不含本次)=根据零星费用单ids查询所有审批通过或已提交的【项目资金计划】-【零星费用】页签数据，统计该结算单的“本次计划付款金额”
	 *
	 * @param feeIds 零星费用单ids
	 *
	 * @return 已申请金额(不含本次)
	 */
	Map<String, Object> fetchFeeValue(Collection<Long> feeIds);
}
