package com.ejianc.business.profinance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.profinance.utils.DBUtil2;
import com.ejianc.business.profinance.utils.DynamicDataSourceDruidUtil;
import com.ejianc.business.profinance.utils.ResultAsTreeNew;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.sql.DataSource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ncc数据参照
 *
 * @author CJ
 * @Description:
 * @date 2023/9/22 15:30
 */
@RestController
@RequestMapping(value = "/nccData/")
public class NccDataController {

    private static final String IP = "10.70.2.127";
    private static final String PORT = "1521";
    private static final String DBNAME = "orcl";
    private static final String USERNAME = "sjxmgl";
    private static final String DRIVER = "oracle.jdbc.OracleDriver";
    private static final String DATABASETYPE = "Oracle";
    private static final String PASSWORD = "Sj#2j#xmGl";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * ncc银行分类树参照
     *
     * @return
     */
    @GetMapping(value = "getNCCPayBankTypeList")
    public List<JSONObject> getNCCPayBankTypeList() {
        return null;
    }


    /**
     * Ncc银行份分页列表
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @GetMapping(value = "getNCCPayBankList")
    public CommonResponse<IPage<JSONObject>> getNCCPayBankList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                            String condition,
                                                            String searchObject,
                                                            String searchText) {
        return null;
    }

    /**
     * 分页获取供应商银行账号信息列表
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @GetMapping(value = "getNCCRecBankList")
    public CommonResponse<IPage<JSONObject>> getNCCRecBankList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        return null;
    }

    /**
     * 分页获取NCC用户信息列表
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @GetMapping(value = "getNCCUserList")
        public CommonResponse<IPage<JSONObject>> getNCCUserList(@RequestParam Integer pageNumber,
                                                            @RequestParam Integer pageSize,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        IPage<JSONObject> pageData = null;
        JSONObject resp = new JSONObject();
        resp.put("current",pageNumber);//当前页
        resp.put("size",pageSize);//当前页多少数据
        resp.put("pages",1);//可以分多少页
        resp.put("total",0);//多少页数据
        StringBuilder sql  = new StringBuilder("SELECT USER_CODE AS id, USER_NAME AS name ," +
                "USER_CODE AS code,SUBSTR(ORGCODE, 0, LENGTH(ORGCODE)-1) AS orgId,ORGCODE AS orgCode,ORGNAME AS orgName");
        sql.append(" FROM NCC2105. V_ERJIAN_USER")
                .append(" WHERE (ORGCODE like '101021%' OR ORGCODE = '10102Z')");
        if (null!=searchText){
            sql.append("AND USER_NAME like '%"+searchText+"%'")
                    .append("AND USER_CODE like '%"+searchText+"%'")
                    .append("AND ORGCODE like '%"+searchText+"%'")
                    .append("AND ORGNAME like '%"+searchText+"%'");
        }
        sql.append("AND rownum  between (" +pageNumber+"-1)*"+pageSize+"+1 and "+pageNumber+"*"+pageSize)
                .append(" ORDER BY USER_CODE");
        //分页查询 数据
        List<Map<String, Object>> list = queryBySql(sql.toString());
        if (CollectionUtils.isEmpty(list)){
            pageData = new Page<>(pageNumber, pageSize, 0);
            return CommonResponse.success("",pageData);
        }
        List<JSONObject> record = new ArrayList<>();
        for (Map m:list){
            JSONObject j = new JSONObject();
            j.put("id",m.get("ID"));
            j.put("name",m.get("NAME"));
            j.put("code",m.get("CODE"));
            j.put("orgId",m.get("ORGID"));
            j.put("orgCode",m.get("ORGCODE"));
            j.put("orgName",m.get("ORGNAME"));
            record.add(j);
        }
        //查询条数
        String countSql = "select COUNT(CUSERID) from NCC2105. V_ERJIAN_USER";
        List<Map<String, Object>> countList = queryBySql(countSql);
        long count = ((BigDecimal) countList.get(0).get("COUNT(CUSERID)")).longValue();
        pageData = new Page<>(pageNumber, pageSize, count);
        pageData.setRecords(record);
        return CommonResponse.success("查询数据成功",pageData);
    }


    /**
     * ncc财务项目基本分类树参照
     *
     * @return
     */
    @GetMapping(value = "getNCCProjectTypeTree")
    public List<Map<String, Object>> getNCCProjectTypeTree() {

        StringBuilder sql = new StringBuilder("SELECT DISTINCT PK_EPS AS \"Id\", EPS_CODE AS \"CODE\", EPS_NAME AS \"name\" ");
        sql.append(" FROM NCC2105.V_ERJIAN_PROJECT ORDER BY LENGTH(CODE),CODE ASC");

        return queryBySql(sql.toString());
    }


    /**
     * Ncc财务项目分页列表
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping(value = "getNCCFinancialOrgProjectList")
    public CommonResponse<IPage<JSONObject>> getNCCFinancialOrgProjectList(@RequestParam Integer pageNumber,
                                                                           @RequestParam Integer pageSize,
                                                                           String condition,
                                                                           String searchText) {
        int startLine = (pageNumber - 1) < 0 ? 0 : pageNumber - 1;


        StringBuilder sql = new StringBuilder("SELECT * FROM ( SELECT DISTINCT");
        sql.append(" PK_PROJECT AS \"nccPK\",")
           .append(" PROJECT_CODE AS \"code\",")
           .append(" PROJECT_NAME AS \"name\",")
           .append(" regexp_substr ( PROJECT_CODE, '[0-9]+' ) AS \"id\" ")
           .append(" ROW_NUMBER() OVER (ORDER BY LENGTH(PROJECT_CODE),PROJECT_CODE) AS rn")
           .append(" FROM NCC2105.V_ERJIAN_PROJECT")
           .append(" WHERE 1 = 1");

        if(StringUtils.isNotBlank(condition)) {
            JSONObject param = com.alibaba.fastjson.JSONObject.parseObject(condition);
            if(null != param.get("typeId")) {
                sql.append(" AND PK_EPS =").append(" '").append(param.getString("typeId")).append("'");
            }
        }

       if(StringUtils.isNotBlank(searchText)) {
           sql.append(" AND (PROJECT_CODE LIKE '%").append(searchText).append("%'")
              .append(" OR AND PROJECT_NAME LIKE '%").append(searchText).append("%'");
       }
       sql.append(" ) WHERE rn BETWEEN ").append(startLine * pageSize).append(" AND ").append((startLine+1) * pageSize);
        return null;
    }

    /**
     * 查询财务组织树
     *
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping(value = "getNCCFinancialOrgTree")
    public List<Map<String, Object>> getNCCFinancialOrgTree(@RequestParam(required = false) String condition,
                                                            @RequestParam(required = false) String searchText) {

        StringBuilder sql = new StringBuilder("SELECT SUBSTR(code, 0, LENGTH(CODE)-1) AS \"id\", PK_ORG AS \"nccPK\", CODE AS \"code\", CODE || ' ' || NAME AS \"name\",PK_FATHERORG AS \"nccPid\"");
        sql.append(" FROM NCC2105.V_ERJIAN_ORG")
            .append(" WHERE (CODE like '101021%' OR CODE = '10102Z')")
            .append(" START WITH CODE = '10102Z'")
            .append(" CONNECT BY PRIOR PK_ORG = PK_FATHERORG")
            .append(" ORDER BY LENGTH(CODE),CODE");

        List<Map<String, Object>> orgList = queryBySql(sql.toString());
        return ResultAsTreeNew.createTreeData(orgList, "nccPid", "nccPK");

    }
    public List<Map<String, Object>> queryBySql(String sql) {
        List<Map<String, Object>> list = new ArrayList<>();
        Map<String, Object> map = new HashMap();
        map.put("ip",IP);
        map.put("port",PORT);
        map.put("dbName",DBNAME);
        map.put("userName",USERNAME);
        map.put("driver",DRIVER);
        map.put("databaseType",DATABASETYPE);
        map.put("password",PASSWORD);
        DataSource dataSource = DynamicDataSourceDruidUtil.getDataSource(map);
        DBUtil2 db = new DBUtil2(dataSource);
        try {
            list = db.queryForListCommonMethod(sql);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}
