package com.ejianc.business.profinance.mapper;

import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.profinance.bean.SalaryPayApplyDetailEntity;
import org.apache.ibatis.annotations.Param;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 工人工资支付申请子实体
 *
 * @author generator
 */
@Mapper
public interface SalaryPayApplyDetailMapper extends BaseCrudMapper<SalaryPayApplyDetailEntity> {

    // 根据ID批量更新工人工资支付申请子表的支付结果（即支付状态）和支付日期字段
    int updatePayStateByIds(@Param("idList") List<Long> idList, @Param("payState") Integer payState, @Param("payDate") Date payDate);

    // 查询当前申请单下最新的成功的工人工资清单记录
    Date queryMaxPaySucDate(@Param("pid") Serializable pid, @Param("tenantId") Long tenantId);
}
