package com.ejianc.business.report.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.procost.vo.HandshareDetailVO;
import com.ejianc.business.profinance.bean.PaymentApplyEntity;
import com.ejianc.business.profinance.bean.PaymentRegisterEntity;
import com.ejianc.business.profinance.bean.SalaryPayApplyEntity;
import com.ejianc.business.profinance.service.IPaymentApplyService;
import com.ejianc.business.profinance.service.IPaymentRegisterService;
import com.ejianc.business.profinance.service.ISalaryPayApplyService;
import com.ejianc.business.report.mapper.ProjectReportMapper;
import com.ejianc.business.report.service.IProjectReportService;
import com.ejianc.business.report.vo.CostAndActualOutVO;
import com.ejianc.business.report.vo.IncomeContractVO;
import com.ejianc.business.report.vo.ProjectReportVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class ProjectReportServiceImpl implements IProjectReportService {

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IPaymentApplyService paymentApplyService;

    @Autowired
    private IPaymentRegisterService paymentRegisterService;

    @Autowired
    private IShareSubjectOrgApi subjectOrgApi;

    private String PROJECT_SETTLE_RANGE_PARAM = "P-zF77230174";

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private ISalaryPayApplyService salaryPayApplyService;

    @Autowired
    private ProjectReportMapper mapper;


    @Override
    public IPage<ProjectReportVO> queryProjectCount(QueryParam param){

        IPage<ProjectPoolSetVO> resp = projectPoolApi.queryProjectIPage(param).getData();
        IPage<ProjectReportVO> page = new Page<>(resp.getCurrent(), resp.getSize(), resp.getTotal());

        List<ProjectReportVO> projectReportVOS = BeanMapper.mapList(resp.getRecords(), ProjectReportVO.class);
        List<Long> projectIds = projectReportVOS.stream().map(ProjectReportVO::getId).collect(Collectors.toList());

        //没有项目就直接返回空数据
        if (CollectionUtils.isEmpty(projectReportVOS)){
            return page;
        }

        //变更后施工合同金额
        List<IncomeContractVO> incomeContractVOS = mapper.queryIncomeContractMny(projectIds);
        projectReportVOS = projectReportVOS.stream().map(e1 -> {
            incomeContractVOS.stream().filter(e2 -> e1.getId().equals(e2.getProjectId())).forEach(e2 -> {
                e1.setApplyChangeTaxMny(e2.getSumContractTaxMny());
                e1.setNoZlMny(ComputeUtil.safeAdd(e2.getSumNotIncludeProvisionalMny(),e2.getSumSupplementTaxMny()));
            });
            return e1;
        }).collect(Collectors.toList());

        //原施工合同金额
        List<Map<String, Object>> costAdjustList = mapper.queryCostAdjustTaxMny(projectIds);
        projectReportVOS = projectReportVOS.stream().map(e1 -> {
            costAdjustList.stream().filter(e2 -> e1.getId().equals(e2.get("projectId"))).forEach(e2 -> {
                e1.setIncomeContractTaxMny((BigDecimal) e2.get("sumApplyChangeTaxMny"));
            });
            return e1;
        }).collect(Collectors.toList());


        //工程造价金额
//        List<Map<String, Object>> costAdjustMoneyList = mapper.queryCostAdjustMoney(projectIds);
//        projectReportVOS = projectReportVOS.stream().map(e1 -> {
//            costAdjustMoneyList.stream().filter(e2 -> e1.getId().equals(e2.get("projectId"))).forEach(e2 -> {
//                e1.setTotalCostAdjustTaxMny(ComputeUtil.safeAdd(e1.getIncomeContractTaxMny(),(BigDecimal) e2.get("sumTotalCostAdjustTaxMny")));
//            });
//            return e1;
//        }).collect(Collectors.toList());
        //工程变更金额
        List<Map<String, Object>> costAdjustMoneyList = mapper.queryProjectChangeTaxMny(projectIds);
        projectReportVOS = projectReportVOS.stream().map(e1 -> {
            costAdjustMoneyList.stream().filter(e2 -> e1.getId().equals(e2.get("projectId"))).forEach(e2 -> {
                e1.setProjectChangeTaxMny(ComputeUtil.safeAdd(e1.getProjectChangeTaxMny(),(BigDecimal) e2.get("projectChangeTaxMny")));
            });
            return e1;
        }).collect(Collectors.toList());

        //定案金额
        List<Map<String, Object>> finalizedList = mapper.queryCheckTaxMny(projectIds);
        projectReportVOS = projectReportVOS.stream().map(e1 -> {
            finalizedList.stream().filter(e2 -> e1.getId().equals(e2.get("projectId"))).forEach(e2 -> {
                e1.setCheckTaxMny((BigDecimal) e2.get("sumCheckTaxMny"));
            });
            return e1;
        }).collect(Collectors.toList());

        //变更后收入预算
        List<Map<String, Object>> BudgetList = mapper.queryBudgetTaxMny(projectIds);
        projectReportVOS = projectReportVOS.stream().map(e1 -> {
            BudgetList.stream().filter(e2 -> e1.getId().equals(e2.get("projectId"))).forEach(e2 -> {
                e1.setBudgetTaxMny((BigDecimal) e2.get("sumBudgetTaxMny"));
            });
            return e1;
        }).collect(Collectors.toList());

        //变更后施工合同额或工程造价
        for (ProjectReportVO reportVO : projectReportVOS){
            reportVO.setNoZlMnyAndApplyChangeTaxMny(reportVO.getApplyChangeTaxMny());
        }


        page.setRecords(projectReportVOS);
        return page;

    }


    public List<CostAndActualOutVO> queryProjectCostAndActualOut(Long projectId,BigDecimal changeAndcostTaxMny){

        CostAndActualOutVO targetCost = queryTargetCost(projectId,changeAndcostTaxMny);
        CostAndActualOutVO payContract = queryPayContract(projectId,changeAndcostTaxMny);
        CostAndActualOutVO settle = querySettle(projectId,changeAndcostTaxMny);
        CostAndActualOutVO paymentApply = queryPaymentApply(projectId,changeAndcostTaxMny);
        CostAndActualOutVO paymentRegister = queryPaymentRegister(projectId,changeAndcostTaxMny);

        List<CostAndActualOutVO> list = new ArrayList<>();
        list.add(targetCost);
        list.add(payContract);
        list.add(settle);
        list.add(paymentApply);
        list.add(paymentRegister);

        return list;
    }

    public CostAndActualOutVO queryTargetCost(Long projectId,BigDecimal changeAndcostTaxMny){

        BigDecimal totalTaxMny = BigDecimal.ZERO;
        BigDecimal lwfTaxMny = BigDecimal.ZERO;
        BigDecimal clfTaxMny = BigDecimal.ZERO;
        BigDecimal jxsbfTaxMny = BigDecimal.ZERO;
        BigDecimal zyfbfTaxMny = BigDecimal.ZERO;
        BigDecimal qtzjfTaxMny = BigDecimal.ZERO;
        BigDecimal jjfTaxMny = BigDecimal.ZERO;
        BigDecimal taxMny = BigDecimal.ZERO;

        List<Map<String,Object>> targetCost = mapper.queryTargetCostByProjectId(projectId);
        List<Long> targetCostIds = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(targetCost)){
            totalTaxMny = targetCost.stream().map(e -> null != e.get("taxMny") ? (BigDecimal)e.get("taxMny") : BigDecimal.ZERO).reduce(ComputeUtil::safeAdd).get();
            targetCostIds = targetCost.stream().map(e -> (Long)e.get("id")).collect(Collectors.toList());
        }

        if (CollectionUtils.isNotEmpty(targetCostIds)){
            List<Map<String, Object>> targetCostDetailList = mapper.queryTargetCostDetailByIds(targetCostIds);
            for (Map<String, Object> map : targetCostDetailList){
                if ("01".equals(map.get("code").toString())){
                    lwfTaxMny = (BigDecimal) map.get("taxMny");
                }
                if ("02".equals(map.get("code").toString())){
                    clfTaxMny = (BigDecimal) map.get("taxMny");
                }
                if ("03".equals(map.get("code").toString())){
                    jxsbfTaxMny = (BigDecimal) map.get("taxMny");
                }
                if ("04".equals(map.get("code").toString())){
                    zyfbfTaxMny = (BigDecimal) map.get("taxMny");
                }
                if ("05".equals(map.get("code").toString())){
                    qtzjfTaxMny = (BigDecimal) map.get("taxMny");
                }
                if ("06".equals(map.get("code").toString())){
                    jjfTaxMny = (BigDecimal) map.get("taxMny");
                }
                if ("07".equals(map.get("code").toString())){
                    taxMny = (BigDecimal) map.get("taxMny");
                }
            }
        }

        CostAndActualOutVO vo = new CostAndActualOutVO();
        vo.setItem(1);
        vo.setItemName("目标成本");
        vo.setTotalTaxMny(totalTaxMny);
        vo.setLwfTaxMny(lwfTaxMny);
        vo.setClfTaxMny(clfTaxMny);
        vo.setJxfTaxMny(jxsbfTaxMny);
        vo.setZyfbfTaxMny(zyfbfTaxMny);
        vo.setQtzjfTaxMny(qtzjfTaxMny);
        vo.setJjfTaxMny(jjfTaxMny);
        vo.setTaxMny(taxMny);
        if (BigDecimal.ZERO.compareTo(changeAndcostTaxMny) == 0 ){
            vo.setTotalTaxMnyScale(BigDecimal.ZERO);
            vo.setLwfTaxMnyScale(BigDecimal.ZERO);
            vo.setClfTaxMnyScale(BigDecimal.ZERO);
            vo.setJxfTaxMnyScale(BigDecimal.ZERO);
            vo.setZyfbTaxMnyScale(BigDecimal.ZERO);
            vo.setQtzjfTaxMnyScale(BigDecimal.ZERO);
            vo.setJjfTaxMnyScale(BigDecimal.ZERO);
            vo.setTaxMnyScale(BigDecimal.ZERO);
        }else{
            vo.setTotalTaxMnyScale(ComputeUtil.safeDiv(totalTaxMny,changeAndcostTaxMny));
            vo.setLwfTaxMnyScale(ComputeUtil.safeDiv(lwfTaxMny,changeAndcostTaxMny));
            vo.setClfTaxMnyScale(ComputeUtil.safeDiv(clfTaxMny,changeAndcostTaxMny));
            vo.setJxfTaxMnyScale(ComputeUtil.safeDiv(jxsbfTaxMny,changeAndcostTaxMny));
            vo.setZyfbTaxMnyScale(ComputeUtil.safeDiv(zyfbfTaxMny,changeAndcostTaxMny));
            vo.setQtzjfTaxMnyScale(ComputeUtil.safeDiv(qtzjfTaxMny,changeAndcostTaxMny));
            vo.setJjfTaxMnyScale(ComputeUtil.safeDiv(jjfTaxMny,changeAndcostTaxMny));
            vo.setTaxMnyScale(ComputeUtil.safeDiv(taxMny,changeAndcostTaxMny));
        }

        return vo;
    }

    public CostAndActualOutVO queryPayContract(Long projectId,BigDecimal changeAndcostTaxMny){

        BigDecimal totalTaxMny = BigDecimal.ZERO;
        BigDecimal lwfTaxMny = BigDecimal.ZERO;
        BigDecimal clfTaxMny = BigDecimal.ZERO;
        BigDecimal jxsbfTaxMny = BigDecimal.ZERO;
        BigDecimal zyfbfTaxMny = BigDecimal.ZERO;
        BigDecimal qtzjfTaxMny = BigDecimal.ZERO;
        BigDecimal jjfTaxMny = BigDecimal.ZERO;
        BigDecimal taxMny = BigDecimal.ZERO;

        List<ContractPoolVO> contractPoolList = mapper.queryContractPoolByProjectId(projectId);
        //排除掉已作废的合同
        contractPoolList = contractPoolList.stream().filter(e -> !ContractPerformanceStateEnum.已作废.getStateCode().equals(e.getPerformanceStatus())).collect(Collectors.toList());

        if (CollectionUtils.isNotEmpty(contractPoolList)){

            List<ContractPoolVO> payContractList = contractPoolList.stream().filter(e -> ContractPropertyEnum.支出合同.getPropertyCode() == e.getContractProperty()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(payContractList)){
                totalTaxMny = payContractList.stream().map(ContractPoolVO::getContractTaxMny).reduce(ComputeUtil::safeAdd).get();
            }

            List<ContractPoolVO> lwfContractList = contractPoolList.stream().filter(e -> ContractTypeEnum.劳务分包合同.getTypeCode().equals(e.getSourceType())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(lwfContractList)){
                lwfTaxMny = lwfContractList.stream().map(ContractPoolVO::getContractTaxMny).reduce(ComputeUtil::safeAdd).get();
            }

            List<ContractPoolVO> clfContractList = contractPoolList.stream().filter(e ->
                ContractTypeEnum.物资采购合同.getTypeCode().equals(e.getSourceType()) ||
                ContractTypeEnum.混凝土合同.getTypeCode().equals(e.getSourceType()) || ContractTypeEnum.周转材合同.getTypeCode().equals(e.getSourceType())
            ).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(clfContractList)){
                clfTaxMny = clfContractList.stream().map(ContractPoolVO::getContractTaxMny).reduce(ComputeUtil::safeAdd).get();
            }

            List<ContractPoolVO> jxfContractList = contractPoolList.stream().filter(e ->
                ContractTypeEnum.设备采购.getTypeCode().equals(e.getSourceType()) ||
                ContractTypeEnum.设备租赁.getTypeCode().equals(e.getSourceType()) ||
                ContractTypeEnum.安拆合同.getTypeCode().equals(e.getSourceType()) ||
                ContractTypeEnum.临时设备.getTypeCode().equals(e.getSourceType())
            ).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(jxfContractList)){
                jxsbfTaxMny = jxfContractList.stream().map(ContractPoolVO::getContractTaxMny).reduce(ComputeUtil::safeAdd).get();
            }

            List<ContractPoolVO> zyfbfContractList = contractPoolList.stream().filter(e -> ContractTypeEnum.专业分包合同.getTypeCode().equals(e.getSourceType())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(zyfbfContractList)){
                zyfbfTaxMny = zyfbfContractList.stream().map(ContractPoolVO::getContractTaxMny).reduce(ComputeUtil::safeAdd).get();
            }

            List<ContractPoolVO> qtzjfContractList = contractPoolList.stream().filter(e -> ContractTypeEnum.其他支出.getTypeCode().equals(e.getSourceType())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(qtzjfContractList)){
                qtzjfTaxMny = qtzjfContractList.stream().map(ContractPoolVO::getContractTaxMny).reduce(ComputeUtil::safeAdd).get();
            }

        }

        CostAndActualOutVO vo = new CostAndActualOutVO();
        vo.setItem(2);
        vo.setItemName("支出合同");
        vo.setTotalTaxMny(totalTaxMny);
        vo.setLwfTaxMny(lwfTaxMny);
        vo.setClfTaxMny(clfTaxMny);
        vo.setJxfTaxMny(jxsbfTaxMny);
        vo.setZyfbfTaxMny(zyfbfTaxMny);
        vo.setQtzjfTaxMny(qtzjfTaxMny);
        vo.setJjfTaxMny(jjfTaxMny);
        vo.setTaxMny(taxMny);
        if (BigDecimal.ZERO.compareTo(changeAndcostTaxMny) == 0 ){
            vo.setTotalTaxMnyScale(BigDecimal.ZERO);
            vo.setLwfTaxMnyScale(BigDecimal.ZERO);
            vo.setClfTaxMnyScale(BigDecimal.ZERO);
            vo.setJxfTaxMnyScale(BigDecimal.ZERO);
            vo.setZyfbTaxMnyScale(BigDecimal.ZERO);
            vo.setQtzjfTaxMnyScale(BigDecimal.ZERO);
            vo.setJjfTaxMnyScale(BigDecimal.ZERO);
            vo.setTaxMnyScale(BigDecimal.ZERO);
        }else{
            vo.setTotalTaxMnyScale(ComputeUtil.safeDiv(totalTaxMny,changeAndcostTaxMny));
            vo.setLwfTaxMnyScale(ComputeUtil.safeDiv(lwfTaxMny,changeAndcostTaxMny));
            vo.setClfTaxMnyScale(ComputeUtil.safeDiv(clfTaxMny,changeAndcostTaxMny));
            vo.setJxfTaxMnyScale(ComputeUtil.safeDiv(jxsbfTaxMny,changeAndcostTaxMny));
            vo.setZyfbTaxMnyScale(ComputeUtil.safeDiv(zyfbfTaxMny,changeAndcostTaxMny));
            vo.setQtzjfTaxMnyScale(ComputeUtil.safeDiv(qtzjfTaxMny,changeAndcostTaxMny));
            vo.setJjfTaxMnyScale(ComputeUtil.safeDiv(jjfTaxMny,changeAndcostTaxMny));
            vo.setTaxMnyScale(ComputeUtil.safeDiv(taxMny,changeAndcostTaxMny));
        }

        return vo;
    }

    public CostAndActualOutVO querySettle(Long projectId,BigDecimal changeAndcostTaxMny){

        BigDecimal totalTaxMny = BigDecimal.ZERO;
        BigDecimal lwfTaxMny = BigDecimal.ZERO;
        BigDecimal clfTaxMny = BigDecimal.ZERO;
        BigDecimal jxsbfTaxMny = BigDecimal.ZERO;
        BigDecimal zyfbfTaxMny = BigDecimal.ZERO;
        BigDecimal qtzjfTaxMny = BigDecimal.ZERO;
        BigDecimal jjfTaxMny = BigDecimal.ZERO;
        BigDecimal taxMny = BigDecimal.ZERO;

        CommonResponse<ParamRegisterSetVO> paramResponse = paramConfigApi.getByCode(PROJECT_SETTLE_RANGE_PARAM);
        if (!paramResponse.isSuccess() || paramResponse.getData() == null) {
            throw new BusinessException("获取项目结算查询结算单范围系统参数请求失败，失败原因：" + paramResponse.getMsg());
        }
        String valueData = paramResponse.getData().getValueData();
        Assert.hasText(valueData, "获取的项目结算查询结算单范围不能为空!");
        List<SettlePoolVO> settlePoolList = mapper.querySettlePoolByProjectId(projectId, Arrays.asList(valueData.split(",")));

        if (CollectionUtils.isNotEmpty(settlePoolList)){
            BigDecimal settleTaxMny = null;
            for(SettlePoolVO settle : settlePoolList) {
                settleTaxMny = settle.getCurTaxMny();
                if(SettleSourceTypeEnum.劳务分包最终结算.getCode().equals(settle.getSourceType()) || SettleSourceTypeEnum.专业分包最终结算.getCode().equals(settle.getSourceType())) {
                    settleTaxMny = settle.getTotalNodeTaxDifference();
                }
                if(ContractPropertyEnum.支出合同.getPropertyCode().equals(settle.getSettleProperty())) {
                    totalTaxMny = ComputeUtil.safeAdd(totalTaxMny, settleTaxMny);
                }
                switch (settle.getSourceType()) {
                    case "labor_node":
                    case "labor_final":
                        lwfTaxMny = ComputeUtil.safeAdd(lwfTaxMny, settleTaxMny);
                        continue;
                    case "material_buy_in":
                    case "beton_buy_in":
                    case "material_week_rent_in":
                    case "sporadic_material":
                        clfTaxMny = ComputeUtil.safeAdd(clfTaxMny, settleTaxMny);
                        continue;
                    case "equip_buy_in":
                    case "equip_rent_in":
                    case "temp_equip":
                    case "ac_other_out_contract_month":
                    case "ac_other_out_contract_final":
                        jxsbfTaxMny = ComputeUtil.safeAdd(jxsbfTaxMny, settleTaxMny);
                        continue;
                    case "pro_node":
                    case "pro_final":
                        zyfbfTaxMny = ComputeUtil.safeAdd(zyfbfTaxMny, settleTaxMny);
                        continue;
                    case "other_out":
                    case "other_out_contract_month":
                    case "other_out_contract_final":
                        qtzjfTaxMny = ComputeUtil.safeAdd(qtzjfTaxMny, settleTaxMny);
                }

            }

//            List<SettlePoolVO> paySettleList = settlePoolList.stream().filter(e -> ContractPropertyEnum.支出合同.getPropertyCode() == e.getSettleProperty()).collect(Collectors.toList());
//            if (CollectionUtils.isNotEmpty(paySettleList)){
//                totalTaxMny = paySettleList.stream().map(SettlePoolVO::getCurTaxMny).reduce(ComputeUtil::safeAdd).get();
//            }
//
//            List<SettlePoolVO> lwfSettleList = settlePoolList.stream().filter(e ->
//                SettleSourceTypeEnum.劳务分包节点结算.getCode().equals(e.getSourceType()) ||
//                SettleSourceTypeEnum.劳务分包最终结算.getCode().equals(e.getSourceType())
//            ).collect(Collectors.toList());
//            if (CollectionUtils.isNotEmpty(lwfSettleList)){
//                lwfTaxMny = lwfSettleList.stream().map(SettlePoolVO::getCurTaxMny).reduce(ComputeUtil::safeAdd).get();
//            }
//
//            List<SettlePoolVO> clfSettleList = settlePoolList.stream().filter(e ->
//                    SettleSourceTypeEnum.物资采购结算.getCode().equals(e.getSourceType()) ||
//                    SettleSourceTypeEnum.混凝土采购结算.getCode().equals(e.getSourceType())  ||
//                    SettleSourceTypeEnum.周转材租入结算.getCode().equals(e.getSourceType()) ||
//                    SettleSourceTypeEnum.零星材料结算.getCode().equals(e.getSourceType())
//            ).collect(Collectors.toList());
//            if (CollectionUtils.isNotEmpty(clfSettleList)){
//                clfTaxMny = clfSettleList.stream().map(SettlePoolVO::getCurTaxMny).reduce(ComputeUtil::safeAdd).get();
//            }
//
//            List<SettlePoolVO> jxfSettleList = settlePoolList.stream().filter(e ->
//                    SettleSourceTypeEnum.设备采购结算.getCode().equals(e.getSourceType()) ||
//                    SettleSourceTypeEnum.设备租入结算.getCode().equals(e.getSourceType()) ||
//                    SettleSourceTypeEnum.设备租出结算.getCode().equals(e.getSourceType()) ||
//                    SettleSourceTypeEnum.临时设备结算.getCode().equals(e.getSourceType()) ||
//                    SettleSourceTypeEnum.大型设备安拆结算.getCode().equals(e.getSourceType())
//            ).collect(Collectors.toList());
//            if (CollectionUtils.isNotEmpty(jxfSettleList)){
//                jxsbfTaxMny = jxfSettleList.stream().map(SettlePoolVO::getCurTaxMny).reduce(ComputeUtil::safeAdd).get();
//            }
//
//            List<SettlePoolVO> zyfbfSettleList = settlePoolList.stream().filter(e ->
//                    SettleSourceTypeEnum.专业分包节点结算.getCode().equals(e.getSourceType()) ||
//                    SettleSourceTypeEnum.专业分包最终结算.getCode().equals(e.getSourceType())
//            ).collect(Collectors.toList());
//            if (CollectionUtils.isNotEmpty(zyfbfSettleList)){
//                zyfbfTaxMny = zyfbfSettleList.stream().map(SettlePoolVO::getCurTaxMny).reduce(ComputeUtil::safeAdd).get();
//            }
//
//            List<SettlePoolVO> qtzjfSettleList = settlePoolList.stream().filter(e ->
//                    SettleSourceTypeEnum.其他支出结算.getCode().equals(e.getSourceType()) ||
//                    SettleSourceTypeEnum.其他支出合同过程结算.getCode().equals(e.getSourceType()) ||
//                    SettleSourceTypeEnum.其他支出合同最终结算.getCode().equals(e.getSourceType())
//            ).collect(Collectors.toList());
//            if (CollectionUtils.isNotEmpty(qtzjfSettleList)){
//                qtzjfTaxMny = qtzjfSettleList.stream().map(SettlePoolVO::getCurTaxMny).reduce(ComputeUtil::safeAdd).get();
//            }

        }

        CostAndActualOutVO vo = new CostAndActualOutVO();
        vo.setItem(3);
        vo.setItemName("结算金额");
        vo.setTotalTaxMny(totalTaxMny);
        vo.setLwfTaxMny(lwfTaxMny);
        vo.setClfTaxMny(clfTaxMny);
        vo.setJxfTaxMny(jxsbfTaxMny);
        vo.setZyfbfTaxMny(zyfbfTaxMny);
        vo.setQtzjfTaxMny(qtzjfTaxMny);
        vo.setJjfTaxMny(jjfTaxMny);
        vo.setTaxMny(taxMny);
        if (BigDecimal.ZERO.compareTo(changeAndcostTaxMny) == 0 ){
            vo.setTotalTaxMnyScale(BigDecimal.ZERO);
            vo.setLwfTaxMnyScale(BigDecimal.ZERO);
            vo.setClfTaxMnyScale(BigDecimal.ZERO);
            vo.setJxfTaxMnyScale(BigDecimal.ZERO);
            vo.setZyfbTaxMnyScale(BigDecimal.ZERO);
            vo.setQtzjfTaxMnyScale(BigDecimal.ZERO);
            vo.setJjfTaxMnyScale(BigDecimal.ZERO);
            vo.setTaxMnyScale(BigDecimal.ZERO);
        }else{
            vo.setTotalTaxMnyScale(ComputeUtil.safeDiv(totalTaxMny,changeAndcostTaxMny));
            vo.setLwfTaxMnyScale(ComputeUtil.safeDiv(lwfTaxMny,changeAndcostTaxMny));
            vo.setClfTaxMnyScale(ComputeUtil.safeDiv(clfTaxMny,changeAndcostTaxMny));
            vo.setJxfTaxMnyScale(ComputeUtil.safeDiv(jxsbfTaxMny,changeAndcostTaxMny));
            vo.setZyfbTaxMnyScale(ComputeUtil.safeDiv(zyfbfTaxMny,changeAndcostTaxMny));
            vo.setQtzjfTaxMnyScale(ComputeUtil.safeDiv(qtzjfTaxMny,changeAndcostTaxMny));
            vo.setJjfTaxMnyScale(ComputeUtil.safeDiv(jjfTaxMny,changeAndcostTaxMny));
            vo.setTaxMnyScale(ComputeUtil.safeDiv(taxMny,changeAndcostTaxMny));
        }

        return vo;
    }

    public CostAndActualOutVO queryPaymentApply(Long projectId,BigDecimal changeAndcostTaxMny){

        BigDecimal totalTaxMny = BigDecimal.ZERO;
        BigDecimal lwfTaxMny = BigDecimal.ZERO;
        BigDecimal clfTaxMny = BigDecimal.ZERO;
        BigDecimal jxsbfTaxMny = BigDecimal.ZERO;
        BigDecimal zyfbfTaxMny = BigDecimal.ZERO;
        BigDecimal qtzjfTaxMny = BigDecimal.ZERO;
        BigDecimal jjfTaxMny = BigDecimal.ZERO;
        BigDecimal taxMny = BigDecimal.ZERO;


        LambdaQueryWrapper<PaymentApplyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(PaymentApplyEntity::getProjectId,projectId);
        queryWrapper.in(PaymentApplyEntity::getBillState,1,3);
        queryWrapper.in(PaymentApplyEntity::getDr,0);
        List<PaymentApplyEntity> list = paymentApplyService.list(queryWrapper);

        if (CollectionUtils.isNotEmpty(list)){

            totalTaxMny = list.stream().map(PaymentApplyEntity::getApprovalMny).reduce(ComputeUtil::safeAdd).get();

            List<PaymentApplyEntity> lwfPaymentApplyList = list.stream().filter(e ->
                0 == e.getPaymentContractFlag() &&
                ContractTypeEnum.劳务分包合同.getTypeCode().equals(e.getSourceCategoryType())
            ).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(lwfPaymentApplyList)){
                List<PaymentApplyEntity> collect = lwfPaymentApplyList.stream().filter(e -> null != e.getApprovalMny()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collect)){
                    lwfTaxMny = lwfPaymentApplyList.stream().map(PaymentApplyEntity::getApprovalMny).reduce(ComputeUtil::safeAdd).get();
                }
            }

            List<PaymentApplyEntity> clfPaymentApplyList = list.stream().filter(e ->
                ContractTypeEnum.物资采购合同.getTypeCode().equals(e.getSourceCategoryType()) ||
                ContractTypeEnum.混凝土合同.getTypeCode().equals(e.getSourceCategoryType()) ||
                ContractTypeEnum.周转材合同.getTypeCode().equals(e.getSourceCategoryType()) ||
                3 == e.getPaymentType()
            ).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(clfPaymentApplyList)){
                List<PaymentApplyEntity> collect = clfPaymentApplyList.stream().filter(e -> null != e.getApprovalMny()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collect)){
                    clfTaxMny = clfPaymentApplyList.stream().map(PaymentApplyEntity::getApprovalMny).reduce(ComputeUtil::safeAdd).get();
                }
            }

            List<PaymentApplyEntity> jxfPaymentApplyList = list.stream().filter(e ->
                ContractTypeEnum.设备采购.getTypeCode().equals(e.getSourceCategoryType()) ||
                ContractTypeEnum.设备租赁.getTypeCode().equals(e.getSourceCategoryType()) ||
                ContractTypeEnum.安拆合同.getTypeCode().equals(e.getSourceCategoryType()) ||
                ContractTypeEnum.临时设备.getTypeCode().equals(e.getSourceCategoryType()) ||
                4 == e.getPaymentType()
            ).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(jxfPaymentApplyList)){
                List<PaymentApplyEntity> collect = jxfPaymentApplyList.stream().filter(e -> null != e.getApprovalMny()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collect)){
                    jxsbfTaxMny = jxfPaymentApplyList.stream().map(PaymentApplyEntity::getApprovalMny).reduce(ComputeUtil::safeAdd).get();
                }
            }

            List<PaymentApplyEntity> zyfbfPaymentApplyList = list.stream().filter(e ->
                0 == e.getPaymentContractFlag() &&
                ContractTypeEnum.专业分包合同.getTypeCode().equals(e.getSourceCategoryType())
            ).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(zyfbfPaymentApplyList)){
                List<PaymentApplyEntity> collect = zyfbfPaymentApplyList.stream().filter(e -> null != e.getApprovalMny()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collect)){
                    zyfbfTaxMny = zyfbfPaymentApplyList.stream().map(PaymentApplyEntity::getApprovalMny).reduce(ComputeUtil::safeAdd).get();
                }
            }

            List<PaymentApplyEntity> qtzjfPaymentApplyList = list.stream().filter(e ->
                0 == e.getPaymentContractFlag() &&
                ContractTypeEnum.其他支出.getTypeCode().equals(e.getSourceCategoryType())
            ).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(qtzjfPaymentApplyList)){
                List<PaymentApplyEntity> collect = qtzjfPaymentApplyList.stream().filter(e -> null != e.getApprovalMny()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collect)){
                    qtzjfTaxMny = qtzjfPaymentApplyList.stream().map(PaymentApplyEntity::getApprovalMny).reduce(ComputeUtil::safeAdd).get();
                }
            }

        }

        //查询项目下总的工资申请金额
        QueryWrapper<SalaryPayApplyEntity> salaryCount = new QueryWrapper();
        salaryCount.select("sum(apply_tax_mny) as totalSalaryApplyTaxMny");
        salaryCount.eq("project_id", projectId);
        salaryCount.in("bill_state",1,3);
        salaryCount.eq("dr",0);
        salaryCount.eq("is_repeat_bill",0);
        Map<String, Object> salaryMnyMap = salaryPayApplyService.getMap(salaryCount);
        BigDecimal totalSalaryApplyTaxMny = BigDecimal.ZERO;
        if(null != salaryMnyMap && null != salaryMnyMap.get("totalSalaryApplyTaxMny")) {
            totalSalaryApplyTaxMny = new BigDecimal(salaryMnyMap.get("totalSalaryApplyTaxMny").toString());
        }

        //工资申请总金额累加进总金额中
        totalTaxMny = totalTaxMny.add(totalSalaryApplyTaxMny);
        //劳务费总金额加入 工资支付申请总金额
        lwfTaxMny = lwfTaxMny.add(totalSalaryApplyTaxMny);

        CostAndActualOutVO vo = new CostAndActualOutVO();
        vo.setItem(4);
        vo.setItemName("批复金额");
        vo.setTotalTaxMny(totalTaxMny);
        vo.setLwfTaxMny(lwfTaxMny);
        vo.setClfTaxMny(clfTaxMny);
        vo.setJxfTaxMny(jxsbfTaxMny);
        vo.setZyfbfTaxMny(zyfbfTaxMny);
        vo.setQtzjfTaxMny(qtzjfTaxMny);
        vo.setJjfTaxMny(jjfTaxMny);
        vo.setTaxMny(taxMny);
        if (BigDecimal.ZERO.compareTo(changeAndcostTaxMny) == 0 ){
            vo.setTotalTaxMnyScale(BigDecimal.ZERO);
            vo.setLwfTaxMnyScale(BigDecimal.ZERO);
            vo.setClfTaxMnyScale(BigDecimal.ZERO);
            vo.setJxfTaxMnyScale(BigDecimal.ZERO);
            vo.setZyfbTaxMnyScale(BigDecimal.ZERO);
            vo.setQtzjfTaxMnyScale(BigDecimal.ZERO);
            vo.setJjfTaxMnyScale(BigDecimal.ZERO);
            vo.setTaxMnyScale(BigDecimal.ZERO);
        }else{
            vo.setTotalTaxMnyScale(ComputeUtil.safeDiv(totalTaxMny,changeAndcostTaxMny));
            vo.setLwfTaxMnyScale(ComputeUtil.safeDiv(lwfTaxMny,changeAndcostTaxMny));
            vo.setClfTaxMnyScale(ComputeUtil.safeDiv(clfTaxMny,changeAndcostTaxMny));
            vo.setJxfTaxMnyScale(ComputeUtil.safeDiv(jxsbfTaxMny,changeAndcostTaxMny));
            vo.setZyfbTaxMnyScale(ComputeUtil.safeDiv(zyfbfTaxMny,changeAndcostTaxMny));
            vo.setQtzjfTaxMnyScale(ComputeUtil.safeDiv(qtzjfTaxMny,changeAndcostTaxMny));
            vo.setJjfTaxMnyScale(ComputeUtil.safeDiv(jjfTaxMny,changeAndcostTaxMny));
            vo.setTaxMnyScale(ComputeUtil.safeDiv(taxMny,changeAndcostTaxMny));
        }

        return vo;
    }

    public CostAndActualOutVO queryPaymentRegister(Long projectId,BigDecimal changeAndcostTaxMny){

        BigDecimal totalTaxMny = BigDecimal.ZERO;
        BigDecimal lwfTaxMny = BigDecimal.ZERO;
        BigDecimal clfTaxMny = BigDecimal.ZERO;
        BigDecimal jxsbfTaxMny = BigDecimal.ZERO;
        BigDecimal zyfbfTaxMny = BigDecimal.ZERO;
        BigDecimal qtzjfTaxMny = BigDecimal.ZERO;
        BigDecimal jjfTaxMny = BigDecimal.ZERO;
        BigDecimal taxMny = BigDecimal.ZERO;


        LambdaQueryWrapper<PaymentRegisterEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(PaymentRegisterEntity::getProjectId,projectId);
        queryWrapper.in(PaymentRegisterEntity::getBillState,1,3);
        queryWrapper.eq(PaymentRegisterEntity::getDr,0);
        List<PaymentRegisterEntity> list = paymentRegisterService.list(queryWrapper);

        List<BigDecimal> costMny = mapper.queryCostByProjectId(projectId);
        if (CollectionUtils.isNotEmpty(costMny)){
            totalTaxMny = costMny.stream().reduce(ComputeUtil::safeAdd).get();
        }

        if (CollectionUtils.isNotEmpty(list)){

            BigDecimal payMny = list.stream().map(PaymentRegisterEntity::getPayMny).reduce(ComputeUtil::safeAdd).get();
            totalTaxMny = ComputeUtil.safeAdd(totalTaxMny,payMny);

            List<PaymentRegisterEntity> lwfPayList = list.stream().filter(e -> ContractTypeEnum.劳务分包合同.getTypeCode().equals(e.getSourceCategoryType())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(lwfPayList)){
                lwfTaxMny = lwfPayList.stream().map(PaymentRegisterEntity::getPayMny).reduce(ComputeUtil::safeAdd).get();
            }

            List<PaymentRegisterEntity> clfPayList = list.stream().filter(e ->
                ContractTypeEnum.物资采购合同.getTypeCode().equals(e.getSourceCategoryType()) ||
                ContractTypeEnum.混凝土合同.getTypeCode().equals(e.getSourceCategoryType()) ||
                ContractTypeEnum.周转材合同.getTypeCode().equals(e.getSourceCategoryType()) || "零星材料".equals(e.getFeeTypeName()) || "零星材料费用".equals(e.getFeeTypeName())
            ).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(clfPayList)){
                clfTaxMny = clfPayList.stream().map(PaymentRegisterEntity::getPayMny).reduce(ComputeUtil::safeAdd).get();
            }

            List<PaymentRegisterEntity> jxfPayList = list.stream().filter(e ->
                ContractTypeEnum.设备采购.getTypeCode().equals(e.getSourceCategoryType()) ||
                ContractTypeEnum.设备租赁.getTypeCode().equals(e.getSourceCategoryType()) ||
                ContractTypeEnum.安拆合同.getTypeCode().equals(e.getSourceCategoryType()) ||
                ContractTypeEnum.临时设备.getTypeCode().equals(e.getSourceCategoryType()) || "临时机械".equals(e.getFeeTypeName()) || "临时设备费用".equals(e.getFeeTypeName())
            ).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(jxfPayList)){
                jxsbfTaxMny = jxfPayList.stream().map(PaymentRegisterEntity::getPayMny).reduce(ComputeUtil::safeAdd).get();
            }

            List<PaymentRegisterEntity> zyfbfPayList = list.stream().filter(e -> ContractTypeEnum.专业分包合同.getTypeCode().equals(e.getSourceCategoryType())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(zyfbfPayList)){
                zyfbfTaxMny = zyfbfPayList.stream().map(PaymentRegisterEntity::getPayMny).reduce(ComputeUtil::safeAdd).get();
            }

            List<PaymentRegisterEntity> qtzjfPayList = list.stream().filter(e -> ContractTypeEnum.其他支出.getTypeCode().equals(e.getSourceCategoryType())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(qtzjfPayList)){
                qtzjfTaxMny = qtzjfPayList.stream().map(PaymentRegisterEntity::getPayMny).reduce(ComputeUtil::safeAdd).get();
            }

        }

        QueryParam jjfParam = new QueryParam();
        jjfParam.getParams().put("subject_code",new Parameter(QueryParam.EQ,"06"));
        CommonResponse<List<SubjectOrgVO>> jjfResp = subjectOrgApi.querySubjectOrg(jjfParam);
        if (!jjfResp.isSuccess()){
            throw new BusinessException("获取间接费失败!");
        }else{
            if (CollectionUtils.isNotEmpty(jjfResp.getData())){
                SubjectOrgVO subjectOrgVO = jjfResp.getData().get(0);
                QueryParam Param = new QueryParam();
                Param.getParams().put("inner_code",new Parameter(QueryParam.LIKE,subjectOrgVO.getId()));
                CommonResponse<List<SubjectOrgVO>> res = subjectOrgApi.querySubjectOrg(Param);
                List<Long> ids = res.getData().stream().map(SubjectOrgVO::getId).collect(Collectors.toList());
                List<HandshareDetailVO> handshareDetailVOS = mapper.queryCostDetailByProjectId(projectId, ids);
                if (CollectionUtils.isNotEmpty(handshareDetailVOS)){
                    jjfTaxMny = handshareDetailVOS.stream().map(HandshareDetailVO::getHappenMny).reduce(ComputeUtil::safeAdd).get();
                }
            }
        }

        QueryParam taxParam = new QueryParam();
        taxParam.getParams().put("subject_code",new Parameter(QueryParam.EQ,"07"));
        CommonResponse<List<SubjectOrgVO>> taxResp = subjectOrgApi.querySubjectOrg(taxParam);
        if (!taxResp.isSuccess()){
            throw new BusinessException("获取间接费失败!");
        }else{
            if (CollectionUtils.isNotEmpty(taxResp.getData())){
                SubjectOrgVO subjectOrgVO = taxResp.getData().get(0);
                QueryParam Param = new QueryParam();
                Param.getParams().put("inner_code",new Parameter(QueryParam.LIKE,subjectOrgVO.getId()));
                CommonResponse<List<SubjectOrgVO>> res = subjectOrgApi.querySubjectOrg(Param);
                List<Long> ids = res.getData().stream().map(SubjectOrgVO::getId).collect(Collectors.toList());
                List<HandshareDetailVO> handshareDetailVOS = mapper.queryCostDetailByProjectId(projectId, ids);
                if (CollectionUtils.isNotEmpty(handshareDetailVOS)){
                    taxMny = handshareDetailVOS.stream().map(HandshareDetailVO::getHappenMny).reduce(ComputeUtil::safeAdd).get();
                }
            }
        }

        CostAndActualOutVO vo = new CostAndActualOutVO();
        vo.setItem(5);
        vo.setItemName("实际付款");
        vo.setTotalTaxMny(totalTaxMny);
        vo.setLwfTaxMny(lwfTaxMny);
        vo.setClfTaxMny(clfTaxMny);
        vo.setJxfTaxMny(jxsbfTaxMny);
        vo.setZyfbfTaxMny(zyfbfTaxMny);
        vo.setQtzjfTaxMny(qtzjfTaxMny);
        vo.setJjfTaxMny(jjfTaxMny);
        vo.setTaxMny(taxMny);
        if (BigDecimal.ZERO.compareTo(changeAndcostTaxMny) == 0 ){
            vo.setTotalTaxMnyScale(BigDecimal.ZERO);
            vo.setLwfTaxMnyScale(BigDecimal.ZERO);
            vo.setClfTaxMnyScale(BigDecimal.ZERO);
            vo.setJxfTaxMnyScale(BigDecimal.ZERO);
            vo.setZyfbTaxMnyScale(BigDecimal.ZERO);
            vo.setQtzjfTaxMnyScale(BigDecimal.ZERO);
            vo.setJjfTaxMnyScale(BigDecimal.ZERO);
            vo.setTaxMnyScale(BigDecimal.ZERO);
        }else{
            vo.setTotalTaxMnyScale(ComputeUtil.safeDiv(totalTaxMny,changeAndcostTaxMny));
            vo.setLwfTaxMnyScale(ComputeUtil.safeDiv(lwfTaxMny,changeAndcostTaxMny));
            vo.setClfTaxMnyScale(ComputeUtil.safeDiv(clfTaxMny,changeAndcostTaxMny));
            vo.setJxfTaxMnyScale(ComputeUtil.safeDiv(jxsbfTaxMny,changeAndcostTaxMny));
            vo.setZyfbTaxMnyScale(ComputeUtil.safeDiv(zyfbfTaxMny,changeAndcostTaxMny));
            vo.setQtzjfTaxMnyScale(ComputeUtil.safeDiv(qtzjfTaxMny,changeAndcostTaxMny));
            vo.setJjfTaxMnyScale(ComputeUtil.safeDiv(jjfTaxMny,changeAndcostTaxMny));
            vo.setTaxMnyScale(ComputeUtil.safeDiv(taxMny,changeAndcostTaxMny));
        }

        return vo;
    }



}
