/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.profinance.utils.DBUtil2;
import com.ejianc.business.profinance.utils.DynamicDataSourceDruidUtil;
import com.ejianc.business.profinance.utils.ResultAsTreeNew;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/nccData/"})
public class NccDataController {
    private static final String IP = "10.70.2.127";
    private static final String PORT = "1521";
    private static final String DBNAME = "orcl";
    private static final String USERNAME = "sjxmgl";
    private static final String DRIVER = "oracle.jdbc.OracleDriver";
    private static final String DATABASETYPE = "Oracle";
    private static final String PASSWORD = "Sj#2j#xmGl";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping(value={"getNCCPayBankTypeList"})
    public List<JSONObject> getNCCPayBankTypeList() {
        return null;
    }

    @GetMapping(value={"getNCCPayBankList"})
    public CommonResponse<IPage<JSONObject>> getNCCPayBankList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        return null;
    }

    @GetMapping(value={"getNCCRecBankList"})
    public CommonResponse<IPage<JSONObject>> getNCCRecBankList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        return null;
    }

    @GetMapping(value={"getNCCUserList"})
    public CommonResponse<JSONObject> getNCCUserList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject resp = new JSONObject();
        resp.put("current", (Object)pageNumber);
        resp.put("size", (Object)pageSize);
        resp.put("pages", (Object)1);
        resp.put("total", (Object)0);
        StringBuilder sql = new StringBuilder("SELECT * FROM ( SELECT t.*,ROW_NUMBER() OVER ( ORDER BY USER_CODE ) rn FROM NCC2105.V_ERJIAN_USER t WHERE 1 = 1 ");
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            sql.append(" AND (USER_NAME LIKE '%").append(searchText).append("%'").append("OR USER_CODE like '%").append(searchText).append("%'").append("OR ORGCODE like '%").append(searchText).append("%'").append("OR ORGNAME LIKE '%").append(searchText).append("%' ) ");
        }
        sql.append(")WHERE rn BETWEEN (" + pageNumber + "-1)*" + pageSize + "+1 and " + pageNumber + "*" + pageSize).append(" ORDER BY rn");
        List<Map<String, Object>> list = this.queryBySql(sql.toString());
        if (CollectionUtils.isEmpty(list)) {
            return CommonResponse.success((String)"", (Object)resp);
        }
        ArrayList<JSONObject> record = new ArrayList<JSONObject>();
        for (Map<String, Object> m : list) {
            JSONObject j = new JSONObject();
            j.put("id", m.get("USER_CODE"));
            j.put("name", m.get("USER_NAME"));
            j.put("code", m.get("USER_CODE"));
            j.put("orgId", m.get("ORGCODE"));
            j.put("orgCode", m.get("ORGCODE"));
            j.put("orgName", m.get("ORGNAME"));
            record.add(j);
        }
        resp.put("records", record);
        StringBuilder countSql = new StringBuilder("select COUNT(CUSERID) from NCC2105. V_ERJIAN_USER WHERE 1=1  AND (ORGCODE like '101021%' OR ORGCODE = '10102Z')");
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            countSql.append(" AND (USER_NAME LIKE '%").append(searchText).append("%'").append("OR USER_CODE like '%").append(searchText).append("%'").append("OR ORGCODE like '%").append(searchText).append("%'").append("OR ORGNAME LIKE '%").append(searchText).append("%' ) ");
        }
        List<Map<String, Object>> countList = this.queryBySql(countSql.toString());
        BigDecimal count = (BigDecimal)countList.get(0).get("COUNT(CUSERID)");
        resp.put("pages", (Object)count.divide(new BigDecimal(pageSize), 1).setScale(0, 0));
        resp.put("total", (Object)count);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f", (Object)resp);
    }

    @GetMapping(value={"getNCCProjectTypeTree"})
    public List<Map<String, Object>> getNCCProjectTypeTree() {
        StringBuilder sql = new StringBuilder("SELECT DISTINCT PK_EPS AS \"id\", PK_EPS AS \"key\", EPS_CODE AS \"code\", EPS_NAME AS \"name\" ");
        sql.append(" FROM NCC2105.V_ERJIAN_PROJECT ORDER BY LENGTH(\"code\"), \"code\" ASC");
        return this.queryBySql(sql.toString());
    }

    @GetMapping(value={"getNCCFinancialOrgProjectList"})
    public CommonResponse<JSONObject> getNCCFinancialOrgProjectList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText) {
        int startLine = pageNumber - 1 < 0 ? 0 : pageNumber - 1;
        JSONObject resp = new JSONObject();
        StringBuilder sql = new StringBuilder("SELECT * FROM ( SELECT t.*, ROW_NUMBER() OVER ( ORDER BY LENGTH( \"code\" ), \"code\" ) AS rn");
        sql.append(" FROM (").append("    SELECT ").append("        PK_PROJECT AS \"nccPK\",").append("        PROJECT_CODE AS \"code\",").append("        PROJECT_NAME AS \"name\",").append("        regexp_substr ( PROJECT_CODE, '[0-9]+' ) AS \"id\" ").append("    FROM NCC2105.V_ERJIAN_PROJECT ").append("    WHERE 1 = 1");
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            sql.append(" AND PK_EPS =").append(" '").append(relyCondition.split("=")[1]).append("'");
        }
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            sql.append(" AND (PROJECT_CODE LIKE '%").append(searchText).append("%'").append(" OR PROJECT_NAME LIKE '%").append(searchText).append("%' ) ");
        }
        sql.append(" GROUP BY PK_PROJECT, PROJECT_CODE, PROJECT_NAME ) t ) ").append("  WHERE rn BETWEEN ").append(startLine * pageSize + 1).append(" AND ").append((startLine + 1) * pageSize).append(" ORDER BY rn ");
        this.logger.info("sql: {}", (Object)sql.toString());
        List<Map<String, Object>> dataList = this.queryBySql(sql.toString());
        if (!CollectionUtils.isEmpty(dataList)) {
            dataList.forEach(item -> item.put("id", Long.valueOf(item.get("id").toString())));
        }
        resp.put("records", dataList);
        if (CollectionUtils.isEmpty(dataList)) {
            resp.put("pages", (Object)0);
            resp.put("total", (Object)0);
            resp.put("current", (Object)pageNumber);
            resp.put("pageSize", (Object)pageSize);
            return CommonResponse.success((Object)resp);
        }
        StringBuilder countSql = new StringBuilder("SELECT COUNT(1) AS \"total\" FROM ( SELECT t.*, ROW_NUMBER() OVER ( ORDER BY LENGTH( \"code\" ), \"code\" ) AS rn");
        countSql.append(" FROM (").append("    SELECT ").append("        PK_PROJECT AS \"nccPK\",").append("        PROJECT_CODE AS \"code\",").append("        PROJECT_NAME AS \"name\",").append("        regexp_substr ( PROJECT_CODE, '[0-9]+' ) AS \"id\" ").append("    FROM NCC2105.V_ERJIAN_PROJECT ").append("    WHERE 1 = 1");
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            countSql.append(" AND PK_EPS =").append(" '").append(relyCondition.split("=")[1]).append("'");
        }
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            countSql.append(" AND (PROJECT_CODE LIKE '%").append(searchText).append("%'").append(" OR PROJECT_NAME LIKE '%").append(searchText).append("%' ) ");
        }
        countSql.append(" GROUP BY PK_PROJECT, PROJECT_CODE, PROJECT_NAME ) t ) ");
        List<Map<String, Object>> countList = this.queryBySql(countSql.toString());
        BigDecimal count = (BigDecimal)countList.get(0).get("total");
        resp.put("pages", (Object)count.divide(new BigDecimal(pageSize), 1).setScale(0, 0));
        resp.put("total", (Object)count);
        resp.put("current", (Object)pageNumber);
        resp.put("pageSize", (Object)pageSize);
        return CommonResponse.success((Object)resp);
    }

    @GetMapping(value={"getNCCFinancialOrgTree"})
    public List<Map<String, Object>> getNCCFinancialOrgTree(@RequestParam(required=false) String condition, @RequestParam(required=false) String searchText) {
        StringBuilder sql = new StringBuilder("SELECT SUBSTR(code, 0, LENGTH(CODE)-1) AS \"id\", PK_ORG AS \"nccPK\", CODE AS \"code\", CODE || ' ' || NAME AS \"name\",PK_FATHERORG AS \"nccPid\"");
        sql.append(" FROM NCC2105.V_ERJIAN_ORG").append(" WHERE (CODE like '101021%' OR CODE = '10102Z')").append(" START WITH CODE = '10102Z'").append(" CONNECT BY PRIOR PK_ORG = PK_FATHERORG").append(" ORDER BY LENGTH(CODE),CODE");
        List<Map<String, Object>> orgList = this.queryBySql(sql.toString());
        return ResultAsTreeNew.createTreeData(orgList, "nccPid", "nccPK");
    }

    public List<Map<String, Object>> queryBySql(String sql) {
        ArrayList<Map<String, Object>> list = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ip", IP);
        map.put("port", PORT);
        map.put("dbName", DBNAME);
        map.put("userName", USERNAME);
        map.put("driver", DRIVER);
        map.put("databaseType", DATABASETYPE);
        map.put("password", PASSWORD);
        DataSource dataSource = DynamicDataSourceDruidUtil.getDataSource(map);
        DBUtil2 db = new DBUtil2(dataSource);
        try {
            list = db.queryForListCommonMethod(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

