/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.profinance.plan.bean.PlanContractEntity;
import com.ejianc.business.profinance.plan.mapper.PlanContractMapper;
import com.ejianc.business.profinance.plan.service.IPlanContractService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="planContractService")
public class PlanContractServiceImpl
extends BaseServiceImpl<PlanContractMapper, PlanContractEntity>
implements IPlanContractService {
    private final ISettlePoolApi settlePoolApi;
    private static final String CONTRACT_ID = "contract_id";

    public PlanContractServiceImpl(ISettlePoolApi settlePoolApi) {
        this.settlePoolApi = settlePoolApi;
    }

    @Override
    public void updateBillState(Long planId, Integer billStateCode) {
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(PlanContractEntity::getPlanId, (Object)planId);
        updateWrapper.set(PlanContractEntity::getBillState, (Object)billStateCode);
        updateWrapper.set(PlanContractEntity::getBillStateName, (Object)BillStateEnum.getEnumByStateCode((Integer)billStateCode).getDescription());
        super.update((Wrapper)updateWrapper);
    }

    @Override
    public JSONObject fetchContractValue(Collection<Long> contractIds) {
        JSONObject jsonObject = new JSONObject();
        CommonResponse res = this.settlePoolApi.fetchTotalSettleTaxMny(contractIds);
        if (!res.isSuccess()) {
            throw new BusinessException("\u8c03\u7528\u7ed3\u7b97\u6c60\u63a5\u53e3\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg());
        }
        jsonObject.put("totalSettleTaxMny", this.initContractValue((Map)res.getData(), contractIds));
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.in((Object)CONTRACT_ID, contractIds);
        queryWrapper.eq((Object)"contract_payment_type", (Object)"\u9884\u4ed8\u6b3e");
        queryWrapper.groupBy((Object[])new String[]{CONTRACT_ID});
        queryWrapper.select(new String[]{"contract_id as contractId,(ifnull(sum(contract_plan_payment), 0) - ifnull(sum(release_apply_mny), 0)) as total"});
        List resultMap = super.listMaps((Wrapper)queryWrapper);
        jsonObject.put("lastTotalContractPlanPayment", this.initContractValue(this.converToMap(resultMap), contractIds));
        QueryWrapper queryWrapper1 = Wrappers.query();
        queryWrapper1.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper1.in((Object)CONTRACT_ID, contractIds);
        queryWrapper1.eq((Object)"contract_payment_type", (Object)"\u8fdb\u5ea6\u6b3e");
        queryWrapper1.groupBy((Object[])new String[]{CONTRACT_ID});
        queryWrapper1.select(new String[]{"contract_id as contractId,ifnull(sum(contract_deduction_advance_payment), 0) as total"});
        List resultMap1 = super.listMaps((Wrapper)queryWrapper1);
        jsonObject.put("lastTotalDeductionAdvancePayment", this.initContractValue(this.converToMap(resultMap1), contractIds));
        QueryWrapper queryWrapper2 = Wrappers.query();
        queryWrapper2.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper2.in((Object)CONTRACT_ID, contractIds);
        queryWrapper2.eq((Object)"contract_payment_type", (Object)"\u8fdb\u5ea6\u6b3e");
        queryWrapper2.groupBy((Object[])new String[]{CONTRACT_ID});
        queryWrapper2.select(new String[]{"contract_id as contractId,(ifnull(sum(contract_plan_payment), 0) - ifnull(sum(release_apply_mny), 0)) as total"});
        List resultMap2 = super.listMaps((Wrapper)queryWrapper2);
        jsonObject.put("lastTotalApplySchedulePayment", this.initContractValue(this.converToMap(resultMap2), contractIds));
        QueryWrapper queryWrapper3 = Wrappers.query();
        queryWrapper3.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper3.in((Object)CONTRACT_ID, contractIds);
        queryWrapper3.groupBy((Object[])new String[]{CONTRACT_ID});
        queryWrapper3.select(new String[]{"contract_id as contractId,(ifnull(sum(contract_plan_payment), 0) - ifnull(sum(release_apply_mny), 0)) as total"});
        List resultMap3 = super.listMaps((Wrapper)queryWrapper3);
        jsonObject.put("lastTotalAppliedPayment", this.initContractValue(this.converToMap(resultMap3), contractIds));
        return jsonObject;
    }

    private Map<String, Object> converToMap(List<Map<String, Object>> listMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Map<String, Object> map : listMap) {
            if (resultMap.containsKey(map.get("contractId").toString())) continue;
            resultMap.put(map.get("contractId").toString(), map.get("total").toString());
        }
        return resultMap;
    }

    private Map<String, Object> initContractValue(Map<String, Object> existMap, Collection<Long> contractIds) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!existMap.isEmpty()) {
            map.putAll(existMap);
            for (Long contractId : contractIds) {
                if (map.containsKey(contractId.toString())) continue;
                map.put(contractId.toString(), BigDecimal.ZERO);
            }
        } else {
            for (Long contractId : contractIds) {
                map.put(contractId.toString(), BigDecimal.ZERO);
            }
        }
        return map;
    }
}

