/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.projectloan.service.impl;

import com.ejianc.business.profinance.projectloan.bean.ProjectLoanEntity;
import com.ejianc.business.profinance.projectloan.bean.ProjectRepayDetailEntity;
import com.ejianc.business.profinance.projectloan.bean.ProjectRepayEntity;
import com.ejianc.business.profinance.projectloan.service.IProjectLoanService;
import com.ejianc.business.profinance.projectloan.service.IProjectRepayService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="projectRepay")
public class ProjectRepayBpmServiceImpl
implements ICommonBusinessService {
    private final IProjectRepayService service;
    private final IProjectLoanService projectLoanService;
    private final SessionManager sessionManager;
    private final IBillTypeApi billTypeApi;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ProjectRepayBpmServiceImpl(IProjectRepayService service, IProjectLoanService projectLoanService, SessionManager sessionManager, IBillTypeApi billTypeApi) {
        this.service = service;
        this.projectLoanService = projectLoanService;
        this.sessionManager = sessionManager;
        this.billTypeApi = billTypeApi;
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--start\uff0cbillId={},state={},billTypeCode={}", new Object[]{billId, state, billTypeCode});
        ProjectRepayEntity entity = (ProjectRepayEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        UserContext userContext = this.sessionManager.getUserContext();
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            entity.setCommitDate(new Date());
            entity.setCommitUserCode(userContext.getUserCode());
            entity.setCommitUserName(userContext.getUserName());
        }
        entity.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)state).getDescription());
        entity.setEffectiveDate(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        this.writeBackProjectLoan(entity, true);
        if (CollectionUtils.isNotEmpty(entity.getProjectRepayDetailList())) {
            List<Long> sourceLoanIds = entity.getProjectRepayDetailList().stream().map(ProjectRepayDetailEntity::getSourceId).collect(Collectors.toList());
            this.projectLoanService.updateColumnValue(sourceLoanIds, "ref_status", "\u672a\u5f15\u7528");
        }
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--end");
        return CommonResponse.success((String)"\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\u6210\u529f");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        ProjectRepayEntity entity = (ProjectRepayEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("repay_unit_id", new Parameter("eq", (Object)entity.getRepayUnitId()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("effective_date", "desc");
        queryParam.setOrderMap(orderMap);
        List personRepayEntities = this.service.queryList(queryParam);
        if (!((ProjectRepayEntity)((Object)personRepayEntities.get(0))).getId().equals(entity.getId())) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u4e0d\u662f\u6700\u65b0\u5355\u636e\uff0c\u4e0d\u80fd\u64a4\u56de\u6216\u5f03\u5ba1\uff01");
        }
        this.writeBackProjectLoan(entity, false);
        if (CollectionUtils.isNotEmpty(entity.getProjectRepayDetailList())) {
            List<Long> sourceLoanIds = entity.getProjectRepayDetailList().stream().map(ProjectRepayDetailEntity::getSourceId).collect(Collectors.toList());
            this.projectLoanService.updateColumnValue(sourceLoanIds, "ref_status", "\u5f15\u7528");
        }
        return CommonResponse.success((String)"\u5355\u636e\u64a4\u56de\u6210\u529f");
    }

    private void writeBackProjectLoan(ProjectRepayEntity entity, boolean flag) {
        List<ProjectRepayDetailEntity> detailList = entity.getProjectRepayDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            Map repayDetailEntityMap = detailList.stream().collect(Collectors.toMap(ProjectRepayDetailEntity::getSourceId, Function.identity()));
            Set<Long> projectLoanIds = repayDetailEntityMap.keySet();
            Collection projectLoanList = this.projectLoanService.listByIds(projectLoanIds);
            for (ProjectLoanEntity projectLoan : projectLoanList) {
                ProjectRepayDetailEntity repayDetail = (ProjectRepayDetailEntity)((Object)repayDetailEntityMap.get(projectLoan.getId()));
                if (flag) {
                    projectLoan.setRepaidLoanMny(projectLoan.getRepaidLoanMny().add(repayDetail.getCurRepayMny()).setScale(2, RoundingMode.HALF_UP));
                } else {
                    projectLoan.setRepaidLoanMny(projectLoan.getRepaidLoanMny().subtract(repayDetail.getCurRepayMny()).setScale(2, RoundingMode.HALF_UP));
                }
                projectLoan.setLeftLoanMny(projectLoan.getLoanMny().subtract(projectLoan.getRepaidLoanMny()).setScale(2, RoundingMode.HALF_UP));
            }
            this.projectLoanService.saveOrUpdateBatch(new ArrayList(projectLoanList), 10, false);
        }
    }
}

