/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMPayApplyApi;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMPayApplyVO;
import com.ejianc.business.profinance.bean.ContractLawsuitEntity;
import com.ejianc.business.profinance.bean.PaymentApplyDetailEntity;
import com.ejianc.business.profinance.bean.PaymentApplyEntity;
import com.ejianc.business.profinance.bean.SalaryPayApplyEntity;
import com.ejianc.business.profinance.common.enums.BillHandleTypeEnum;
import com.ejianc.business.profinance.common.service.IBillHandleResultService;
import com.ejianc.business.profinance.common.vo.BillHandleResultVO;
import com.ejianc.business.profinance.enums.PayStatusEnum;
import com.ejianc.business.profinance.enums.PaymentTypeEnum;
import com.ejianc.business.profinance.mapper.PaymentApplyMapper;
import com.ejianc.business.profinance.service.IContractLawsuitService;
import com.ejianc.business.profinance.service.IPaymentApplyDetailService;
import com.ejianc.business.profinance.service.IPaymentApplyService;
import com.ejianc.business.profinance.service.ISalaryPayApplyService;
import com.ejianc.business.profinance.vo.ContractPaymentResultVO;
import com.ejianc.business.profinance.vo.PaymentApplyDetailVO;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.business.promaterial.check.api.ICheckApi;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.temporary.userecord.api.ITemporaryUseRecordApi;
import com.ejianc.business.temporary.userecord.vo.TemporaryUseRecordVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.seata.spring.annotation.GlobalTransactional;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="paymentApplyService")
public class PaymentApplyServiceImpl
extends BaseServiceImpl<PaymentApplyMapper, PaymentApplyEntity>
implements IPaymentApplyService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String OPERATE = "PROFINANCE_PAY_RESULT";
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private PaymentApplyMapper paymentApplyMapper;
    @Autowired
    private IContractLawsuitService lawsuitService;
    @Autowired
    private IPaymentApplyDetailService detailService;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private ISalaryPayApplyService payApplyService;
    @Autowired
    private IPMPayApplyApi ipmPayApplyApi;
    @Autowired
    private IBillHandleResultService billHandleResultService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICheckApi checkApi;
    @Autowired
    private ITemporaryUseRecordApi recordApi;
    private static final String BILL_CODE = "PAY_CON_REF";
    private static final String NO_CONTRACT_BILL_CODE = "PAY_NO_CON_REF";
    private static final String PROFINANCE_LOCK_KEY_PREFIX = "payment_apply_lock";
    private long retryInterval = 5000L;
    private final int maxRetryTime = 10;
    @Value(value="${sendPayToNC:#{NULL}}")
    private String paymentSendToNcAddr;
    @Autowired
    private IProSupplierApi proSupplierApi;

    @Override
    public CommonResponse updateSettlePool(List<Long> sourceIdS) {
        CommonResponse bySourceIds = this.settlePoolApi.getBySourceIds(sourceIdS);
        this.logger.info("\u67e5\u8be2\u4fe1\u606f" + JSONObject.toJSONString((Object)bySourceIds));
        if (bySourceIds.isSuccess()) {
            List data = (List)bySourceIds.getData();
            for (SettlePoolVO vo : data) {
                QueryWrapper listQuery = new QueryWrapper();
                listQuery.eq((Object)"source_id", (Object)vo.getSourceId());
                listQuery.select(new String[]{"ifnull(sum(current_apply_mny),0) as current_apply_mny"});
                listQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
                PaymentApplyDetailEntity entity = (PaymentApplyDetailEntity)((Object)this.detailService.getOne((Wrapper)listQuery));
                this.logger.info("\u7ed3\u7b97\u5355id-{}\u7d2f\u8ba1\u5df2\u7533\u8bf7\u4ed8\u6b3e\u91d1\u989d\uff1a{}", (Object)vo.getSourceId(), (Object)entity.getCurrentApplyMny());
                String sourceType = vo.getSourceType();
                vo.setAlreadyApplyMny(entity.getCurrentApplyMny());
                if (sourceType.equals(SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode()) || sourceType.equals(SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode())) {
                    if (vo.getTotalProcessTaxDifference() == null) continue;
                    vo.setResidueApplyMny(vo.getTotalProcessTaxDifference().subtract(vo.getAlreadyApplyMny()));
                    continue;
                }
                vo.setResidueApplyMny(vo.getCurTaxMny().subtract(vo.getAlreadyApplyMny()));
            }
            this.logger.info("\u4fee\u6539\u4fe1\u606f" + JSONObject.toJSONString((Object)data));
            CommonResponse listCommonResponse = this.settlePoolApi.saveOrUpdateBatch(data);
            this.logger.info("\u4fee\u6539\u8fd4\u56de\u4fe1\u606f" + JSONObject.toJSONString((Object)listCommonResponse));
            CommonResponse updateLate = this.settlePoolApi.getBySourceIds(sourceIdS);
            this.logger.info("\u4fee\u6539\u540e\u67e5\u8be2\u4fe1\u606f" + JSONObject.toJSONString((Object)updateLate));
            if (!listCommonResponse.isSuccess()) {
                this.logger.info("\u5408\u540c\u516c\u5171\u670d\u52a1\u9519\u8bef" + JSONObject.toJSONString((Object)listCommonResponse.getMsg()));
                throw new BusinessException(listCommonResponse.getMsg());
            }
        } else {
            this.logger.error(bySourceIds.getMsg());
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u83b7\u53d6\u7ed3\u7b97\u5355\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return CommonResponse.success();
    }

    @Override
    public boolean saveOrUpdatePaymentApply(PaymentApplyEntity entity, boolean syncEs) {
        if (entity.getPaymentContractFlag() == 0) {
            Integer finallyFlag;
            PaymentApplyEntity dbEntity = null;
            if (null != entity.getId()) {
                dbEntity = (PaymentApplyEntity)((Object)super.selectById((Serializable)entity.getId()));
            }
            if (0 == (finallyFlag = entity.getFinallyFlag())) {
                if (null == dbEntity || dbEntity.getFinallyFlag() == 1) {
                    this.logger.info("\u5f53\u524d\u4ed8\u6b3e\u7533\u8bf7\u7684\u662f\u5426\u6700\u540e\u4e00\u6b21\u4ed8\u6b3e\u72b6\u6001\u4e3a \u662f \uff0c\u8c03\u7528\u5408\u540c\u63a5\u53e3\u4fee\u6539\u5408\u540c\u5c65\u7ea6\u72b6\u6001\u4e3a\u5df2\u7ed3\u675f");
                    ContractPoolVO contractPoolVO = new ContractPoolVO();
                    contractPoolVO.setSyncWithContractBill(Boolean.valueOf(true));
                    contractPoolVO.setId(entity.getContractId());
                    contractPoolVO.setPerformanceStatus(ContractPerformanceStateEnum.\u5df2\u7ed3\u675f.getStateCode());
                    CommonResponse updateResp = this.contractPoolApi.updatePerformanceStatusByContractId(contractPoolVO);
                    if (!updateResp.isSuccess()) {
                        this.logger.error("\u4ed8\u6b3e\u7533\u8bf7\u6700\u540e\u4e00\u6b21\u4ed8\u6b3e\u66f4\u6539\u5408\u540c\u5c65\u7ea6\u72b6\u6001\uff0c{}", (Object)JSONObject.toJSONString((Object)updateResp));
                        throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u66f4\u65b0\u5408\u540c\u5c65\u7ea6\u72b6\u6001\u5931\u8d25\uff01");
                    }
                }
            } else if (null != dbEntity && dbEntity.getFinallyFlag() == 0) {
                if (null == dbEntity.getContractPerformanceStatus()) {
                    this.logger.error("\u4ed8\u6b3e\u5355\u6700\u540e\u4e00\u6b21\u4ed8\u6b3e\u7531\u662f\u6539\u4e3a\u5426\uff0c\u5f53\u524d\u5355\u636e\u5e76\u672a\u5b58\u50a8\u5408\u540c-\u3010{}\u3011\u539f\u6709\u5c65\u7ea6\u72b6\u6001\uff0c\u8bf7\u5904\u7406\uff01", (Object)dbEntity.getContractId());
                    throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u66f4\u65b0\u5408\u540c\u5c65\u7ea6\u72b6\u6001\u5931\u8d25\uff01");
                }
                this.logger.info("\u5f53\u524d\u4ed8\u6b3e\u7533\u8bf7\u7684\u662f\u5426\u6700\u540e\u4e00\u6b21\u4ed8\u6b3e\u72b6\u6001\u4e3a \u5426, \u65e7\u4ed8\u6b3e\u7533\u8bf7\u6570\u636e\u4e3a\u662f\uff0c\u8fd8\u539f\u5408\u540c-{}\u7684\u5c65\u7ea6\u72b6\u6001\u4e3a\uff1a{}", (Object)dbEntity.getContractId(), (Object)dbEntity.getContractPerformanceStatus());
                ContractPoolVO contractPoolVO = new ContractPoolVO();
                contractPoolVO.setSyncWithContractBill(Boolean.valueOf(true));
                contractPoolVO.setId(entity.getContractId());
                contractPoolVO.setPerformanceStatus(dbEntity.getContractPerformanceStatus());
                CommonResponse updateResp = this.contractPoolApi.updatePerformanceStatusByContractId(contractPoolVO);
                if (!updateResp.isSuccess()) {
                    this.logger.error("\u4ed8\u6b3e\u7533\u8bf7\u6700\u540e\u4e00\u6b21\u4ed8\u6b3e\u66f4\u6539\u5408\u540c\u5c65\u7ea6\u72b6\u6001\uff0c{}", (Object)JSONObject.toJSONString((Object)updateResp));
                    throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u66f4\u65b0\u5408\u540c\u5c65\u7ea6\u72b6\u6001\u5931\u8d25\uff01");
                }
            }
        }
        return super.saveOrUpdate((Object)entity, syncEs);
    }

    @Override
    public CommonResponse<PaymentApplyVO> queryUnusedPaymentApply(Integer paymentType, Long projectId, Long supplierId, Date applyDate) {
        PaymentApplyVO paymentApplyVO = new PaymentApplyVO();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(PaymentApplyEntity::getPaymentType, (Object)paymentType);
        lambda.eq(PaymentApplyEntity::getProjectId, (Object)projectId);
        lambda.eq(PaymentApplyEntity::getSupplierId, (Object)supplierId);
        lambda.and(c -> (LambdaQueryWrapper)c.notIn(PaymentApplyEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        int resultCount = super.count((Wrapper)lambda);
        if (resultCount > 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u6761\u4ef6\uff08\u540c\u4e00\u9879\u76ee+\u4f9b\u5e94\u5546+\u4ed8\u6b3e\u7c7b\u578b\uff09\u5df2\u6709\u672a\u751f\u6548\u7684\u5355\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u9879\u76ee\u3001\u4f9b\u5e94\u5546\u6216\u4ed8\u6b3e\u7c7b\u578b\uff01\u3002");
        }
        Date resultDate = this.queryMaxApplyDate(paymentType, projectId, supplierId);
        if (null == resultDate) {
            resultDate = null != applyDate ? applyDate : new Date();
            paymentApplyVO.setMinApplyDate(null);
        } else {
            resultDate = DateUtils.addSeconds((Date)resultDate, (int)1);
            paymentApplyVO.setMinApplyDate(resultDate);
            if (null != applyDate && applyDate.compareTo(resultDate) > 0) {
                resultDate = applyDate;
            }
        }
        paymentApplyVO.setApplyDate(resultDate);
        paymentApplyVO.setProjectId(projectId);
        paymentApplyVO.setSupplierId(supplierId);
        paymentApplyVO.setPaymentType(paymentType);
        this.queryNoContractTotalMny(paymentApplyVO);
        return CommonResponse.success((String)"\u5f53\u524d\u7533\u8bf7\u5355\u53ef\u64cd\u4f5c\uff01", (Object)paymentApplyVO);
    }

    private Date queryMaxApplyDate(Integer paymentType, Long projectId, Long supplierId) {
        return this.paymentApplyMapper.selectMaxPaymentApplyDate(paymentType, projectId, supplierId);
    }

    private Date queryMaxDate(Integer paymentType, Long projectId, Long contractId) {
        return this.paymentApplyMapper.selectMaxDate(paymentType, projectId, contractId);
    }

    @Override
    public CommonResponse<PaymentApplyVO> checkPayApply(PaymentApplyVO vo) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(PaymentApplyEntity::getContractId, (Object)vo.getContractId());
        lambda.eq(PaymentApplyEntity::getProjectId, (Object)vo.getProjectId());
        lambda.eq(PaymentApplyEntity::getCloseState, (Object)0);
        lambda.and(c -> (LambdaQueryWrapper)c.notIn(PaymentApplyEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        int resultCount = super.count((Wrapper)lambda);
        if (resultCount > 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u6761\u4ef6\uff08\u5408\u540c\uff09\u5df2\u6709\u672a\u751f\u6548\u7684\u5355\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\uff01");
        }
        PaymentApplyVO entity = new PaymentApplyVO();
        Date resultDate = this.queryMaxDate(vo.getPaymentType(), vo.getProjectId(), vo.getContractId());
        if (null == resultDate) {
            resultDate = null != vo.getApplyDate() ? vo.getApplyDate() : new Date();
            entity.setMinApplyDate(null);
        } else {
            resultDate = DateUtils.addSeconds((Date)resultDate, (int)1);
            entity.setMinApplyDate(resultDate);
            if (null != vo.getApplyDate() && vo.getApplyDate().compareTo(resultDate) > 0) {
                resultDate = vo.getApplyDate();
            }
        }
        entity.setApplyDate(resultDate);
        return CommonResponse.success((String)"\u5f53\u524d\u7533\u8bf7\u5355\u53ef\u64cd\u4f5c\uff01", (Object)entity);
    }

    @Override
    public BigDecimal queryAdvanceApplyMny(PaymentApplyVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)vo.getContractId()));
        queryParam.getParams().put("project_id", new Parameter("eq", (Object)vo.getProjectId()));
        queryParam.getParams().put("paymentType", new Parameter("eq", (Object)1));
        queryParam.getParams().put("close_state", new Parameter("eq", (Object)0));
        queryParam.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List paymentApplyEntities = super.queryList(queryParam, false);
        BigDecimal advanceApplyMny = BigDecimal.ZERO;
        for (PaymentApplyEntity entity : paymentApplyEntities) {
            if (entity.getApprovalMny() == null) continue;
            advanceApplyMny = advanceApplyMny.add(entity.getApprovalMny());
        }
        return advanceApplyMny;
    }

    @Override
    public BigDecimal queryTotalPayMny(PaymentApplyVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)vo.getContractId()));
        queryParam.getParams().put("project_id", new Parameter("eq", (Object)vo.getProjectId()));
        queryParam.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List paymentApplyEntities = super.queryList(queryParam, false);
        BigDecimal totalPayMny = BigDecimal.ZERO;
        for (PaymentApplyEntity entity : paymentApplyEntities) {
            if (entity.getApplyMny() == null || entity.getActualMny() == null) continue;
            totalPayMny = totalPayMny.add(entity.getActualMny());
        }
        return totalPayMny;
    }

    @Override
    public BigDecimal queryLastApplyMny(PaymentApplyVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)vo.getContractId()));
        queryParam.getParams().put("project_id", new Parameter("eq", (Object)vo.getProjectId()));
        queryParam.getParams().put("close_state", new Parameter("eq", (Object)0));
        queryParam.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List paymentApplyEntities = super.queryList(queryParam, false);
        BigDecimal advanceApplyMny = BigDecimal.ZERO;
        for (PaymentApplyEntity entity : paymentApplyEntities) {
            if (entity.getApprovalMny() == null) continue;
            advanceApplyMny = advanceApplyMny.add(entity.getApprovalMny());
        }
        return advanceApplyMny;
    }

    @Override
    public BigDecimal queryPendDeduct(PaymentApplyVO vo) {
        BigDecimal advanceMny = BigDecimal.ZERO;
        BigDecimal normalMny = BigDecimal.ZERO;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)vo.getContractId()));
        queryParam.getParams().put("project_id", new Parameter("eq", (Object)vo.getProjectId()));
        queryParam.getParams().put("payment_type", new Parameter("eq", (Object)0));
        queryParam.getParams().put("close_state", new Parameter("eq", (Object)0));
        queryParam.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List normalList = super.queryList(queryParam, false);
        for (PaymentApplyEntity entity : normalList) {
            if (entity.getDeductAdvancePayment() == null) continue;
            normalMny = normalMny.add(entity.getDeductAdvancePayment());
        }
        QueryParam query = new QueryParam();
        query.getParams().put("contract_id", new Parameter("eq", (Object)vo.getContractId()));
        query.getParams().put("project_id", new Parameter("eq", (Object)vo.getProjectId()));
        query.getParams().put("payment_type", new Parameter("eq", (Object)1));
        query.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        queryParam.getParams().put("close_state", new Parameter("eq", (Object)0));
        List advanceList = super.queryList(query, false);
        for (PaymentApplyEntity entity : advanceList) {
            if (entity.getApplyMny() == null) continue;
            advanceMny = advanceMny.add(entity.getApplyMny());
        }
        BigDecimal pendDeductAdvancePayment = advanceMny.subtract(normalMny);
        BigDecimal paySalary = BigDecimal.ZERO;
        if (StringUtils.isNotEmpty((String)vo.getSourceCategoryType()) || ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode().equals(vo.getSourceCategoryType())) {
            QueryParam queryParam1 = new QueryParam();
            queryParam1.getParams().put("contract_id", new Parameter("eq", (Object)vo.getContractId()));
            queryParam1.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
            queryParam1.getParams().put("is_repeat_bill", new Parameter("eq", (Object)0));
            List payApplyEntities = this.payApplyService.queryList(queryParam1);
            for (SalaryPayApplyEntity entity : payApplyEntities) {
                if (null == entity.getApplyTaxMny()) continue;
                paySalary = paySalary.add(entity.getApplyTaxMny());
            }
        }
        return pendDeductAdvancePayment.add(paySalary);
    }

    @Override
    public BigDecimal queryTotalLitigationMny(PaymentApplyVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)vo.getContractId()));
        queryParam.getParams().put("project_id", new Parameter("eq", (Object)vo.getProjectId()));
        queryParam.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List entities = this.lawsuitService.queryList(queryParam, false);
        BigDecimal advanceApplyMny = BigDecimal.ZERO;
        for (ContractLawsuitEntity entity : entities) {
            if (entity.getSettleMny() == null) continue;
            advanceApplyMny = advanceApplyMny.add(entity.getSettleMny());
        }
        System.err.println("\u7d2f\u8ba1\u8bc9\u8bbc" + JSONObject.toJSONString((Object)advanceApplyMny));
        return advanceApplyMny;
    }

    @Override
    public BigDecimal queryLastLitigationMny(PaymentApplyVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)vo.getContractId()));
        queryParam.getParams().put("project_id", new Parameter("eq", (Object)vo.getProjectId()));
        queryParam.getParams().put("paymentType", new Parameter("eq", (Object)vo.getPaymentType()));
        queryParam.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        queryParam.getParams().put("close_state", new Parameter("eq", (Object)0));
        List paymentApplyEntities = super.queryList(queryParam, false);
        BigDecimal lastLitigationMny = BigDecimal.ZERO;
        for (PaymentApplyEntity entity : paymentApplyEntities) {
            if (entity.getApprovalMny() == null) continue;
            lastLitigationMny = lastLitigationMny.add(entity.getApprovalMny());
        }
        return lastLitigationMny;
    }

    @Override
    public BigDecimal queryAlreadyApplyMny(String sourceId) {
        return this.detailService.queryAlreadyApplyMny(sourceId);
    }

    @Override
    public Map<String, Object> countSumMny(QueryParam param) {
        QueryWrapper wrapper = PaymentApplyServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(apply_mny) as totalApplyMny, sum(approval_mny) as totalApprovalMny, sum(actual_mny) as totalActualMny"});
        HashMap<String, Integer> resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap<String, Integer>();
            resp.put("totalApplyMny", 0);
            resp.put("totalApprovalMny", 0);
            resp.put("totalActualMny", 0);
        }
        return resp;
    }

    @Override
    public BigDecimal queryTotalLawsuitMny(PaymentApplyVO vo) {
        return this.lawsuitService.queryTotalLawsuitMny(vo.getContractId()) == null ? BigDecimal.ZERO : this.lawsuitService.queryTotalLawsuitMny(vo.getContractId());
    }

    @Override
    public List<PaymentApplyVO> queryListByContractId(Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getOrderMap().put("apply_date", "desc");
        List list = super.queryList(param);
        List<Object> vos = new ArrayList<PaymentApplyVO>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vos = BeanMapper.mapList((Iterable)list, PaymentApplyVO.class);
        }
        return vos;
    }

    @Override
    public CommonResponse<ContractPaymentResultVO> queryJsonByContractId(Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getOrderMap().put("apply_date", "desc");
        List list = super.queryList(param);
        List vos = new ArrayList();
        BigDecimal totalApplyMny = BigDecimal.ZERO;
        BigDecimal totalApprovalMny = BigDecimal.ZERO;
        BigDecimal totalActualMny = BigDecimal.ZERO;
        BigDecimal paymentRate = BigDecimal.ZERO;
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        BigDecimal contractMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            contractTaxMny = ((PaymentApplyEntity)((Object)list.get(0))).getContractTaxMny();
            contractMny = ((PaymentApplyEntity)((Object)list.get(0))).getContractMny();
            for (PaymentApplyEntity entity : list) {
                if (null != entity.getApplyMny()) {
                    totalApplyMny = totalApplyMny.add(entity.getApplyMny());
                }
                if (null != entity.getApprovalMny()) {
                    totalApprovalMny = totalApprovalMny.add(entity.getApprovalMny());
                }
                if (null == entity.getActualMny()) continue;
                totalActualMny = totalActualMny.add(entity.getActualMny());
            }
            paymentRate = totalActualMny.divide(contractTaxMny, 2);
            vos = BeanMapper.mapList((Iterable)list, PaymentApplyVO.class);
        }
        ContractPaymentResultVO resultVO = new ContractPaymentResultVO();
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.eq((Object)"contract_id", (Object)contractId);
        listQuery.eq((Object)"bill_state", (Object)BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        int resultCount = super.count((Wrapper)listQuery);
        resultVO.setAddFlag(Boolean.valueOf(resultCount <= 0));
        resultVO.setTotalStayActualMny(totalApplyMny.subtract(totalActualMny));
        resultVO.setContractId(contractId);
        resultVO.setContractMny(contractMny);
        resultVO.setContractTaxMny(contractTaxMny);
        resultVO.setTotalApplyMny(totalApplyMny);
        resultVO.setTotalApprovalMny(totalApprovalMny);
        resultVO.setTotalActualMny(totalActualMny);
        resultVO.setPaymentRate(paymentRate);
        resultVO.setPaymentApplyList(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)resultVO);
    }

    @Override
    public BigDecimal queryContractHonourMny(PaymentApplyVO vo) {
        ContractPoolVO contractPoolVO = new ContractPoolVO();
        contractPoolVO.setContractId(vo.getContractId());
        contractPoolVO.setSourceTypeName(vo.getSourceCategoryTypeName());
        contractPoolVO.setSourceType(vo.getSourceCategoryType());
        CommonResponse res = this.contractPoolApi.queryContractHonourMny(contractPoolVO);
        if (!res.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u5408\u540c\u5c65\u7ea6\u91d1\u989d\u62a5\u9519\uff1a" + res.getMsg());
        }
        return (BigDecimal)res.getData();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<PaymentApplyVO> updateCloseState(PaymentApplyEntity entity, String type) {
        boolean b = this.detailService.releaseApplyList(entity);
        if (!b) {
            return CommonResponse.error((String)"\u4ed8\u6b3e\u5355\u5173\u95ed\u5931\u8d25\uff0c\u56de\u5199\u7ed3\u7b97\u5355\u5269\u4f59\u53ef\u7533\u8bf7\u91d1\u989d\u5931\u8d25\uff01");
        }
        this.logger.info("\u7ed3\u7b97\u5355\u53ef\u7533\u8bf7\u91d1\u989d\u91ca\u653e\u5b8c\u6bd5 \u5f00\u59cb\u5bf9\u63a5\u4e00\u952e\u652f\u4ed8");
        String PMMsg = this.abandonOrClose(entity, type);
        if (StringUtils.isNotBlank((String)PMMsg)) {
            this.logger.error("\u4ed8\u6b3e\u5355-[{}]\u5173\u95ed\u5931\u8d25\uff0c\u66f4\u65b0\u4ed8\u6b3e\u4e2d\u95f4\u8868\u5931\u8d25\uff0c\u56de\u6eda\u7ed3\u7b97\u5355\u91ca\u653e\u7684\u53ef\u652f\u4ed8\u91d1\u989d! ", (Object)JSONObject.toJSONString((Object)((Object)entity)));
            throw new BusinessException(PMMsg);
        }
        this.logger.info("\u5bf9\u63a5\u4e00\u952e\u652f\u4ed8\u5b8c\u6bd5 \u5f00\u59cb\u4fee\u6539\u5b9e\u4f53");
        super.saveOrUpdate((Object)entity, false);
        PaymentApplyVO vo = (PaymentApplyVO)BeanMapper.map((Object)((Object)entity), PaymentApplyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String abandonOrClose(PaymentApplyEntity entity, String type) {
        boolean locked = false;
        String handleMsg = null;
        StringBuilder msgBuilder = new StringBuilder();
        msgBuilder.append("\u4ed8\u6b3e\u5355[").append(entity.getBillCode()).append("]\u4e2d\u95f4\u8868\u5904\u7406");
        Jedis jedis = this.jedisPool.getResource();
        String contractS = "-1";
        if (entity.getContractId() != null) {
            contractS = entity.getContractId().toString();
        }
        String redisKey = entity.getProjectId() + "::" + entity.getSupplierId() + "::" + contractS + "::" + entity.getPayeeId();
        boolean flag = false;
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)redisKey, (String)"PROFINANCE_PAY_RESULT", (int)600);
            if (!locked) {
                this.logger.error("\u4ed8\u6b3e\u5355\u636e{}\u8fdb\u884c\u64cd\u4f5c\uff1a{} \u5931\u8d25\uff0c\u6839\u636e\u5355\u636e\u83b7\u53d6redis\u9501\u5931\u8d25\uff01", (Object)JSONObject.toJSONString((Object)((Object)entity)), (Object)type);
                msgBuilder.append("\u5931\u8d25\uff0c\u64cd\u4f5c\u524d\u83b7\u53d6Redis\u9501\u5931\u8d25\uff01");
                this.billHandleResultService.sendHandleResult(JSONObject.toJSONString((Object)((Object)entity)), entity.getId().toString(), BillHandleTypeEnum.\u4ed8\u6b3e\u7533\u8bf7\u5355.getTypeCode(), BillHandleResultVO.HANDLE_CODE_FAIL, msgBuilder.toString(), false);
                String string = "\u64cd\u4f5c\u5931\u8d25\uff0c\u4ed8\u6b3e\u5355\u66f4\u65b0\u8d22\u52a1\u8868\u524d\u52a0\u9501\u5931\u8d25\uff01";
                return string;
            }
            PMPayApplyVO paramVO = new PMPayApplyVO();
            paramVO.setProjectId(entity.getProjectId().toString());
            paramVO.setSupplierId(entity.getSupplierId().toString());
            paramVO.setPayeeId(entity.getPayeeId().toString());
            Integer paymentContractFlag = entity.getPaymentContractFlag();
            Long contractId = entity.getContractId();
            paramVO.setIsContract(null);
            paramVO.setContractRegisterId(null);
            if (paymentContractFlag != null) {
                if (paymentContractFlag == 0) {
                    paramVO.setIsContract(Integer.valueOf(1));
                    paramVO.setContractRegisterId(contractId.toString());
                } else {
                    paramVO.setIsContract(Integer.valueOf(0));
                    paramVO.setContractRegisterId("-1");
                }
            }
            paramVO.setCurApplyMny(entity.getApprovalMny());
            if ("\u5173\u95ed".equals(type)) {
                paramVO.setType(Integer.valueOf(2));
                paramVO.setCurReleaseMny(entity.getApprovalMny().subtract(null != entity.getActualMny() ? entity.getActualMny() : BigDecimal.ZERO));
            } else if ("\u5f03\u5ba1".equals(type)) {
                paramVO.setType(Integer.valueOf(1));
                paramVO.setCurReleaseMny(entity.getApprovalMny());
            }
            this.logger.info("\u8c03\u7528zzyj-financeintegration\uff0c\u5bf9\u4ed8\u6b3e\u5355\u8fdb\u884c\u3010{}\u3011\u64cd\u4f5c\uff0c\u6570\u636e-\u3010{}\u3011", (Object)type, (Object)JSONObject.toJSONString((Object)paramVO));
            CommonResponse res = this.ipmPayApplyApi.abandonOrClose(paramVO);
            this.logger.info("\u8c03\u7528zzyj-financeintegration\uff0c\u5bf9\u4ed8\u6b3e\u5355\u8fdb\u884c\u3010{}\u3011\u64cd\u4f5c\uff0c\u6570\u636e-\u3010{}\u3011\uff0c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c-{}", new Object[]{type, JSONObject.toJSONString((Object)paramVO), JSONObject.toJSONString((Object)res, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
            if (!res.isSuccess()) {
                this.logger.error("\u8c03\u7528PM\u4ed8\u6b3e\u7533\u8bf7\u7684\u63a5\u53e3 \u8fd4\u56de\u9519\u8bef\u4fe1\u606f: {}", (Object)JSONObject.toJSONString((Object)res));
                msgBuilder.append("\u5931\u8d25\uff0c\u8c03\u7528PM\u4ed8\u6b3e\u7533\u8bf7\u63a5\u53e3\u8fd4\u56de\u5931\u8d25\uff0c\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff1a" + res.getMsg());
                this.billHandleResultService.sendHandleResult(JSONObject.toJSONString((Object)((Object)entity)), entity.getId().toString(), BillHandleTypeEnum.\u4ed8\u6b3e\u7533\u8bf7\u5355.getTypeCode(), BillHandleResultVO.HANDLE_CODE_FAIL, msgBuilder.toString(), false);
                handleMsg = StringUtils.isNotBlank((String)res.getMsg()) ? res.getMsg() : "\u64cd\u4f5c\u5931\u8d25\uff0c\u4ed8\u6b3e\u5355\u66f4\u65b0\u8d22\u52a1\u8868\u5931\u8d25\uff01";
            } else {
                flag = true;
            }
        }
        catch (Exception e) {
            flag = false;
            this.logger.error("\u6267\u884c\u5237\u6570\u636e-\u3010{}\u3011\u903b\u8f91\u5f02\u5e38\uff0c", (Object)JSONObject.toJSONString((Object)((Object)entity)), (Object)e);
            msgBuilder.append("\u5931\u8d25\uff0c\u4e2d\u95f4\u8868\u5904\u7406\u5f02\u5e38\uff1a" + e.getMessage());
            handleMsg = "\u64cd\u4f5c\u5931\u8d25\uff0c\u4ed8\u6b3e\u5355\u66f4\u65b0\u8d22\u52a1\u8868\u5931\u8d25\uff01";
            this.billHandleResultService.sendHandleResult(JSONObject.toJSONString((Object)((Object)entity)), entity.getId().toString(), BillHandleTypeEnum.\u4ed8\u6b3e\u7533\u8bf7\u5355.getTypeCode(), BillHandleResultVO.HANDLE_CODE_FAIL, msgBuilder.toString(), false);
        }
        finally {
            this.releaseLock(jedis, locked, redisKey, "PROFINANCE_PAY_RESULT");
        }
        if (flag) {
            msgBuilder.append("\u6210\u529f\uff01");
            this.billHandleResultService.sendHandleResult(JSONObject.toJSONString((Object)((Object)entity)), entity.getId().toString(), BillHandleTypeEnum.\u4ed8\u6b3e\u7533\u8bf7\u5355.getTypeCode(), BillHandleResultVO.HANDLE_CODE_SUC, msgBuilder.toString(), false);
        }
        return handleMsg;
    }

    @Override
    public Map<Long, BigDecimal> querySumMny(Map<String, List<Long>> map) {
        this.logger.info("\u6253\u5370\u5165\u53c2map:" + JSONObject.toJSONString(map));
        HashMap<Long, BigDecimal> resultMap = new HashMap<Long, BigDecimal>();
        List<Long> suplyIds = map.get("suplyIds");
        List<Long> orgIds = map.get("orgIds");
        if (null == suplyIds || null == orgIds) {
            this.logger.info("\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25\uff01");
            return null;
        }
        List<PaymentApplyEntity> paymentApplyEntities = this.paymentApplyMapper.querySumMny(suplyIds, orgIds);
        for (PaymentApplyEntity entity : paymentApplyEntities) {
            resultMap.put(entity.getSupplierId(), entity.getActualMny());
        }
        return resultMap;
    }

    @Override
    @GlobalTransactional(name="PaymentApplyServiceImpl_batchDel", rollbackFor={Exception.class})
    public void batchDel(List<PaymentApplyVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        for (Long id : ids) {
            List<PaymentApplyDetailEntity> detailList;
            List sourceIdS;
            PaymentApplyEntity entity = (PaymentApplyEntity)((Object)super.selectById((Serializable)id));
            if (entity.getPaymentApplyDetailList().size() > 0 && (sourceIdS = (detailList = entity.getPaymentApplyDetailList()).stream().filter(item -> item.getSourceId() != null).map(PaymentApplyDetailEntity::getSourceId).collect(Collectors.toList())).size() > 0) {
                CommonResponse bySourceIds = this.settlePoolApi.getBySourceIds(sourceIdS);
                if (!bySourceIds.isSuccess()) {
                    throw new BusinessException(bySourceIds.getMsg());
                }
                List data = (List)bySourceIds.getData();
                Map<Long, PaymentApplyDetailEntity> detailMap = detailList.stream().collect(Collectors.toMap(PaymentApplyDetailEntity::getSourceId, detailEntity -> detailEntity));
                for (SettlePoolVO poolVO : data) {
                    PaymentApplyDetailEntity detailEntity2 = detailMap.get(poolVO.getSourceId());
                    poolVO.setResidueApplyMny(poolVO.getResidueApplyMny().add(detailEntity2.getCurrentApplyMny()).add(detailEntity2.getAdvancePaymentDeduction()));
                    if (poolVO.getSourceType().equals(SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode()) || poolVO.getSourceType().equals(SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode())) {
                        if (poolVO.getTotalProcessTaxDifference() == null) continue;
                        poolVO.setAlreadyApplyMny(poolVO.getTotalProcessTaxDifference().subtract(poolVO.getResidueApplyMny()));
                        continue;
                    }
                    poolVO.setAlreadyApplyMny(poolVO.getCurTaxMny().subtract(poolVO.getResidueApplyMny()));
                }
                this.logger.info(JSONObject.toJSONString((Object)data) + "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                CommonResponse listCommonResponse = this.settlePoolApi.saveOrUpdateBatch(data);
                if (!listCommonResponse.isSuccess()) {
                    throw new BusinessException(listCommonResponse.getMsg());
                }
            }
            if (entity.getFinallyFlag() == null || 0 != entity.getFinallyFlag() || null == entity.getContractId() || !StringUtils.isNotBlank((String)entity.getContractPerformanceStatus())) continue;
            ContractPoolVO contractPoolVO = new ContractPoolVO();
            contractPoolVO.setSyncWithContractBill(Boolean.valueOf(true));
            contractPoolVO.setId(entity.getContractId());
            contractPoolVO.setPerformanceStatus(entity.getContractPerformanceStatus());
            this.logger.info("\u66f4\u65b0\u5408\u540c-\u3010{}\u3011\u5c65\u7ea6\u72b6\u6001\u4e3a-{}\uff1a", (Object)contractPoolVO.getId(), (Object)entity.getContractPerformanceStatus());
            CommonResponse updateResp = this.contractPoolApi.updatePerformanceStatusByContractId(contractPoolVO);
            if (updateResp.isSuccess()) continue;
            throw new BusinessException(StringUtils.isNotBlank((String)updateResp.getMsg()) ? updateResp.getMsg() : "\u64cd\u4f5c\u5931\u8d25\uff0c\u66f4\u65b0\u5408\u540c\u6c60\u5c65\u7ea6\u72b6\u6001\u5931\u8d25\uff01");
        }
        super.removeByIds(ids, false);
    }

    @Override
    @GlobalTransactional(name="PaymentApplyServiceImpl_savePaymentApply", rollbackFor={Exception.class})
    public PaymentApplyVO savePaymentApply(PaymentApplyVO saveOrUpdateVO) {
        PaymentApplyEntity entity = (PaymentApplyEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PaymentApplyEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.generateBillCode(BillCodeParam.build((String)(saveOrUpdateVO.getPaymentContractFlag() == 0 ? BILL_CODE : NO_CONTRACT_BILL_CODE), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO));
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setPaymentStatus(1);
            entity.setCloseState(0);
            entity.setActualMny(BigDecimal.ZERO);
        }
        this.saveOrUpdatePaymentApply(entity, false);
        List<Long> sourceIdS = saveOrUpdateVO.getPaymentApplyDetailList().stream().filter(item -> item.getSourceId() != null).map(PaymentApplyDetailVO::getSourceId).collect(Collectors.toList());
        this.logger.info("\u672c\u6b21\u66f4\u65b0\u7ed3\u7b97\u5355Id\u5217\u8868-{}", (Object)JSONObject.toJSONString(sourceIdS));
        if (CollectionUtils.isNotEmpty(sourceIdS)) {
            this.updateSettlePool(sourceIdS);
        }
        return (PaymentApplyVO)BeanMapper.map((Object)((Object)entity), PaymentApplyVO.class);
    }

    @Override
    public JSONObject queryDataModelInfo(Long projectId) {
        this.logger.info("queryDataModelInfo--");
        JSONObject data = new JSONObject();
        DecimalFormat df1 = new DecimalFormat("0.##");
        BigDecimal totalPerformanceMny = BigDecimal.ZERO;
        BigDecimal checkTaxMny = BigDecimal.ZERO;
        BigDecimal recordTaxMny = BigDecimal.ZERO;
        BigDecimal totalSettleMny = BigDecimal.ZERO;
        BigDecimal totalActualMny = BigDecimal.ZERO;
        BigDecimal totalApprovalMny = BigDecimal.ZERO;
        CommonResponse jsonObjectCommonResponse = this.checkApi.querycheckMnyByProjectId(projectId);
        if (!jsonObjectCommonResponse.isSuccess()) {
            throw new BusinessException(jsonObjectCommonResponse.getMsg());
        }
        this.logger.info("\u83b7\u53d6\u6750\u6599\u9a8c\u6536\u5165\u5e93\u5355 \u7ed3\u679c\uff1a____{}\u8fd4\u56de\u5185\u5bb9:____{}", (Object)jsonObjectCommonResponse.isSuccess(), (Object)JSONObject.toJSONString((Object)jsonObjectCommonResponse));
        if (!jsonObjectCommonResponse.isSuccess()) {
            throw new BusinessException(jsonObjectCommonResponse.getMsg());
        }
        checkTaxMny = null != jsonObjectCommonResponse.getData() && ((JSONObject)jsonObjectCommonResponse.getData()).get((Object)"checkTaxMny") != null ? new BigDecimal(((JSONObject)jsonObjectCommonResponse.getData()).get((Object)"checkTaxMny").toString()) : BigDecimal.ZERO;
        CommonResponse response = this.recordApi.queryTemporaryUseProject(projectId);
        if (!response.isSuccess()) {
            throw new BusinessException(response.getMsg());
        }
        this.logger.info("\u4e34\u65f6\u8bbe\u5907\u4f7f\u7528\u8bb0\u5f55 \u7ed3\u679c\uff1a____{}\u8fd4\u56de\u5185\u5bb9:____{}", (Object)response.isSuccess(), (Object)JSONObject.toJSONString((Object)response));
        if (!jsonObjectCommonResponse.isSuccess()) {
            throw new BusinessException(jsonObjectCommonResponse.getMsg());
        }
        recordTaxMny = null != response.getData() && ((JSONObject)response.getData()).get((Object)"useMny") != null ? new BigDecimal(((JSONObject)response.getData()).get((Object)"useMny").toString()) : BigDecimal.ZERO;
        totalPerformanceMny = recordTaxMny.add(checkTaxMny);
        SettlePoolVO poolVO = new SettlePoolVO();
        poolVO.setProjectId(projectId);
        poolVO.setContractFlag(Integer.valueOf(0));
        poolVO.setSourceType("sporadic_material,temp_equip");
        CommonResponse settleRep = this.settlePoolApi.queryNoContractTotalMny(poolVO);
        this.logger.info("\u83b7\u53d6\u7ed3\u7b97\u91d1\u989d \u7ed3\u679c\uff1a____{}\u8fd4\u56de\u5185\u5bb9:____{}", (Object)settleRep.isSuccess(), (Object)JSONObject.toJSONString((Object)settleRep));
        if (!settleRep.isSuccess()) {
            throw new BusinessException(settleRep.getMsg());
        }
        totalSettleMny = null != settleRep && ((JSONObject)settleRep.getData()).get((Object)"totalSettleMny") != null ? new BigDecimal(((JSONObject)settleRep.getData()).get((Object)"totalSettleMny").toString()) : BigDecimal.ZERO;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.in((Object)"payment_type", Arrays.asList(PaymentTypeEnum.\u4e34\u65f6\u673a\u68b0.getCode(), PaymentTypeEnum.\u96f6\u661f\u6750\u6599.getCode()));
        List queryList = super.list((Wrapper)queryWrapper);
        for (PaymentApplyEntity entity : queryList) {
            if (entity.getActualMny() != null) {
                totalActualMny = totalActualMny.add(entity.getActualMny());
            }
            if (entity.getApprovalMny() == null) continue;
            totalApprovalMny = totalApprovalMny.add(entity.getApprovalMny());
        }
        totalApprovalMny = totalApprovalMny.compareTo(new BigDecimal("0E-8")) == 0 ? new BigDecimal("0") : totalApprovalMny;
        BigDecimal contractTaxMny = this.querySumContractMny(projectId);
        BigDecimal contractRate = BigDecimal.ZERO;
        if (contractTaxMny.compareTo(BigDecimal.ZERO) != 0 && totalApprovalMny.compareTo(BigDecimal.ZERO) != 0) {
            this.logger.info("totalApprovalMny--{}", (Object)totalApprovalMny);
            this.logger.info("contractTaxMny--{}", (Object)contractTaxMny);
            contractRate = totalApprovalMny.divide(contractTaxMny, 2);
            contractRate = contractRate.multiply(new BigDecimal("100"));
        }
        data.put("totalPerformanceMny", (Object)df1.format(totalPerformanceMny));
        data.put("totalSettleMny", (Object)df1.format(totalSettleMny));
        data.put("totalActualMny", (Object)df1.format(totalActualMny));
        data.put("totalApprovalMny", (Object)df1.format(totalApprovalMny));
        data.put("contractTaxMny", (Object)df1.format(contractTaxMny));
        if (!BigDecimal.ZERO.equals(contractRate)) {
            String format = df1.format(contractRate);
            data.put("contractRate", (Object)format);
        } else {
            data.put("contractRate", (Object)"0");
        }
        return data;
    }

    @Override
    public List<JSONObject> queryDataModelMaterial(Long projectId) {
        ArrayList<JSONObject> materialList = new ArrayList<JSONObject>();
        DecimalFormat df1 = new DecimalFormat("0.##");
        BigDecimal contractTaxMny = this.querySumContractMny(projectId);
        CommonResponse checkResponse = this.checkApi.querycheckListByProjectId(projectId);
        if (!checkResponse.isSuccess()) {
            throw new BusinessException(checkResponse.getMsg());
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)checkResponse.getData()))) {
            List data = (List)checkResponse.getData();
            Map<Long, List<CheckVO>> collect = data.stream().collect(Collectors.groupingBy(CheckVO::getSupplierId));
            for (Map.Entry<Long, List<CheckVO>> next : collect.entrySet()) {
                List<CheckVO> value = next.getValue();
                JSONObject material = new JSONObject();
                material.put("supplyName", (Object)value.get(0).getSupplierName());
                CommonResponse childrenCheck = this.checkApi.querycheckMnyById(projectId, next.getKey());
                this.logger.info("\u83b7\u53d6\u5c65\u7ea6\u91d1\u989d \u7ed3\u679c\uff1a____{}\u8fd4\u56de\u5185\u5bb9:____{}", (Object)childrenCheck.isSuccess(), (Object)JSONObject.toJSONString((Object)childrenCheck));
                if (!childrenCheck.isSuccess()) {
                    throw new BusinessException(childrenCheck.getMsg());
                }
                material.put("performanceMny", (Object)df1.format(null != childrenCheck.getData() && ((JSONObject)childrenCheck.getData()).get((Object)"checkTaxMny") != null ? new BigDecimal(((JSONObject)childrenCheck.getData()).get((Object)"checkTaxMny").toString()) : BigDecimal.ZERO));
                BigDecimal materialApprovalMny = BigDecimal.ZERO;
                BigDecimal materialActualMny = BigDecimal.ZERO;
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"project_id", (Object)projectId);
                queryWrapper.eq((Object)"supplier_id", (Object)next.getKey());
                queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
                queryWrapper.eq((Object)"payment_type", (Object)PaymentTypeEnum.\u96f6\u661f\u6750\u6599.getCode());
                List queryList = super.list((Wrapper)queryWrapper);
                for (PaymentApplyEntity entity : queryList) {
                    if (entity.getActualMny() != null) {
                        materialActualMny = materialActualMny.add(entity.getActualMny());
                    }
                    if (entity.getApprovalMny() == null) continue;
                    materialApprovalMny = materialApprovalMny.add(entity.getApprovalMny());
                }
                material.put("actualMny", (Object)df1.format(materialActualMny.compareTo(new BigDecimal("0E-8")) == 0 ? new BigDecimal("0") : materialActualMny));
                materialApprovalMny = materialApprovalMny.compareTo(new BigDecimal("0E-8")) == 0 ? new BigDecimal("0") : materialApprovalMny;
                material.put("approvalMny", (Object)materialApprovalMny);
                SettlePoolVO poolVO = new SettlePoolVO();
                poolVO.setProjectId(projectId);
                poolVO.setPartybId(value.get(0).getSupplierId());
                poolVO.setContractFlag(Integer.valueOf(0));
                poolVO.setSourceType("sporadic_material");
                CommonResponse settleRep = this.settlePoolApi.queryNoContractTotalMny(poolVO);
                this.logger.info("\u83b7\u53d6\u7ed3\u7b97\u91d1\u989d \u7ed3\u679c\uff1a____{}\u8fd4\u56de\u5185\u5bb9:____{}", (Object)settleRep.isSuccess(), (Object)JSONObject.toJSONString((Object)settleRep));
                if (!settleRep.isSuccess()) {
                    throw new BusinessException(settleRep.getMsg());
                }
                BigDecimal totalSettleMny = null != settleRep && ((JSONObject)settleRep.getData()).get((Object)"totalSettleMny") != null ? new BigDecimal(((JSONObject)settleRep.getData()).get((Object)"totalSettleMny").toString()) : BigDecimal.ZERO;
                material.put("totalSettleMny", (Object)df1.format(totalSettleMny));
                BigDecimal contractRate = BigDecimal.ZERO;
                if (contractTaxMny.compareTo(BigDecimal.ZERO) != 0 && materialApprovalMny.compareTo(BigDecimal.ZERO) != 0) {
                    contractRate = materialApprovalMny.divide(contractTaxMny, 2);
                    contractRate = contractRate.multiply(new BigDecimal("100"));
                }
                if (!BigDecimal.ZERO.equals(contractRate)) {
                    String format = df1.format(contractRate);
                    material.put("contractRate", (Object)format);
                } else {
                    material.put("contractRate", (Object)"0");
                }
                materialList.add(material);
            }
        }
        return materialList;
    }

    @Override
    public List<JSONObject> queryDataModelEquip(Long projectId) {
        ArrayList<JSONObject> equipList = new ArrayList<JSONObject>();
        BigDecimal contractTaxMny = this.querySumContractMny(projectId);
        CommonResponse listCommonResponse = this.recordApi.queryTemporaryListUseProject(projectId);
        DecimalFormat df1 = new DecimalFormat("0.##");
        if (!listCommonResponse.isSuccess()) {
            throw new BusinessException(listCommonResponse.getMsg());
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)listCommonResponse.getData()))) {
            List data = (List)listCommonResponse.getData();
            Map<Long, List<TemporaryUseRecordVO>> collect = data.stream().collect(Collectors.groupingBy(TemporaryUseRecordVO::getSupplierId));
            for (Map.Entry<Long, List<TemporaryUseRecordVO>> next : collect.entrySet()) {
                List<TemporaryUseRecordVO> value = next.getValue();
                JSONObject equip = new JSONObject();
                equip.put("supplyName", (Object)value.get(0).getSupplierName());
                CommonResponse childrenRec = this.recordApi.queryTemporaryUseRecordMny(projectId, next.getKey());
                this.logger.info("\u83b7\u53d6\u5c65\u7ea6\u91d1\u989d \u7ed3\u679c\uff1a____{}\u8fd4\u56de\u5185\u5bb9:____{}", (Object)childrenRec.isSuccess(), (Object)JSONObject.toJSONString((Object)childrenRec));
                if (!childrenRec.isSuccess()) {
                    throw new BusinessException(childrenRec.getMsg());
                }
                BigDecimal performanceMny = null != childrenRec.getData() && ((JSONObject)childrenRec.getData()).get((Object)"useMny") != null ? new BigDecimal(((JSONObject)childrenRec.getData()).get((Object)"useMny").toString()) : BigDecimal.ZERO;
                String format = df1.format(performanceMny);
                equip.put("performanceMny", (Object)format);
                BigDecimal equipApprovalMny = BigDecimal.ZERO;
                BigDecimal equipActualMny = BigDecimal.ZERO;
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"project_id", (Object)projectId);
                queryWrapper.eq((Object)"supplier_id", (Object)next.getKey());
                queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
                queryWrapper.eq((Object)"payment_type", (Object)PaymentTypeEnum.\u4e34\u65f6\u673a\u68b0.getCode());
                List queryList = super.list((Wrapper)queryWrapper);
                for (PaymentApplyEntity entity : queryList) {
                    if (entity.getActualMny() != null) {
                        equipActualMny = equipActualMny.add(entity.getActualMny());
                    }
                    if (entity.getApprovalMny() == null) continue;
                    equipApprovalMny = equipApprovalMny.add(entity.getApprovalMny());
                }
                equip.put("actualMny", (Object)df1.format(equipActualMny.compareTo(new BigDecimal("0E-8")) == 0 ? new BigDecimal("0") : equipActualMny));
                equip.put("approvalMny", (Object)df1.format(equipApprovalMny.compareTo(new BigDecimal("0E-8")) == 0 ? new BigDecimal("0") : equipApprovalMny));
                SettlePoolVO poolVO = new SettlePoolVO();
                poolVO.setProjectId(projectId);
                poolVO.setPartybId(value.get(0).getSupplierId());
                poolVO.setContractFlag(Integer.valueOf(0));
                poolVO.setSourceType("temp_equip");
                CommonResponse settleRep = this.settlePoolApi.queryNoContractTotalMny(poolVO);
                this.logger.info("\u83b7\u53d6\u7ed3\u7b97\u91d1\u989d \u7ed3\u679c\uff1a____{}\u8fd4\u56de\u5185\u5bb9:____{} \u67e5\u8be2\u6761\u4ef6----{}", new Object[]{settleRep.isSuccess(), JSONObject.toJSONString((Object)settleRep), JSONObject.toJSONString((Object)poolVO)});
                if (!settleRep.isSuccess()) {
                    throw new BusinessException(settleRep.getMsg());
                }
                BigDecimal totalSettleMny = null != settleRep && ((JSONObject)settleRep.getData()).get((Object)"totalSettleMny") != null ? new BigDecimal(((JSONObject)settleRep.getData()).get((Object)"totalSettleMny").toString()) : BigDecimal.ZERO;
                equip.put("totalSettleMny", (Object)df1.format(totalSettleMny.compareTo(new BigDecimal("0E-8")) == 0 ? new BigDecimal("0") : totalSettleMny));
                BigDecimal contractRate = BigDecimal.ZERO;
                if (contractTaxMny.compareTo(BigDecimal.ZERO) != 0 && equipApprovalMny.compareTo(BigDecimal.ZERO) != 0) {
                    contractRate = equipApprovalMny.divide(contractTaxMny, 2);
                    contractRate = contractRate.multiply(new BigDecimal("100"));
                }
                if (!BigDecimal.ZERO.equals(contractRate)) {
                    equip.put("contractRate", (Object)df1.format(contractRate));
                } else {
                    equip.put("contractRate", (Object)"0");
                }
                equipList.add(equip);
            }
        }
        return equipList;
    }

    @Override
    public void setTotalContractRelateMny(PaymentApplyVO paymentApplyVO) {
        HashMap<String, BigDecimal> info = new HashMap<String, BigDecimal>();
        QueryWrapper applyQuery = new QueryWrapper();
        applyQuery.select(new String[]{"sum( actual_paid_tax_mny ) AS totalActualPaidTaxMny, sum( apply_tax_mny ) as lastApplyTaxMny"});
        applyQuery.eq((Object)"contract_id", (Object)paymentApplyVO.getContractId());
        applyQuery.eq((Object)"is_repeat_bill", (Object)"0");
        applyQuery.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        Map validApplyResult = this.payApplyService.getMap((Wrapper)applyQuery);
        QueryWrapper payApplyQuery = new QueryWrapper();
        payApplyQuery.select(new String[]{"sum( actual_mny ) AS totalActualPaidTaxMny, sum( approval_mny ) as totalApproveTaxMny"});
        payApplyQuery.eq((Object)"contract_id", (Object)paymentApplyVO.getContractId());
        payApplyQuery.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        Map validPayApplyResult = super.getMap((Wrapper)payApplyQuery);
        info.put("totalContractActualPaidTaxMny", null != validApplyResult && null != validApplyResult.get("totalActualPaidTaxMny") ? new BigDecimal(validApplyResult.get("totalActualPaidTaxMny").toString()) : BigDecimal.ZERO);
        info.put("totalContractApproveTaxMny", null != validApplyResult && null != validApplyResult.get("lastApplyTaxMny") ? new BigDecimal(validApplyResult.get("lastApplyTaxMny").toString()) : BigDecimal.ZERO);
        info.put("totalContractActualPaidTaxMny", ((BigDecimal)info.get("totalContractActualPaidTaxMny")).add(null != validPayApplyResult && null != validPayApplyResult.get("totalActualPaidTaxMny") ? new BigDecimal(validPayApplyResult.get("totalActualPaidTaxMny").toString()) : BigDecimal.ZERO));
        info.put("totalContractApproveTaxMny", ((BigDecimal)info.get("totalContractApproveTaxMny")).add(null != validPayApplyResult && null != validPayApplyResult.get("totalApproveTaxMny") ? new BigDecimal(validPayApplyResult.get("totalApproveTaxMny").toString()) : BigDecimal.ZERO));
        paymentApplyVO.setContractTotalActualTaxMny((BigDecimal)info.get("totalContractActualPaidTaxMny"));
        paymentApplyVO.setContractTotalApproveTaxMny((BigDecimal)info.get("totalContractApproveTaxMny"));
    }

    private BigDecimal querySumContractMny(Long projectId) {
        QueryParam query = new QueryParam();
        query.getParams().put("project_id", new Parameter("eq", (Object)projectId));
        query.getParams().put("source_type", new Parameter("eq", (Object)ContractTypeEnum.\u65bd\u5de5\u5408\u540c.getTypeCode()));
        query.getParams().put("performance_status", new Parameter("in", Arrays.asList(ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode(), ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode())));
        CommonResponse bigDecimalCommonResponse = this.contractPoolApi.querySumContractMny(query);
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        if (!bigDecimalCommonResponse.isSuccess()) {
            throw new BusinessException(bigDecimalCommonResponse.getMsg());
        }
        if (bigDecimalCommonResponse.getData() != null && !BigDecimal.ZERO.equals(bigDecimalCommonResponse.getData())) {
            contractTaxMny = new BigDecimal(((BigDecimal)bigDecimalCommonResponse.getData()).toString());
        }
        return contractTaxMny.compareTo(new BigDecimal("0E-8")) == 0 ? new BigDecimal("0") : contractTaxMny;
    }

    public PaymentApplyVO queryNoContractTotalMny(PaymentApplyVO vo) {
        SettlePoolVO poolVO = new SettlePoolVO();
        poolVO.setProjectId(vo.getProjectId());
        poolVO.setPartybId(vo.getSupplierId());
        poolVO.setContractFlag(Integer.valueOf(0));
        poolVO.setSourceType(vo.getPaymentType() == 3 ? "sporadic_material" : "temp_equip");
        CommonResponse settleRep = this.settlePoolApi.queryNoContractTotalMny(poolVO);
        this.logger.info("\u83b7\u53d6\u7ed3\u7b97\u91d1\u989d \u7ed3\u679c\uff1a____{}\u8fd4\u56de\u5185\u5bb9:____{}", (Object)settleRep.isSuccess(), (Object)JSONObject.toJSONString((Object)settleRep));
        if (!settleRep.isSuccess()) {
            throw new BusinessException(settleRep.getMsg());
        }
        if (((JSONObject)settleRep.getData()).containsKey((Object)"totalSettleMny")) {
            BigDecimal checkTaxMny = ((JSONObject)settleRep.getData()).get((Object)"totalSettleMny") != null ? new BigDecimal(((JSONObject)settleRep.getData()).get((Object)"totalSettleMny").toString()) : BigDecimal.ZERO;
            vo.setTotalSettleMny(checkTaxMny);
        }
        if (vo.getPaymentType() == 3) {
            CommonResponse checkRsp = this.checkApi.querycheckMnyById(vo.getProjectId(), vo.getSupplierId());
            this.logger.info("\u83b7\u53d6\u5c65\u7ea6\u91d1\u989d \u7ed3\u679c\uff1a____{}\u8fd4\u56de\u5185\u5bb9:____{}", (Object)checkRsp.isSuccess(), (Object)JSONObject.toJSONString((Object)checkRsp));
            if (!checkRsp.isSuccess()) {
                throw new BusinessException(checkRsp.getMsg());
            }
            if (((JSONObject)checkRsp.getData()).containsKey((Object)"checkTaxMny")) {
                BigDecimal checkTaxMny = ((JSONObject)checkRsp.getData()).get((Object)"checkTaxMny") != null ? new BigDecimal(((JSONObject)checkRsp.getData()).get((Object)"checkTaxMny").toString()) : BigDecimal.ZERO;
                vo.setTotalPerformanceMny(checkTaxMny);
            }
        } else {
            CommonResponse recordRsp = this.recordApi.queryTemporaryUseRecordMny(vo.getProjectId(), vo.getSupplierId());
            this.logger.info("\u83b7\u53d6\u5c65\u7ea6\u91d1\u989d \u7ed3\u679c\uff1a____{}\u8fd4\u56de\u5185\u5bb9:____{}", (Object)recordRsp.isSuccess(), (Object)JSONObject.toJSONString((Object)recordRsp));
            if (!recordRsp.isSuccess()) {
                throw new BusinessException(recordRsp.getMsg());
            }
            if (((JSONObject)recordRsp.getData()).containsKey((Object)"useMny")) {
                BigDecimal useMny = ((JSONObject)recordRsp.getData()).get((Object)"useMny") != null ? new BigDecimal(((JSONObject)recordRsp.getData()).get((Object)"useMny").toString()) : BigDecimal.ZERO;
                vo.setTotalPerformanceMny(useMny);
            }
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("project_id", new Parameter("eq", (Object)vo.getProjectId()));
        queryParam.getParams().put("supplier_id", new Parameter("eq", (Object)vo.getSupplierId()));
        queryParam.getParams().put("payment_type", new Parameter("eq", (Object)vo.getPaymentType()));
        List applyList = super.queryList(queryParam);
        BigDecimal totalActualMny = BigDecimal.ZERO;
        for (PaymentApplyEntity entity : applyList) {
            if (entity.getActualMny() == null) continue;
            totalActualMny = totalActualMny.add(entity.getActualMny());
        }
        vo.setTotalActualMny(totalActualMny);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendPayToNC(PaymentApplyEntity sourceEntity) {
        Long id = sourceEntity.getId();
        this.logger.info("\u4ed8\u6b3e\u7533\u8bf7\u7684\u751f\u6548\u63a5\u53e3---sendPayToNC---begin\uff0c\u672c\u4ed8\u6b3e\u7533\u8bf7ID-{}", (Object)id);
        CommonResponse supplierDtoResp = this.proSupplierApi.selectById(sourceEntity.getSupplierId());
        if (!supplierDtoResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u4f9b\u5e94\u5546Id-{}\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25, {}", (Object)sourceEntity.getSupplierId(), (Object)JSONObject.toJSONString((Object)supplierDtoResp));
            return "\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        this.logger.info("\u6839\u636e\u672c\u4ed8\u6b3e\u7533\u8bf7ID-{}\uff0c\u67e5\u8be2\u5230\u7684\u672c\u4ed8\u6b3e\u7533\u8bf7\u6570\u636e-{}", (Object)id, (Object)JSONObject.toJSONString((Object)((Object)sourceEntity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        String redisKey = "payment_apply_lock::" + sourceEntity.getId();
        Jedis jedis = this.jedisPool.getResource();
        boolean lock = this.getLock(redisKey, jedis);
        if (!lock) {
            sourceEntity.setPaymentStatus(PayStatusEnum.\u63a8\u9001\u5f02\u5e38.getCode());
            this.logger.info("\u4ed8\u6b3e\u5355\u83b7\u53d6\uff1a\u952e-{}\u5c1d\u8bd5\u83b7\u53d6\u9501\u5931\u8d25", (Object)redisKey);
            return "\u4ed8\u6b3e\u5355\u5904\u7406\u52a0\u9501\u5931\u8d25\uff01";
        }
        this.logger.info("\u5bf9\u63a5NCC\u6570\u636e\u5f00\u59cb\u7ec4\u88c5---\u672c\u4ed8\u6b3e\u7533\u8bf7ID-{}", (Object)id);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)"F5");
        jsonObject.put("method", (Object)"ADD");
        JSONObject data = new JSONObject();
        data.put("pk_org", (Object)sourceEntity.getPayOrgCode());
        data.put("pk_jobid", (Object)"XN100101");
        data.put("pk_tradetypeid", (Object)"D5");
        data.put("pk_currtype", (Object)"CNY");
        data.put("bill_date", (Object)sdf.format(sourceEntity.getCreateTime()));
        data.put("bill_status", (Object)"-10");
        data.put("pk_balatype", (Object)sourceEntity.getPaymentPayTypeCode());
        data.put("bill_no", (Object)sourceEntity.getBillCode());
        data.put("def1", (Object)"N");
        data.put("pk_oppaccount", (Object)sourceEntity.getPayAccountNum());
        data.put("oppaccountname", (Object)sourceEntity.getPayAccountName());
        data.put("source_flag", (Object)"2");
        data.put("local_rate", (Object)"1.00");
        data.put("objecttype", (Object)"1");
        data.put("pk_supplier", (Object)((SupplierDTO)supplierDtoResp.getData()).getCode());
        data.put("pk_account", (Object)sourceEntity.getAccountNum());
        data.put("memo", (Object)sourceEntity.getPayUseMemo());
        List<PaymentApplyDetailEntity> detailList = sourceEntity.getPaymentApplyDetailList();
        ArrayList<JSONObject> detail = new ArrayList<JSONObject>();
        for (PaymentApplyDetailEntity d : detailList) {
            JSONObject j = new JSONObject();
            j.put("memo", (Object)(StringUtils.isNotBlank((String)d.getMemo()) ? d.getMemo() : sourceEntity.getPayUseMemo()));
            j.put("pk_currtype", (Object)"CNY");
            j.put("pk_balatype", (Object)sourceEntity.getPaymentPayTypeCode());
            j.put("pk_oppaccount", (Object)sourceEntity.getPayAccountNum());
            j.put("pay_primal", (Object)d.getCurrentApplyMny().toPlainString());
            j.put("local_rate", (Object)"1.00");
            detail.add(j);
        }
        data.put("detail", detail);
        jsonObject.put("data", (Object)data);
        this.logger.info("\u5bf9\u63a5NCC\u6570\u636e\u7ec4\u88c5\u5b8c\u6bd5---\u4ed8\u6b3e\u7533\u8bf7\u5355ID-{} --- \u7ec4\u88c5\u6570\u636e-{}", (Object)id, (Object)jsonObject.toJSONString());
        String sendUrl = this.paymentSendToNcAddr + "/uapws/rest/jhx/F5/doaction";
        this.logger.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u63a8\u9001NCC\u5730\u5740\uff1a{}", (Object)sendUrl);
        String sendErrMsg = null;
        try {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("content-type", "application/json;charset=UTF-8");
            String httpRespStr = HttpTookit.postByJson((String)sendUrl, (String)jsonObject.toJSONString(), headerMap, (Integer)10000, (Integer)10000);
            this.logger.info("\u8c03\u7528NCC\u7cfb\u7edfurl-{},param-{},\u6570\u636e\u8fd4\u56de\u7ed3\u679c\uff1a{}", new Object[]{sendUrl, JSONObject.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}), httpRespStr});
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)httpRespStr)) {
                JSONObject resultJson = JSONObject.parseObject((String)httpRespStr);
                String status = resultJson.getString("status");
                if (Integer.parseInt(status) != 0) {
                    this.logger.error("\u8c03\u7528NCC\u7cfb\u7edf\u6210\u529f\uff0c\u8fd4\u56de\u7ed3\u679c\u5931\u8d25!");
                    sourceEntity.setPaymentStatus(PayStatusEnum.\u63a8\u9001\u5f02\u5e38.getCode());
                    sendErrMsg = "\u8c03\u7528NCC\u7cfb\u7edf\u6210\u529f\uff0c\u8fd4\u56de\u7ed3\u679c\u5931\u8d25!";
                } else {
                    this.logger.info("\u5bf9\u63a5NCC\u6570\u636e\u8fd4\u56de---\u672c\u4ed8\u6b3e\u7533\u8bf7ID-{} --- \u8fd4\u56de\u6570\u636e-{}", (Object)id, (Object)resultJson.toJSONString());
                    String bill_no = resultJson.getString("bill_no");
                    sourceEntity.setPaymentStatus(PayStatusEnum.\u652f\u4ed8\u4e2d.getCode());
                    sourceEntity.setThirdSysBillPK(bill_no);
                }
            } else {
                sourceEntity.setPaymentStatus(PayStatusEnum.\u63a8\u9001\u5f02\u5e38.getCode());
                sendErrMsg = "\u4ed8\u6b3e\u7533\u8bf7\u5355\u63a8\u9001NCC\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\uff01";
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528NCC\u7cfb\u7edfurl-{},param-{}\u63a8\u9001NCC\u72b6\u6001\u5f02\u5e38\uff1a", new Object[]{sendUrl, JSONObject.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}), e});
            sourceEntity.setPaymentStatus(PayStatusEnum.\u63a8\u9001\u5f02\u5e38.getCode());
            sendErrMsg = "\u4ed8\u6b3e\u7533\u8bf7\u5355\u8c03\u7528NCC\u63a5\u53e3\u540c\u6b65\u5f02\u5e38\uff01";
        }
        finally {
            this.logger.info("redisKey-{}\u8fdb\u884cRedis\u9501\u91ca\u653e", (Object)redisKey);
            this.unLock(jedis, true, redisKey, "PROFINANCE_PAY_RESULT");
        }
        return StringUtils.isNotBlank((String)sendErrMsg) ? sendErrMsg : null;
    }

    public boolean getLock(String key, Jedis jedis) {
        boolean lock = false;
        for (int retryTime = 0; !lock && retryTime <= 10; ++retryTime) {
            try {
                if (retryTime <= 0) continue;
                this.logger.info("\u952e-{}\u7b2c{}\u6b21\u5c1d\u8bd5\u83b7\u53d6redis\u9501, \u7b2c{}\u6beb\u79d2\u540e\u5f00\u59cb\u5c1d\u8bd5", new Object[]{key, retryTime, (long)retryTime * this.retryInterval});
                Thread.sleep((long)retryTime * this.retryInterval);
                lock = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"PROFINANCE_PAY_RESULT", (int)600);
                if (!lock) continue;
                return true;
            }
            catch (Exception e) {
                this.logger.error("\u6839\u636e\u952e-{}\u83b7\u53d6reids\u9501\u5f02\u5e38", (Object)JSONObject.toJSONString((Object)key));
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unLock(Jedis jedis, boolean locked, String key, String operate) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)operate);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

