/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class DBUtil2 {
    private DataSource dataSource;

    public DBUtil2(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Connection getConnection() throws Exception {
        try {
            return this.dataSource.getConnection();
        }
        catch (Exception e) {
            throw new Exception("\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u9519 ");
        }
    }

    public Connection getConnectionForQuartzJob() throws Exception {
        try {
            return this.dataSource.getConnection();
        }
        catch (Exception e) {
            throw new Exception("\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u9519 ");
        }
    }

    public int setupdateData(String sql) throws Exception {
        Connection conn = this.getConnection();
        PreparedStatement preStatement = null;
        try {
            preStatement = conn.prepareStatement(sql);
            int n = preStatement.executeUpdate();
            return n;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        finally {
            try {
                preStatement.close();
                conn.close();
            }
            catch (SQLException e) {
                throw new Exception(e.getMessage());
            }
        }
    }

    public Map<String, Object> executeSqlForProcedure(String sql) throws Exception {
        Connection conn = this.getConnection();
        Statement cs = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            cs = conn.prepareCall("{" + sql + "}");
            cs.executeQuery();
            HashMap<String, Object> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        finally {
            try {
                cs.close();
                conn.close();
            }
            catch (SQLException e) {
                throw new Exception(e.getMessage());
            }
        }
    }

    public int updateExecuteBatch(List<String> sqlList) throws Exception {
        Connection conn = this.getConnectionForQuartzJob();
        Statement stmt = null;
        try {
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            String sql = "";
            for (int i = 0; i < sqlList.size(); ++i) {
                sql = sqlList.get(i);
                if (sql.endsWith(";")) {
                    sql = sql.substring(0, sql.length() - 1);
                }
                stmt.addBatch(sql);
                if (i <= 1 || (i + 1) % 1000 != 0) continue;
                stmt.executeBatch();
                conn.commit();
                stmt.clearBatch();
            }
            stmt.executeBatch();
            conn.commit();
            int n = sqlList.size();
            return n;
        }
        catch (Exception e) {
            conn.rollback();
            throw new Exception(e.getMessage());
        }
        finally {
            try {
                stmt.close();
                conn.close();
            }
            catch (SQLException e) {
                throw new Exception(e.getMessage());
            }
        }
    }

    public int updateExecuteBatchForCK(List<Map<String, Object>> dataList, String databaseName, String tableName) throws Exception {
        Connection conn = this.getConnectionForQuartzJob();
        Statement stmt = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String colums = " ";
            String values = " ";
            String insertSQL = " insert into " + tableName;
            Map<String, Object> mapTemp = dataList.get(0);
            for (Map.Entry<String, Object> entry : mapTemp.entrySet()) {
                colums = colums + entry.getKey() + ",";
                values = values + " ?,";
            }
            colums = colums.substring(0, colums.length() - 1);
            values = values.substring(0, values.length() - 1);
            insertSQL = insertSQL + " ( " + colums + ") VALUES (" + values + " ) ";
            stmt = conn.prepareStatement(insertSQL);
            for (int i = 0; i < dataList.size(); ++i) {
                Map<String, Object> map4 = dataList.get(i);
                int z = 1;
                for (Map.Entry<String, Object> entry : map4.entrySet()) {
                    if (entry.getValue() == null) {
                        stmt.setString(z, null);
                    } else if (entry.getValue() instanceof Date) {
                        stmt.setString(z, sdf.format(entry.getValue()));
                    } else if (entry.getValue() instanceof Time || entry.getValue() instanceof Timestamp) {
                        stmt.setString(z, sdf2.format(entry.getValue()));
                    } else if (entry.getValue() instanceof Integer) {
                        stmt.setInt(z, Integer.parseInt(entry.getValue().toString()));
                    } else if (entry.getValue() instanceof Float || entry.getValue() instanceof Long || entry.getValue() instanceof BigInteger || entry.getValue() instanceof Double || entry.getValue() instanceof BigDecimal) {
                        stmt.setString(z, entry.getValue() + "");
                    } else if (entry.getValue() instanceof Boolean) {
                        stmt.setString(z, entry.getValue() + "");
                    } else if (entry.getValue() instanceof Byte) {
                        stmt.setString(z, entry.getValue() + "");
                    } else if (entry.getValue() instanceof ArrayList) {
                        stmt.setString(z, entry.getValue().toString());
                    } else {
                        stmt.setString(z, entry.getValue().toString());
                    }
                    ++z;
                }
                stmt.addBatch();
                if (i <= 1 || (i + 1) % 1000 != 0) continue;
                stmt.executeBatch();
                stmt.clearBatch();
            }
            stmt.executeBatch();
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        finally {
            try {
                stmt.close();
                conn.close();
            }
            catch (SQLException e) {
                throw new Exception(e.getMessage());
            }
        }
    }

    public List<Map<String, Object>> queryForListForOracle(String sql, int limitFrom, int pageSize) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        int maxSize = -1;
        String[] fields = null;
        ArrayList<String> times = new ArrayList<String>();
        ArrayList<String> clob = new ArrayList<String>();
        ArrayList<String> binary = new ArrayList<String>();
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> row = null;
        conn = this.getConnection();
        int endNum = limitFrom + pageSize;
        String sql2 = "SELECT * FROM (SELECT A.*, ROWNUM RN  FROM (  " + sql + " ) A  WHERE ROWNUM <= " + endNum + "  ) \tWHERE RN >= " + limitFrom;
        if (sql.toLowerCase().indexOf("show") == 0 || sql.toLowerCase().indexOf("explain") == 0) {
            sql2 = sql;
        }
        pstmt = conn.prepareStatement(sql2);
        rs = pstmt.executeQuery();
        rsmd = rs.getMetaData();
        maxSize = rsmd.getColumnCount();
        fields = new String[maxSize];
        for (int i = 0; i < maxSize; ++i) {
            fields[i] = rsmd.getColumnLabel(i + 1);
            if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1)) || "oracle.sql.TIMESTAMP".equals(rsmd.getColumnClassName(i + 1))) {
                times.add(fields[i]);
            }
            if ("oracle.jdbc.OracleClob".equals(rsmd.getColumnClassName(i + 1)) || "oracle.jdbc.OracleBlob".equals(rsmd.getColumnClassName(i + 1))) {
                clob.add(fields[i]);
            }
            if (!"[B".equals(rsmd.getColumnClassName(i + 1))) continue;
            binary.add(fields[i]);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (rs.next()) {
            row = new LinkedHashMap<String, Object>();
            for (int i = 0; i < maxSize; ++i) {
                Object value;
                Object object = value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
                if (times.contains(fields[i]) && value != null) {
                    value = sdf.format(value);
                }
                if (clob.contains(fields[i]) && value != null) {
                    value = "(Blob)";
                }
                if (binary.contains(fields[i]) && value != null) {
                    value = new String((byte[])value);
                }
                row.put(fields[i], value);
            }
            rows.add(row);
        }
        try {
            rs.close();
            pstmt.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new Exception("\u53d6Oracle\u6570\u636e\u51fa\u9519\uff0c" + e.getMessage());
        }
        return rows;
    }

    public List<Map<String, Object>> queryForListForOracleForExport(String sql, int limitFrom, int pageSize) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        int maxSize = -1;
        String[] fields = null;
        ArrayList<String> times = new ArrayList<String>();
        ArrayList<String> clob = new ArrayList<String>();
        ArrayList<String> blob = new ArrayList<String>();
        ArrayList<String> binary = new ArrayList<String>();
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> row = null;
        conn = this.getConnection();
        int endNum = limitFrom + pageSize;
        String sql2 = "SELECT * FROM (SELECT A.*, ROWNUM RN  FROM ( " + sql + " ) A  WHERE ROWNUM <= " + endNum + "  ) \tWHERE RN >= " + limitFrom;
        pstmt = conn.prepareStatement(sql2);
        rs = pstmt.executeQuery();
        rsmd = rs.getMetaData();
        maxSize = rsmd.getColumnCount();
        fields = new String[maxSize];
        for (int i = 0; i < maxSize; ++i) {
            fields[i] = rsmd.getColumnLabel(i + 1);
            if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1)) || "oracle.sql.TIMESTAMP".equals(rsmd.getColumnClassName(i + 1))) {
                times.add(fields[i]);
            }
            if ("oracle.jdbc.OracleClob".equals(rsmd.getColumnClassName(i + 1)) || "oracle.jdbc.OracleBlob".equals(rsmd.getColumnClassName(i + 1))) {
                clob.add(fields[i]);
            }
            if ("oracle.sql.BLOB".equals(rsmd.getColumnClassName(i + 1))) {
                blob.add(fields[i]);
            }
            if (!"[B".equals(rsmd.getColumnClassName(i + 1))) continue;
            binary.add(fields[i]);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (rs.next()) {
            row = new LinkedHashMap<String, Object>();
            for (int i = 0; i < maxSize; ++i) {
                Object value;
                if (fields[i].equals("RN")) continue;
                Object object = value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
                if (times.contains(fields[i]) && value != null) {
                    value = sdf.format(value);
                }
                try {
                    if (clob.contains(fields[i]) && value != null) {
                        value = DBUtil2.byteToHex((byte[])value);
                    }
                    if (blob.contains(fields[i]) && value != null) {
                        value = new String("");
                    }
                    if (binary.contains(fields[i]) && value != null) {
                        value = DBUtil2.byteToHex((byte[])value);
                    }
                }
                catch (Exception e) {
                    value = new String("");
                }
                row.put(fields[i], value);
            }
            rows.add(row);
        }
        try {
            rs.close();
            pstmt.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new Exception("\u53d6\u6570\u636e\u51fa\u9519\uff0c" + e.getMessage());
        }
        return rows;
    }

    public List<Map<String, Object>> queryForListForHive2(String sql, int limitFrom, int pageSize) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        int maxSize = -1;
        String[] fields = null;
        ArrayList<String> times = new ArrayList<String>();
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> row = null;
        conn = this.getConnection();
        pstmt = conn.prepareStatement(sql);
        int maxRow = limitFrom + pageSize;
        pstmt.setMaxRows(maxRow);
        rs = pstmt.executeQuery();
        rsmd = rs.getMetaData();
        maxSize = rsmd.getColumnCount();
        fields = new String[maxSize];
        for (int i = 0; i < maxSize; ++i) {
            fields[i] = rsmd.getColumnLabel(i + 1);
            if (!"java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) continue;
            times.add(fields[i]);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (rs.next()) {
            row = new LinkedHashMap<String, Object>();
            for (int i = 0; i < maxSize; ++i) {
                Object value;
                Object object = value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
                if (times.contains(fields[i]) && value != null) {
                    value = sdf.format(value);
                }
                row.put(fields[i], value);
            }
            rows.add(row);
        }
        try {
            rs.close();
            pstmt.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new Exception(e.getMessage());
        }
        return rows;
    }

    public List<Map<String, Object>> queryForListCommonMethod(String sql) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        LinkedHashMap<String, Object> resultMap = null;
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                resultMap = new LinkedHashMap<String, Object>();
                ResultSetMetaData metaData = rs.getMetaData();
                int columnCount = metaData.getColumnCount();
                for (int i = 0; i < columnCount; ++i) {
                    resultMap.put(metaData.getColumnLabel(i + 1), rs.getObject(i + 1));
                }
                resultList.add(resultMap);
            }
            rs.close();
            pstmt.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new Exception(e.getMessage());
        }
        return resultList;
    }

    public List<Map<String, Object>> queryForListForMySql(String sql) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        int maxSize = -1;
        String[] fields = null;
        ArrayList<String> times = new ArrayList<String>();
        ArrayList<String> binary = new ArrayList<String>();
        ArrayList<String> object = new ArrayList<String>();
        ArrayList<String> bigInt = new ArrayList<String>();
        ArrayList<String> longType = new ArrayList<String>();
        ArrayList<String> stringType = new ArrayList<String>();
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> row = null;
        conn = this.getConnection();
        pstmt = conn.prepareStatement(sql);
        rs = pstmt.executeQuery();
        rsmd = rs.getMetaData();
        maxSize = rsmd.getColumnCount();
        fields = new String[maxSize];
        for (int i = 0; i < maxSize; ++i) {
            fields[i] = rsmd.getColumnLabel(i + 1);
            if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) {
                times.add(fields[i]);
            }
            if ("java.lang.Object".equals(rsmd.getColumnClassName(i + 1))) {
                object.add(fields[i]);
            }
            if ("[B".equals(rsmd.getColumnClassName(i + 1))) {
                binary.add(fields[i]);
            }
            if ("java.lang.Long".equals(rsmd.getColumnClassName(i + 1))) {
                longType.add(fields[i]);
            }
            if ("java.math.BigInteger".equals(rsmd.getColumnClassName(i + 1))) {
                bigInt.add(fields[i]);
            }
            if (!"java.lang.String".equals(rsmd.getColumnClassName(i + 1))) continue;
            stringType.add(fields[i]);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (rs.next()) {
            row = new LinkedHashMap<String, Object>();
            for (int i = 0; i < maxSize; ++i) {
                Object value;
                Object object2 = value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
                if (times.contains(fields[i]) && value != null) {
                    value = sdf.format(value);
                }
                try {
                    if (binary.contains(fields[i]) && value != null) {
                        value = "(BLOB)";
                    }
                    if (object.contains(fields[i]) && value != null) {
                        value = value.toString();
                    }
                    if (longType.contains(fields[i]) && value != null) {
                        value = value.toString();
                    }
                    if (bigInt.contains(fields[i]) && value != null) {
                        value = value.toString();
                    }
                    if (stringType.contains(fields[i]) && value != null && (value = value.toString()).toString().length() > 501) {
                        value = value.toString().substring(0, 500) + "......";
                    }
                }
                catch (Exception e) {
                    value = "(Object)";
                }
                row.put(fields[i], value);
            }
            rows.add(row);
        }
        try {
            rs.close();
            pstmt.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new Exception("\u53d6\u6570\u636e\u51fa\u9519\uff0c" + e.getMessage());
        }
        return rows;
    }

    public List<Map<String, Object>> queryForListForMySqlForExport(String sql, int limitFrom, int pageSize) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        int maxSize = -1;
        String[] fields = null;
        ArrayList<String> times = new ArrayList<String>();
        ArrayList<String> binary = new ArrayList<String>();
        ArrayList<String> object = new ArrayList<String>();
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> row = null;
        conn = this.getConnection();
        sql = "select * from (" + sql + ") tab limit " + limitFrom + "," + pageSize;
        pstmt = conn.prepareStatement(sql);
        rs = pstmt.executeQuery();
        rsmd = rs.getMetaData();
        maxSize = rsmd.getColumnCount();
        fields = new String[maxSize];
        for (int i = 0; i < maxSize; ++i) {
            fields[i] = rsmd.getColumnLabel(i + 1);
            if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) {
                times.add(fields[i]);
            }
            if ("java.lang.Object".equals(rsmd.getColumnClassName(i + 1))) {
                object.add(fields[i]);
            }
            if (!"[B".equals(rsmd.getColumnClassName(i + 1))) continue;
            binary.add(fields[i]);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (rs.next()) {
            row = new LinkedHashMap<String, Object>();
            for (int i = 0; i < maxSize; ++i) {
                Object value;
                Object object2 = value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
                if (times.contains(fields[i]) && value != null) {
                    value = sdf.format(value);
                }
                try {
                    if (binary.contains(fields[i]) && value != null) {
                        value = DBUtil2.byteToHex((byte[])value);
                    }
                    if (object.contains(fields[i]) && value != null) {
                        value = value.toString();
                    }
                }
                catch (Exception e) {
                    value = "(Object)";
                }
                row.put(fields[i], value);
            }
            rows.add(row);
        }
        try {
            rs.close();
            pstmt.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new Exception("\u53d6\u6570\u636e\u51fa\u9519\uff0c" + e);
        }
        return rows;
    }

    public List<Map<String, Object>> queryForListForDb2(String sql, int limitFrom, int pageSize) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        int maxSize = -1;
        String[] fields = null;
        ArrayList<String> times = new ArrayList<String>();
        ArrayList<String> binary = new ArrayList<String>();
        ArrayList<String> object = new ArrayList<String>();
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> row = null;
        conn = this.getConnection();
        sql = " SELECT * FROM ( SELECT B.*, ROWNUMBER() OVER() AS ROWNUMBER FROM (" + sql + ") AS B ) AS A WHERE A.ROWNUMBER BETWEEN " + (limitFrom + 1) + " AND " + (limitFrom + pageSize);
        pstmt = conn.prepareStatement(sql);
        rs = pstmt.executeQuery();
        rsmd = rs.getMetaData();
        maxSize = rsmd.getColumnCount();
        fields = new String[maxSize];
        for (int i = 0; i < maxSize; ++i) {
            fields[i] = rsmd.getColumnLabel(i + 1);
            if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) {
                times.add(fields[i]);
            }
            if ("java.lang.Object".equals(rsmd.getColumnClassName(i + 1))) {
                object.add(fields[i]);
            }
            if (!"[B".equals(rsmd.getColumnClassName(i + 1))) continue;
            binary.add(fields[i]);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (rs.next()) {
            row = new LinkedHashMap<String, Object>();
            for (int i = 0; i < maxSize; ++i) {
                Object value;
                if (fields[i].equals("ROWNUMBER")) continue;
                Object object2 = value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
                if (times.contains(fields[i]) && value != null) {
                    value = sdf.format(value);
                }
                try {
                    if (binary.contains(fields[i]) && value != null) {
                        value = "(BLOB)";
                    }
                    if (object.contains(fields[i]) && value != null) {
                        value = value.toString();
                    }
                }
                catch (Exception e) {
                    value = "(Object)";
                }
                row.put(fields[i], value);
            }
            rows.add(row);
        }
        try {
            rs.close();
            pstmt.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new Exception("\u53d6\u6570\u636e\u51fa\u9519\uff0c" + e.getMessage());
        }
        return rows;
    }

    public List<Map<String, Object>> queryForListForDm7(String sql, int limitFrom, int pageSize) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        int maxSize = -1;
        String[] fields = null;
        ArrayList<String> times = new ArrayList<String>();
        ArrayList<String> binary = new ArrayList<String>();
        ArrayList<String> object = new ArrayList<String>();
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> row = null;
        conn = this.getConnection();
        sql = " select * from ( " + sql + " ) tab  LIMIT " + limitFrom + "," + pageSize;
        pstmt = conn.prepareStatement(sql);
        rs = pstmt.executeQuery();
        rsmd = rs.getMetaData();
        maxSize = rsmd.getColumnCount();
        fields = new String[maxSize];
        for (int i = 0; i < maxSize; ++i) {
            fields[i] = rsmd.getColumnLabel(i + 1);
            if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) {
                times.add(fields[i]);
            }
            if ("java.lang.Object".equals(rsmd.getColumnClassName(i + 1))) {
                object.add(fields[i]);
            }
            if (!"[B".equals(rsmd.getColumnClassName(i + 1))) continue;
            binary.add(fields[i]);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (rs.next()) {
            row = new LinkedHashMap<String, Object>();
            for (int i = 0; i < maxSize; ++i) {
                Object value;
                Object object2 = value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
                if (times.contains(fields[i]) && value != null) {
                    value = sdf.format(value);
                }
                try {
                    if (binary.contains(fields[i]) && value != null) {
                        value = DBUtil2.byteToHex((byte[])value);
                    }
                    if (object.contains(fields[i]) && value != null) {
                        value = value.toString();
                    }
                }
                catch (Exception e) {
                    value = "(Object)";
                }
                row.put(fields[i], value);
            }
            rows.add(row);
        }
        try {
            rs.close();
            pstmt.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new Exception("\u53d6\u6570\u636e\u51fa\u9519\uff0c" + e);
        }
        return rows;
    }

    public List<Map<String, Object>> queryForListForShenTong(String sql, int limitFrom, int pageSize) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        int maxSize = -1;
        String[] fields = null;
        ArrayList<String> times = new ArrayList<String>();
        ArrayList<String> binary = new ArrayList<String>();
        ArrayList<String> object = new ArrayList<String>();
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> row = null;
        conn = this.getConnection();
        sql = " select * from ( " + sql + " ) tab  LIMIT " + limitFrom + "," + pageSize;
        pstmt = conn.prepareStatement(sql);
        rs = pstmt.executeQuery();
        rsmd = rs.getMetaData();
        maxSize = rsmd.getColumnCount();
        fields = new String[maxSize];
        for (int i = 0; i < maxSize; ++i) {
            fields[i] = rsmd.getColumnLabel(i + 1);
            if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) {
                times.add(fields[i]);
            }
            if ("java.lang.Object".equals(rsmd.getColumnClassName(i + 1))) {
                object.add(fields[i]);
            }
            if (!"[B".equals(rsmd.getColumnClassName(i + 1))) continue;
            binary.add(fields[i]);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (rs.next()) {
            row = new LinkedHashMap<String, Object>();
            for (int i = 0; i < maxSize; ++i) {
                Object value;
                Object object2 = value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
                if (times.contains(fields[i]) && value != null) {
                    value = sdf.format(value);
                }
                try {
                    if (binary.contains(fields[i]) && value != null) {
                        value = DBUtil2.byteToHex((byte[])value);
                    }
                    if (object.contains(fields[i]) && value != null) {
                        value = value.toString();
                    }
                }
                catch (Exception e) {
                    value = "(Object)";
                }
                row.put(fields[i], value);
            }
            rows.add(row);
        }
        try {
            rs.close();
            pstmt.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new Exception("\u53d6\u6570\u636e\u51fa\u9519\uff0c" + e);
        }
        return rows;
    }

    public List<Map<String, Object>> queryForListForKingbase(String sql, int limitFrom, int pageSize) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        int maxSize = -1;
        String[] fields = null;
        ArrayList<String> times = new ArrayList<String>();
        ArrayList<String> binary = new ArrayList<String>();
        ArrayList<String> object = new ArrayList<String>();
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> row = null;
        conn = this.getConnection();
        sql = " select * from ( " + sql + " ) tab  LIMIT " + limitFrom + "," + pageSize;
        pstmt = conn.prepareStatement(sql);
        rs = pstmt.executeQuery();
        rsmd = rs.getMetaData();
        maxSize = rsmd.getColumnCount();
        fields = new String[maxSize];
        for (int i = 0; i < maxSize; ++i) {
            fields[i] = rsmd.getColumnLabel(i + 1);
            if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) {
                times.add(fields[i]);
            }
            if ("java.lang.Object".equals(rsmd.getColumnClassName(i + 1))) {
                object.add(fields[i]);
            }
            if (!"[B".equals(rsmd.getColumnClassName(i + 1))) continue;
            binary.add(fields[i]);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (rs.next()) {
            row = new LinkedHashMap<String, Object>();
            for (int i = 0; i < maxSize; ++i) {
                Object value;
                Object object2 = value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
                if (times.contains(fields[i]) && value != null) {
                    value = sdf.format(value);
                }
                try {
                    if (binary.contains(fields[i]) && value != null) {
                        value = DBUtil2.byteToHex((byte[])value);
                    }
                    if (object.contains(fields[i]) && value != null) {
                        value = value.toString();
                    }
                }
                catch (Exception e) {
                    value = "(Object)";
                }
                row.put(fields[i], value);
            }
            rows.add(row);
        }
        try {
            rs.close();
            pstmt.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new Exception("\u53d6\u6570\u636e\u51fa\u9519\uff0c" + e);
        }
        return rows;
    }

    public List<Map<String, Object>> queryForListForPostgreSQL(String sql) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        int maxSize = -1;
        String[] fields = null;
        ArrayList<String> times = new ArrayList<String>();
        ArrayList<String> binary = new ArrayList<String>();
        ArrayList<String> object = new ArrayList<String>();
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> row = null;
        conn = this.getConnection();
        pstmt = conn.prepareStatement(sql);
        rs = pstmt.executeQuery();
        rsmd = rs.getMetaData();
        maxSize = rsmd.getColumnCount();
        fields = new String[maxSize];
        for (int i = 0; i < maxSize; ++i) {
            fields[i] = rsmd.getColumnLabel(i + 1);
            if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1)) || "oracle.sql.TIMESTAMP".equals(rsmd.getColumnClassName(i + 1))) {
                times.add(fields[i]);
            }
            if ("java.lang.Object".equals(rsmd.getColumnClassName(i + 1))) {
                object.add(fields[i]);
            }
            if (!"[B".equals(rsmd.getColumnClassName(i + 1))) continue;
            binary.add(fields[i]);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (rs.next()) {
            row = new LinkedHashMap<String, Object>();
            for (int i = 0; i < maxSize; ++i) {
                Object value;
                Object object2 = value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
                if (times.contains(fields[i]) && value != null) {
                    value = sdf.format(value);
                }
                try {
                    if (binary.contains(fields[i]) && value != null) {
                        value = new String((byte[])value);
                    }
                    if (object.contains(fields[i]) && value != null) {
                        value = value.toString();
                    }
                }
                catch (Exception e) {
                    value = "(Object)";
                }
                row.put(fields[i], value);
            }
            rows.add(row);
        }
        try {
            rs.close();
            pstmt.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new Exception("\u53d6\u6570\u636e\u51fa\u9519\uff0c" + e.getMessage());
        }
        return rows;
    }

    public List<Map<String, Object>> queryForListForPostgreSQLForExport(String sql, int limitFrom, int pageSize) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        int maxSize = -1;
        String[] fields = null;
        ArrayList<String> times = new ArrayList<String>();
        ArrayList<String> binary = new ArrayList<String>();
        ArrayList<String> object = new ArrayList<String>();
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> row = null;
        conn = this.getConnection();
        String sql2 = "select  *  from  (" + sql + ") t  limit " + pageSize + " offset  " + limitFrom;
        pstmt = conn.prepareStatement(sql2);
        rs = pstmt.executeQuery();
        rsmd = rs.getMetaData();
        maxSize = rsmd.getColumnCount();
        fields = new String[maxSize];
        for (int i = 0; i < maxSize; ++i) {
            fields[i] = rsmd.getColumnLabel(i + 1);
            if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1)) || "oracle.sql.TIMESTAMP".equals(rsmd.getColumnClassName(i + 1))) {
                times.add(fields[i]);
            }
            if ("java.lang.Object".equals(rsmd.getColumnClassName(i + 1))) {
                object.add(fields[i]);
            }
            if (!"[B".equals(rsmd.getColumnClassName(i + 1))) continue;
            binary.add(fields[i]);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (rs.next()) {
            row = new LinkedHashMap<String, Object>();
            for (int i = 0; i < maxSize; ++i) {
                Object value;
                Object object2 = value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
                if (times.contains(fields[i]) && value != null) {
                    value = sdf.format(value);
                }
                try {
                    if (binary.contains(fields[i]) && value != null) {
                        value = new String((byte[])value);
                    }
                    if (object.contains(fields[i]) && value != null) {
                        value = value.toString();
                    }
                }
                catch (Exception e) {
                    value = "(Object)";
                }
                row.put(fields[i], value);
            }
            rows.add(row);
        }
        try {
            rs.close();
            pstmt.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new Exception("\u53d6\u6570\u636e\u51fa\u9519\uff0c" + e.getMessage());
        }
        return rows;
    }

    public List<Map<String, Object>> queryForListForHana2(String sql, int limitFrom, int pageSize) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        LinkedHashMap<String, Object> resultMap = null;
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        try {
            conn = this.getConnection();
            String sql2 = sql + "  LIMIT " + pageSize + " OFFSET  " + limitFrom;
            pstmt = conn.prepareStatement(sql2);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                resultMap = new LinkedHashMap<String, Object>();
                ResultSetMetaData metaData = rs.getMetaData();
                int columnCount = metaData.getColumnCount();
                for (int i = 0; i < columnCount; ++i) {
                    resultMap.put(metaData.getColumnLabel(i + 1), rs.getObject(i + 1));
                }
                resultList.add(resultMap);
            }
            rs.close();
            pstmt.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new Exception("\u53d6\u6570\u636e\u51fa\u9519\uff0c" + e.getMessage());
        }
        return resultList;
    }

    public List<Map<String, Object>> queryForListForCache(String sql, int limitFrom, int pageSize) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        int maxSize = -1;
        String[] fields = null;
        ArrayList<String> times = new ArrayList<String>();
        ArrayList<String> binary = new ArrayList<String>();
        ArrayList<String> object = new ArrayList<String>();
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> row = null;
        conn = this.getConnection();
        String sql2 = "select top " + pageSize + " * from (" + sql + ") tab ";
        pstmt = conn.prepareStatement(sql2);
        rs = pstmt.executeQuery();
        rsmd = rs.getMetaData();
        maxSize = rsmd.getColumnCount();
        fields = new String[maxSize];
        for (int i = 0; i < maxSize; ++i) {
            fields[i] = rsmd.getColumnLabel(i + 1);
            if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) {
                times.add(fields[i]);
            }
            if ("java.lang.Object".equals(rsmd.getColumnClassName(i + 1))) {
                object.add(fields[i]);
            }
            if (!"[B".equals(rsmd.getColumnClassName(i + 1))) continue;
            binary.add(fields[i]);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (rs.next()) {
            row = new LinkedHashMap<String, Object>();
            for (int i = 0; i < maxSize; ++i) {
                Object value;
                Object object2 = value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
                if (times.contains(fields[i]) && value != null) {
                    value = sdf.format(value);
                }
                try {
                    if (binary.contains(fields[i]) && value != null) {
                        value = new String((byte[])value);
                    }
                    if (object.contains(fields[i]) && value != null) {
                        value = value.toString();
                    }
                }
                catch (Exception e) {
                    value = "(Object)";
                }
                row.put(fields[i], value);
            }
            rows.add(row);
        }
        try {
            rs.close();
            pstmt.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new Exception("\u53d6\u6570\u636e\u51fa\u9519\uff0c" + e.getMessage());
        }
        return rows;
    }

    public List<Map<String, Object>> queryForListForMSSQL(String sql, int limitFrom, int pageSize) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        int maxSize = -1;
        String[] fields = null;
        ArrayList<String> times = new ArrayList<String>();
        ArrayList<String> binary = new ArrayList<String>();
        ArrayList<String> object = new ArrayList<String>();
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> row = null;
        conn = this.getConnection();
        pstmt = conn.prepareStatement(sql, 1005, 1008);
        pstmt.setMaxRows(limitFrom + pageSize);
        rs = pstmt.executeQuery();
        rsmd = rs.getMetaData();
        maxSize = rsmd.getColumnCount();
        fields = new String[maxSize];
        for (int i = 0; i < maxSize; ++i) {
            fields[i] = rsmd.getColumnLabel(i + 1);
            if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) {
                times.add(fields[i]);
            }
            if ("java.lang.Object".equals(rsmd.getColumnClassName(i + 1))) {
                object.add(fields[i]);
            }
            if (!"[B".equals(rsmd.getColumnClassName(i + 1))) continue;
            binary.add(fields[i]);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        rs.absolute(limitFrom);
        while (rs.next()) {
            row = new LinkedHashMap<String, Object>();
            for (int i = 0; i < maxSize; ++i) {
                Object value;
                Object object2 = value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
                if (times.contains(fields[i]) && value != null) {
                    value = sdf.format(value);
                }
                try {
                    if (binary.contains(fields[i]) && value != null) {
                        value = "0x" + this.bytesToHexString((byte[])value);
                    }
                    if (object.contains(fields[i]) && value != null) {
                        value = value.toString();
                    }
                }
                catch (Exception e) {
                    value = "(Object)";
                }
                row.put(fields[i], value);
            }
            rows.add(row);
        }
        try {
            rs.close();
            pstmt.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new Exception("\u53d6\u6570\u636e\u51fa\u9519\uff0c" + e.getMessage());
        }
        return rows;
    }

    public List<Map<String, Object>> queryForListPageForMSSQL(String sql, int maxRow, int beginIndex) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        int maxSize = -1;
        String[] fields = null;
        ArrayList<String> times = new ArrayList<String>();
        ArrayList<String> binary = new ArrayList<String>();
        ArrayList<String> object = new ArrayList<String>();
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> row = null;
        conn = this.getConnection();
        pstmt = conn.prepareStatement(sql, 1005, 1008);
        pstmt.setMaxRows(maxRow);
        rs = pstmt.executeQuery();
        rsmd = rs.getMetaData();
        maxSize = rsmd.getColumnCount();
        fields = new String[maxSize];
        for (int i = 0; i < maxSize; ++i) {
            fields[i] = rsmd.getColumnLabel(i + 1);
            if ("java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) {
                times.add(fields[i]);
            }
            if ("java.lang.Object".equals(rsmd.getColumnClassName(i + 1))) {
                object.add(fields[i]);
            }
            if (!"[B".equals(rsmd.getColumnClassName(i + 1))) continue;
            binary.add(fields[i]);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        rs.absolute(beginIndex);
        while (rs.next()) {
            row = new HashMap<String, Object>();
            for (int i = 0; i < maxSize; ++i) {
                Object value;
                Object object2 = value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
                if (times.contains(fields[i]) && value != null) {
                    value = sdf.format(value);
                }
                try {
                    if (binary.contains(fields[i]) && value != null) {
                        value = "(Object)";
                    }
                    if (object.contains(fields[i]) && value != null) {
                        value = "(Object)";
                    }
                }
                catch (Exception e) {
                    value = "(Object)";
                }
                row.put(fields[i], value);
            }
            rows.add(row);
        }
        try {
            rs.close();
            pstmt.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new Exception(e.getMessage());
        }
        return rows;
    }

    public List<Map<String, Object>> executeSqlProcedureForMSSQL(String sql, int maxRow, int beginIndex) throws Exception {
        Connection conn = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        int maxSize = -1;
        String[] fields = null;
        ArrayList<String> times = new ArrayList<String>();
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> row = null;
        conn = this.getConnection();
        CallableStatement callS = conn.prepareCall(sql, 1005, 1008);
        try {
            callS.setMaxRows(maxRow);
            rs = callS.executeQuery();
            rsmd = rs.getMetaData();
            maxSize = rsmd.getColumnCount();
            fields = new String[maxSize];
            for (int i = 0; i < maxSize; ++i) {
                fields[i] = rsmd.getColumnLabel(i + 1);
                if (!"java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) continue;
                times.add(fields[i]);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            rs.absolute(beginIndex);
            while (rs.next()) {
                row = new HashMap<String, Object>();
                for (int i = 0; i < maxSize; ++i) {
                    Object value;
                    Object object = value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
                    if (times.contains(fields[i]) && value != null) {
                        value = sdf.format(value);
                    }
                    row.put(fields[i], value);
                }
                rows.add(row);
            }
            rs.close();
        }
        catch (Exception e) {
            throw new Exception("\u5b58\u50a8\u8fc7\u7a0b\u6267\u884c\u51fa\u9519\uff0c" + e.getMessage());
        }
        try {
            callS.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new Exception(e.getMessage());
        }
        return rows;
    }

    public List<Map<String, Object>> executeSqlProcedureForColumnsForMSSQL(String sql) throws Exception {
        Connection conn = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        int maxSize = -1;
        String[] fields = null;
        ArrayList<Map<String, Object>> columnRows = new ArrayList<Map<String, Object>>();
        conn = this.getConnection();
        CallableStatement callS = conn.prepareCall(sql, 1005, 1008);
        callS.setMaxRows(1);
        rs = callS.executeQuery();
        rsmd = rs.getMetaData();
        maxSize = rsmd.getColumnCount();
        fields = new String[maxSize];
        for (int i = 0; i < maxSize; ++i) {
            fields[i] = rsmd.getColumnLabel(i + 1);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("column_name", fields[i]);
            columnRows.add(map);
        }
        try {
            rs.close();
            callS.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new Exception(e.getMessage());
        }
        return columnRows;
    }

    public int executeQueryForCountProcedureForMSSQL(String sql) throws Exception {
        Connection conn = null;
        ResultSet rs = null;
        conn = this.getConnection();
        CallableStatement callS = conn.prepareCall(sql);
        rs = callS.executeQuery();
        int countNum = 0;
        while (rs.next()) {
            ++countNum;
        }
        try {
            rs.close();
            callS.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new Exception(e.getMessage());
        }
        return countNum;
    }

    public List<Map<String, Object>> queryForListPageForHive2(String sql, int maxRow, int beginIndex) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        int maxSize = -1;
        String[] fields = null;
        ArrayList<String> times = new ArrayList<String>();
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> row = null;
        conn = this.getConnection();
        pstmt = conn.prepareStatement(sql);
        pstmt.setMaxRows(maxRow);
        rs = pstmt.executeQuery();
        rsmd = rs.getMetaData();
        maxSize = rsmd.getColumnCount();
        fields = new String[maxSize];
        for (int i = 0; i < maxSize; ++i) {
            fields[i] = rsmd.getColumnLabel(i + 1);
            if (!"java.sql.Timestamp".equals(rsmd.getColumnClassName(i + 1))) continue;
            times.add(fields[i]);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (rs.next()) {
            row = new LinkedHashMap<String, Object>();
            for (int i = 0; i < maxSize; ++i) {
                Object value;
                Object object = value = times.contains(fields[i]) ? rs.getTimestamp(fields[i]) : rs.getObject(fields[i]);
                if (times.contains(fields[i]) && value != null) {
                    value = sdf.format(value);
                }
                row.put(fields[i], value);
            }
            rows.add(row);
        }
        try {
            rs.close();
            pstmt.close();
            conn.close();
        }
        catch (SQLException e) {
            throw new Exception(e.getMessage());
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> queryForListWithType(String sql) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<Map<String, Object>> rows2 = new ArrayList<Map<String, Object>>();
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            ResultSetMetaData rsme = rs.getMetaData();
            int columnCount = rsme.getColumnCount();
            rs.next();
            for (int i = 1; i < columnCount + 1; ++i) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("column_name", rsme.getColumnName(i));
                map.put("column_value", rs.getObject(rsme.getColumnName(i)));
                map.put("data_type", rsme.getColumnTypeName(i));
                map.put("precision", rsme.getPrecision(i));
                map.put("isAutoIncrement", rsme.isAutoIncrement(i));
                map.put("is_nullable", rsme.isNullable(i));
                map.put("isReadOnly", rsme.isReadOnly(i));
                rows2.add(map);
            }
        }
        catch (Exception e) {
            System.out.println("queryForListWithType  " + e.getMessage());
            try {
                rs.close();
                pstmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
                pstmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        return rows2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> queryForColumnOnly(String sql) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<Map<String, Object>> rows2 = new ArrayList<Map<String, Object>>();
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            ResultSetMetaData rsme = rs.getMetaData();
            int columnCount = rsme.getColumnCount();
            for (int i = 1; i < columnCount + 1; ++i) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("column_name", rsme.getColumnName(i));
                map.put("data_type", rsme.getColumnTypeName(i));
                map.put("precision", rsme.getPrecision(i));
                map.put("isAutoIncrement", rsme.isAutoIncrement(i));
                map.put("is_nullable", rsme.isNullable(i));
                map.put("isReadOnly", rsme.isReadOnly(i));
                rows2.add(map);
            }
        }
        catch (Exception e) {
            try {
                rs.close();
                pstmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
                pstmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        return rows2;
    }

    public List<Map<String, Object>> executeSqlForColumns(String sql) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        int maxSize = -1;
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        conn = this.getConnection();
        pstmt = conn.prepareStatement(sql);
        rs = pstmt.executeQuery();
        rsmd = rs.getMetaData();
        maxSize = rsmd.getColumnCount();
        for (int i = 0; i < maxSize; ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("column_name", rsmd.getColumnLabel(i + 1));
            map.put("data_type", rsmd.getColumnTypeName(i + 1));
            rows.add(map);
        }
        rs.close();
        pstmt.close();
        conn.close();
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeQueryForCount(String sql) throws Exception {
        int rowCount = 0;
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                Object count = rs.getObject("count(*)");
                rowCount = Integer.parseInt(count.toString());
            }
        }
        catch (Exception e) {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeQueryForCountForPostgesSQL(String sql) throws Exception {
        int rowCount = 0;
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                Object count = rs.getObject("count");
                rowCount = Integer.parseInt(count.toString());
            }
        }
        catch (Exception e) {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        return rowCount;
    }

    public int executeQueryForCountForMySQL(String sql) throws Exception {
        int rowCount = 0;
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            sql = "select count(*) as TOTALS from (" + sql + ") tab ";
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            rs.next();
            rowCount = rs.getInt("TOTALS");
        }
        catch (Exception e) {
            throw new Exception("\u53d6\u5f97\u8868\u884c\u6570\u51fa\u9519\uff0c" + e.getMessage());
        }
        finally {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (SQLException e) {
                throw new Exception("\u53d6\u5f97\u8868\u884c\u6570\u51fa\u9519\uff0c" + e.getMessage());
            }
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeQuery(String sql) throws Exception {
        boolean bl = false;
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                bl = true;
            }
        }
        catch (Exception e) {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeQueryForQuartzJob(String sql) throws Exception {
        boolean bl = false;
        Connection conn = this.getConnectionForQuartzJob();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                bl = true;
            }
        }
        catch (Exception e) {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        return bl;
    }

    public boolean testConn() {
        boolean bl = false;
        try {
            Connection conn = this.getConnection();
            if (conn != null) {
                bl = true;
            }
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPrimaryKeys(String databaseName, String tableName) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            DatabaseMetaData metadata = conn.getMetaData();
            ResultSet rs2 = metadata.getPrimaryKeys(databaseName, null, tableName);
            if (rs2.next()) {
                System.out.println("\u4e3b\u952e\u540d\u79f0: " + rs2.getString(4));
                String string = rs2.getString(4);
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPrimaryKeyss(String databaseName, String tableName) {
        Connection conn = null;
        ArrayList<String> rows2 = new ArrayList<String>();
        try {
            conn = this.getConnection();
            DatabaseMetaData metadata = conn.getMetaData();
            ResultSet rs2 = metadata.getPrimaryKeys(databaseName, null, tableName);
            while (rs2.next()) {
                rows2.add(rs2.getString(4));
            }
        }
        catch (Exception e) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        return rows2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeQueryForCountForOracle(String sql) throws Exception {
        int rowCount = 0;
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String sql3 = " select count(*) as count from  (" + sql + ")";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql3);
            rs.next();
            rowCount = rs.getInt("count");
        }
        catch (Exception e) {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeQueryForCountForPostgreSQL(String sql) throws Exception {
        int rowCount = 0;
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String sql3 = " select count(*) as totals from  (" + sql + ") t ";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql3);
            rs.next();
            rowCount = rs.getInt("totals");
        }
        catch (Exception e) {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeQueryForCountForMSSqlWith(String sql) throws Exception {
        int rowCount = 0;
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                ++rowCount;
            }
        }
        catch (Exception e) {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeQueryForCountForHana2(String sql) throws Exception {
        int rowCount = 0;
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String sql3 = " select count(*) as COUNT from  (" + sql + ") t ";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql3);
            rs.next();
            rowCount = rs.getInt("COUNT");
        }
        catch (Exception e) {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeQueryForCountForCache(String sql) throws Exception {
        int rowCount = 0;
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String sql3 = " select count(*) as TOTALS from  (" + sql + ") t ";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql3);
            rs.next();
            rowCount = rs.getInt("TOTALS");
        }
        catch (Exception e) {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        return rowCount;
    }

    public static String byteToHex(byte[] bytes) {
        String strHex = "";
        StringBuilder sb = new StringBuilder("");
        for (int n = 0; n < bytes.length; ++n) {
            strHex = Integer.toHexString(bytes[n] & 0xFF);
            sb.append(strHex.length() == 1 ? "0" + strHex : strHex);
        }
        return "0x" + sb.toString().toUpperCase().trim();
    }

    public String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }
}

