/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.profinance.utils;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.ejianc.business.profinance.utils.FinanceConstants;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DynamicDataSourceDruidUtil {
    private static final Logger logger = LoggerFactory.getLogger(DynamicDataSourceDruidUtil.class);
    public static Map<String, DruidDataSource> customDataSources = new ConcurrentHashMap<String, DruidDataSource>();

    public void insertOrUpdateCustomDbDataSources(Map<String, Object> map) throws Exception {
        String id = map.get("id").toString();
        String poolName = map.get("id") + FinanceConstants.POOL_NAME_SPLIT + map.get("databaseName");
        logger.info("update dataSources , poolName=" + poolName);
        Properties properties = new Properties();
        properties.setProperty("url", map.get("jdbc_url").toString());
        properties.setProperty("driver", map.get("driver_class_name").toString());
        properties.setProperty("username", map.get("username").toString());
        properties.setProperty("password", map.get("password").toString());
        properties.setProperty("initialSize", FinanceConstants.MINIMUM_IDLE.toString());
        properties.setProperty("minIdle", FinanceConstants.MINIMUM_IDLE.toString());
        properties.setProperty("maxActive", FinanceConstants.MAXIMUM_POOL_SIZE.toString());
        properties.setProperty("removeAbandoned", "true");
        properties.setProperty("removeAbandonedTimeout", "180");
        properties.setProperty("maxWait", "3000");
        DruidDataSource druidDataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)properties);
        druidDataSource.setTimeBetweenConnectErrorMillis(1800000L);
        for (Map.Entry<String, DruidDataSource> entry : customDataSources.entrySet()) {
            if (entry.getKey().indexOf(id) < 0) continue;
            DruidDataSource dataSourceOld = entry.getValue();
            dataSourceOld.close();
            dataSourceOld = null;
            customDataSources.remove(entry.getKey());
        }
        customDataSources.put(poolName, druidDataSource);
    }

    public void deleteCustomDbDataSources(String poolName) {
        logger.info("drop dataSources ,poolName=" + poolName);
        DruidDataSource dataSource = customDataSources.get(poolName);
        if (dataSource != null) {
            dataSource.close();
            dataSource = null;
        }
        customDataSources.remove(poolName);
    }

    public static DataSource getDataSource(Map<String, Object> configMess) {
        String jdbc_url = "";
        try {
            String key = configMess.get("key") + "";
            DruidDataSource dataSource = customDataSources.get(key);
            if (dataSource == null) {
                jdbc_url = DynamicDataSourceDruidUtil.concatJdbcUrl(configMess);
                Properties properties = new Properties();
                properties.setProperty("url", jdbc_url);
                properties.setProperty("driver", configMess.get("driver").toString());
                properties.setProperty("username", configMess.get("userName").toString());
                properties.setProperty("password", configMess.get("password").toString());
                properties.setProperty("initialSize", FinanceConstants.MINIMUM_IDLE.toString());
                properties.setProperty("minIdle", FinanceConstants.MINIMUM_IDLE.toString());
                properties.setProperty("maxActive", FinanceConstants.MAXIMUM_POOL_SIZE.toString());
                properties.setProperty("removeAbandoned", "true");
                properties.setProperty("removeAbandonedTimeout", "180");
                properties.setProperty("maxWait", "5000");
                properties.setProperty("logAbandoned", "true");
                DruidDataSource druidDataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)properties);
                druidDataSource.setTimeBetweenConnectErrorMillis(1800000L);
                customDataSources.put(key, druidDataSource);
                return druidDataSource;
            }
            return dataSource;
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u6e90\u8fde\u63a5\u51fa\u9519\uff0c" + jdbc_url, (Throwable)e);
            return null;
        }
    }

    public static String concatJdbcUrl(Map<String, Object> map0) {
        String databaseType = (String)map0.get("databaseType");
        String ip = (String)map0.get("ip");
        String port = (String)map0.get("port");
        String dbName = (String)map0.get("dbName");
        String url = "";
        if (databaseType.equals("MySql")) {
            url = "jdbc:mysql://" + ip + ":" + port + "/" + dbName + "?characterEncoding=utf8&tinyInt1isBit=false&useSSL=false&serverTimezone=GMT%2B8";
        }
        if (databaseType.equals("MariaDB")) {
            url = "jdbc:mysql://" + ip + ":" + port + "/" + dbName + "?characterEncoding=utf8&tinyInt1isBit=false&useSSL=false";
        }
        if (databaseType.equals("MySql8.0")) {
            url = "jdbc:mysql://" + ip + ":" + port + "/" + dbName + "?useUnicode=true&characterEncoding=utf-8&tinyInt1isBit=false&useSSL=false&serverTimezone=GMT%2B8";
        }
        if (databaseType.equals("Oracle")) {
            url = "jdbc:oracle:thin:@//" + ip + ":" + port + "/" + dbName;
        }
        if (databaseType.equals("HANA2")) {
            url = "jdbc:sap://" + ip + ":" + port + "?reconnect=true";
        }
        if (databaseType.equals("PostgreSQL")) {
            url = "jdbc:postgresql://" + ip + ":" + port + "/" + dbName;
        }
        if (databaseType.equals("MSSQL")) {
            url = "jdbc:sqlserver://" + ip + ":" + port + ";database=" + dbName;
        }
        if (databaseType.equals("Hive2")) {
            url = "jdbc:hive2://" + ip + ":" + port + "/" + dbName;
        }
        if (databaseType.equals("Cache")) {
            url = "jdbc:Cache://" + ip + ":" + port + "/" + dbName;
        }
        if (databaseType.equals("DB2")) {
            url = "jdbc:db2://" + ip + ":" + port + "/" + dbName;
        }
        if (databaseType.equals("DM7")) {
            url = "jdbc:dm://" + ip + ":" + port + "/" + dbName;
        }
        if (databaseType.equals("ShenTong")) {
            String databaseName = (String)map0.get("databaseName");
            url = "jdbc:oscar://" + ip + ":" + port + "/" + databaseName;
        }
        if (databaseType.equals("Sybase")) {
            url = "jdbc:sybase:Tds:" + ip + ":" + port + "/" + dbName;
        }
        if (databaseType.equals("Kingbase")) {
            url = "jdbc:kingbase://" + ip + ":" + port + "/" + dbName;
        }
        if (databaseType.equals("Informix")) {
            String informixDbName = "";
            String informixserver = "";
            String[] str = dbName.split("@");
            informixDbName = str[0];
            informixserver = str[1];
            url = "jdbc:informix-sqli://" + ip + ":" + port + "/" + informixDbName + ":informixserver=" + informixserver + ";NEWCODESET=utf8,8859-1,819;CLIENT_LOCALE=en_US.utf8;DB_LOCALE=en_US.8859-1;IFX_USE_STRENC=true;";
        }
        if (databaseType.equals("ClickHouse")) {
            url = "jdbc:clickhouse://" + ip + ":" + port + "/" + dbName;
        }
        if (databaseType.equals("Redshift")) {
            url = "jdbc:redshift://" + ip + ":" + port + "/" + dbName;
        }
        return url;
    }
}

