package com.ejianc.business.profinance.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.profinance.utils.DBUtil2;
import com.ejianc.business.profinance.utils.DynamicDataSourceDruidUtil;
import com.ejianc.business.profinance.utils.ResultAsTreeNew;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.sql.DataSource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ncc数据参照
 *
 * @author CJ
 * @Description:
 * @date 2023/9/22 15:30
 */
@RestController
@RequestMapping(value = "/nccData/")
public class NccDataController {

    @Value("${nccdatabase.ip:#{NULL}}")
    private  String IP;
    @Value("${nccdatabase.port:#{NULL}}")
    private  String PORT;
    @Value("${nccdatabase.dbname:#{NULL}}")
    private  String DBNAME;
    @Value("${nccdatabase.username:#{NULL}}")
    private  String USERNAME;
    @Value("${nccdatabase.driver:#{NULL}}")
    private  String DRIVER;
    @Value("${nccdatabase.databasetype:#{NULL}}")
    private  String DATABASETYPE;
    @Value("${nccdatabase.password:#{NULL}}")
    private  String PASSWORD;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IShareSupplierApi shareSupplierApi;

    /**
     * ncc银行分类树参照
     *
     * @return
     */
    @GetMapping(value = "getNCCPayBankTypeList")
    public List<Map<String, Object>> getNCCPayBankTypeList() {
        StringBuilder sql = new StringBuilder("SELECT DISTINCT PK_BANKTYPE AS \"id\", PK_BANKTYPE AS \"key\", BANKTYPECODE AS \"code\", BANKTYPENAME AS \"name\" ");
        sql.append(" FROM NCC2105.V_ERJIAN_PAYACCOUNT ORDER BY TO_NUMBER(\"code\")");

        return queryBySql(sql.toString());
    }


    /**
     * Ncc付款银行份分页列表
     *
     * @param pageNumber
     * @param pageSize
     * @param relyCondition
     * @param searchText
     * @return
     */
    @GetMapping(value = "getNCCPayBankList")
    public CommonResponse<JSONObject> getNCCPayBankList(@RequestParam Integer pageNumber,
                                                               @RequestParam Integer pageSize,
                                                               @RequestParam(required = false) String condition,
                                                               @RequestParam(required = false) String relyCondition,
                                                               @RequestParam(required = false)  String searchText) {
        JSONObject resp = new JSONObject();
        int startLine = (pageNumber - 1) < 0 ? 0 : pageNumber - 1;

        StringBuilder querySql = new StringBuilder("SELECT * FROM ( SELECT t.*, ROW_NUMBER() OVER ( ORDER BY LENGTH( \"code\" ), \"code\" ) AS \"id\" ");
        querySql.append(" FROM (")
                .append("   SELECT")
                .append("       PK_BANKACCSUB AS \"nccPK\",")
                .append("       BANKACCSUBCODE AS \"code\",")
                .append("       BANKACCSUBNAME AS \"name\",")
                .append("       PK_BANKDOC AS \"bankPK\",")
                .append("       BANKCODE AS \"bankCode\",")
                .append("       BANKNAME AS \"bankName\"")
                .append("   FROM NCC2105.V_ERJIAN_PAYACCOUNT")
                .append("   WHERE 1 = 1");

        if(StringUtils.isNotBlank(relyCondition)) {
            querySql.append(" AND PK_BANKTYPE =").append(" '").append(relyCondition.split("=")[1]).append("'");
        }
        if(StringUtils.isNotBlank(condition)) {
            JSONObject param = JSONObject.parseObject(condition);
            if(null != param.get("orgCode")) {
                querySql.append(" AND ORGCODE =").append(" '").append(param.getString("orgCode")).append("'");
            }
            if(null != param.get("orgPK")) {
                querySql.append(" AND PK_ORG =").append(" '").append(param.getString("orgPK")).append("'");
            }
        }
        if(StringUtils.isNotBlank(searchText)) {
            querySql.append(" AND (BANKACCSUBCODE LIKE '%").append(searchText).append("%'")
                    .append(" OR BANKACCSUBNAME LIKE '%").append(searchText).append("%' ")
                    .append(" OR BANKCODE LIKE '%").append(searchText).append("%' ")
                    .append(" OR BANKNAME LIKE '%").append(searchText).append("%' ) ");
        }

        querySql.append(" ) t ) ")
                .append("  WHERE \"id\" BETWEEN ").append(startLine * pageSize + 1).append(" AND ").append((startLine+1) * pageSize)
                .append(" ORDER BY \"id\" ");

        logger.info("sql: {}", querySql.toString());
        List<Map<String, Object>> dataList = queryBySql(querySql.toString());

        if(!CollectionUtils.isEmpty(dataList)) {
            dataList.forEach(item -> {
                item.put("id", Long.valueOf(item.get("id").toString()));
            });
        }

        resp.put("records", dataList);
        if(CollectionUtils.isEmpty(dataList)) {
            resp.put("pages", 0);//可以分多少页
            resp.put("total", 0);//多少页数据
            resp.put("current", pageNumber);
            resp.put("pageSize", pageSize);

            return CommonResponse.success(resp);
        }


        StringBuilder countSql = new StringBuilder("SELECT COUNT(1) AS \"total\" FROM ( SELECT t.*, ROW_NUMBER() OVER ( ORDER BY LENGTH( \"code\" ), \"code\" ) AS \"id\" ");
        countSql.append(" FROM (")
                .append("   SELECT")
                .append("       PK_BANKACCSUB AS \"nccPK\",") //付款账号主键
                .append("       BANKACCSUBCODE AS \"code\",") //付款账号主键编码
                .append("       BANKACCSUBNAME AS \"name\",") //付款账号名称
                .append("       PK_BANKDOC AS \"bankPK\",") //付款账号所属银行主键
                .append("       BANKCODE AS \"bankCode\",") //付款账号所属银行编码
                .append("       BANKNAME AS \"bankName\"") //付款账号所属银行名称
                .append("   FROM NCC2105.V_ERJIAN_PAYACCOUNT")
                .append("   WHERE 1 = 1");

        if(StringUtils.isNotBlank(relyCondition)) {
            countSql.append(" AND PK_BANKTYPE =").append(" '").append(relyCondition.split("=")[1]).append("'");
        }
        if(StringUtils.isNotBlank(condition)) {
            JSONObject param = JSONObject.parseObject(condition);
            if(null != param.get("orgCode")) {
                querySql.append(" AND ORGCODE =").append(" '").append(param.getString("orgCode")).append("'");
            }
            if(null != param.get("orgPK")) {
                querySql.append(" AND PK_ORG =").append(" '").append(param.getString("orgPK")).append("'");
            }
        }
        if(StringUtils.isNotBlank(searchText)) {
            countSql.append(" AND (BANKACCSUBCODE LIKE '%").append(searchText).append("%'")
                    .append(" OR BANKACCSUBNAME LIKE '%").append(searchText).append("%' ")
                    .append(" OR BANKCODE LIKE '%").append(searchText).append("%' ")
                    .append(" OR BANKNAME LIKE '%").append(searchText).append("%' ) ");
        }

        countSql.append(" ) t ) ");

        List<Map<String, Object>> countList = queryBySql(countSql.toString());
        BigDecimal count = ((BigDecimal) countList.get(0).get("total"));
        resp.put("pages", count.divide(new BigDecimal(pageSize), BigDecimal.ROUND_DOWN).setScale(0,BigDecimal.ROUND_UP));//可以分多少页
        resp.put("total",count);//多少页数据
        resp.put("current", pageNumber);
        resp.put("pageSize", pageSize);

        return CommonResponse.success(resp);
    }

    /**
     * 分页获取供应商银行账号信息列表
     *
     * @param pageNumber
     * @param pageSize
     * @param searchText
     * @return
     */
    @GetMapping(value = "getNCCRecBankList")
    public CommonResponse<JSONObject> getNCCRecBankList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                               @RequestParam(required = false) String condition,
                                                               @RequestParam(required = false) String searchText) {
        JSONObject resp = new JSONObject();
        int startLine = (pageNumber - 1) < 0 ? 0 : pageNumber - 1;

        StringBuilder querySql = new StringBuilder("SELECT * FROM ( SELECT t.*, ROW_NUMBER() OVER ( ORDER BY LENGTH( \"code\" ), \"code\" ) AS \"id\" ");
        querySql.append(" FROM (")
                .append("   SELECT")
                .append("       PK_BANKACCSUB AS \"nccPK\",") //收款银行账号主键
                .append("       BANKACCSUBCODE AS \"code\",") //收款银行编码
                .append("       BANKACCSUBNAME AS \"name\",") //收款银行账号名称
                .append("       PK_BANKDOC AS \"bankPK\",") //收款账号所属银行主键
                .append("       BANKCODE AS \"bankCode\",") //收款账号所属银行编码
                .append("       BANKNAME AS \"bankName\",") //收款账号所属银行名称
                .append("       PK_BANKTYPE AS \"bankTypePK\",") //收款银行账号分类
                .append("       BANKTYPECODE AS \"bankTypeCode\",") //收款银行账号编码
                .append("       BANKTYPENAME AS \"bankTypeName\"") //收款银行账号名称
                .append("   FROM NCC2105.V_ERJIAN_RECACCOUNT")
                .append("   WHERE 1 = 1");

        SupplierDTO supplier = null;
        if(StringUtils.isNotBlank(condition)) {
            JSONObject param = JSONObject.parseObject(condition);
            if(null != param.get("supplierId")) {

                CommonResponse<SupplierDTO> supplierResp = shareSupplierApi.queryById(param.getLong("supplierId"));
                if(!supplierResp.isSuccess()) {
                    logger.error("根据供应商Id-{}获取供应商信息异常，{} ", param.get("supplierId"), JSONObject.toJSONString(supplierResp));
                }

                supplier = supplierResp.getData();
                querySql.append(" AND SUPPLIERCODE =").append(" '").append(supplier.getCode()).append("'");
            }
        }
        if(StringUtils.isNotBlank(searchText)) {
            querySql.append(" AND (BANKACCSUBCODE LIKE '%").append(searchText).append("%'")
                    .append(" OR BANKACCSUBNAME LIKE '%").append(searchText).append("%' ")
                    .append(" OR BANKNAME LIKE '%").append(searchText).append("%' ")
                    .append(" OR BANKTYPENAME LIKE '%").append(searchText).append("%' ) ");
        }

        querySql.append(" ) t ) ")
                .append("  WHERE \"id\" BETWEEN ").append(startLine * pageSize + 1).append(" AND ").append((startLine+1) * pageSize)
                .append(" ORDER BY \"id\" ");

        logger.info("sql: {}", querySql.toString());
        List<Map<String, Object>> dataList = queryBySql(querySql.toString());

        if(!CollectionUtils.isEmpty(dataList)) {
            dataList.forEach(item -> {
                item.put("id", Long.valueOf(item.get("id").toString()));
            });
        }

        resp.put("records", dataList);
        if(CollectionUtils.isEmpty(dataList)) {
            resp.put("pages", 0);//可以分多少页
            resp.put("total", 0);//多少页数据
            resp.put("current", pageNumber);
            resp.put("pageSize", pageSize);

            return CommonResponse.success(resp);
        }

        StringBuilder countSql = new StringBuilder("SELECT COUNT(1) AS \"total\" FROM ( SELECT t.*, ROW_NUMBER() OVER ( ORDER BY LENGTH( \"code\" ), \"code\" ) AS \"id\" ");
        countSql.append(" FROM (")
                .append("   SELECT")
                .append("       PK_BANKACCSUB AS \"nccPK\",") //收款银行账号主键
                .append("       BANKACCSUBCODE AS \"code\",") //收款银行编码
                .append("       BANKACCSUBNAME AS \"name\",") //收款银行账号名称
                .append("       PK_BANKDOC AS \"bankPK\",") //收款账号所属银行主键
                .append("       BANKCODE AS \"bankCode\",") //收款账号所属银行编码
                .append("       BANKNAME AS \"bankName\",") //收款账号所属银行名称
                .append("       PK_BANKTYPE AS \"bankTypePK\",") //收款银行账号分类
                .append("       BANKTYPECODE AS \"bankTypeCode\",") //收款银行账号编码
                .append("       BANKTYPENAME AS \"bankTypeName\"") //收款银行账号名称
                .append("   FROM NCC2105.V_ERJIAN_RECACCOUNT")
                .append("   WHERE 1 = 1");

        if(StringUtils.isNotBlank(condition)) {
            JSONObject param = JSONObject.parseObject(condition);
            if(null != param.get("supplierCode")) {
                countSql.append(" AND SUPPLIERCODE =").append(" '").append(supplier.getCode()).append("'");
            }
        }
        if(StringUtils.isNotBlank(searchText)) {
            countSql.append(" AND (BANKACCSUBCODE LIKE '%").append(searchText).append("%'")
                    .append(" OR BANKACCSUBNAME LIKE '%").append(searchText).append("%' ")
                    .append(" OR BANKNAME LIKE '%").append(searchText).append("%' ")
                    .append(" OR BANKTYPENAME LIKE '%").append(searchText).append("%' ) ");
        }

        countSql.append(" ) t ) ");

        List<Map<String, Object>> countList = queryBySql(countSql.toString());
        BigDecimal count = ((BigDecimal) countList.get(0).get("total"));
        resp.put("pages", count.divide(new BigDecimal(pageSize), BigDecimal.ROUND_DOWN).setScale(0,BigDecimal.ROUND_UP));//可以分多少页
        resp.put("total",count);//多少页数据
        resp.put("current", pageNumber);
        resp.put("pageSize", pageSize);

        return CommonResponse.success(resp);
    }

    /**
     * 分页获取NCC用户信息列表
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @GetMapping(value = "getNCCUserList")
        public CommonResponse<JSONObject> getNCCUserList(@RequestParam Integer pageNumber,
                                                            @RequestParam Integer pageSize,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        JSONObject resp = new JSONObject();
        resp.put("current",pageNumber);//当前页
        resp.put("size",pageSize);//当前页多少数据
        resp.put("pages",1);//可以分多少页
        resp.put("total",0);//多少页数据
        StringBuilder sql  = new StringBuilder("SELECT * FROM ( SELECT t.*,ROW_NUMBER() OVER ( ORDER BY USER_CODE ) rn FROM NCC2105.V_ERJIAN_USER t WHERE 1 = 1 ");
        if(StringUtils.isNotBlank(searchText)) {
            sql.append(" AND (USER_NAME LIKE '%").append(searchText).append("%'")
                    .append("OR USER_CODE like '%").append(searchText).append("%'")
                    .append("OR ORGCODE like '%").append(searchText).append("%'")
                    .append("OR ORGNAME LIKE '%").append(searchText).append("%' ) ");
        }
        sql.append(")WHERE rn BETWEEN (" +pageNumber+"-1)*"+pageSize+"+1 and "+pageNumber+"*"+pageSize)
                .append(" ORDER BY rn");
        //分页查询 数据
        List<Map<String, Object>> list = queryBySql(sql.toString());
        if (CollectionUtils.isEmpty(list)){
            return CommonResponse.success("",resp);
        }
        List<JSONObject> record = new ArrayList<>();
        for (Map m:list){
            JSONObject j = new JSONObject();
            j.put("id",m.get("USER_CODE"));
            j.put("name",m.get("USER_NAME"));
            j.put("code",m.get("USER_CODE"));
            j.put("orgId",m.get("ORGCODE"));
            j.put("orgCode",m.get("ORGCODE"));
            j.put("orgName",m.get("ORGNAME"));
            record.add(j);
        }
        resp.put("records",record);
        //查询条数
        StringBuilder countSql = new StringBuilder("select COUNT(CUSERID) from NCC2105. V_ERJIAN_USER WHERE 1=1  AND (ORGCODE like '101021%' OR ORGCODE = '10102Z')");
        if(StringUtils.isNotBlank(searchText)) {
            countSql.append(" AND (USER_NAME LIKE '%").append(searchText).append("%'")
                    .append("OR USER_CODE like '%").append(searchText).append("%'")
                    .append("OR ORGCODE like '%").append(searchText).append("%'")
                    .append("OR ORGNAME LIKE '%").append(searchText).append("%' ) ");
        }
        List<Map<String, Object>> countList = queryBySql(countSql.toString());
        BigDecimal count = ((BigDecimal) countList.get(0).get("COUNT(CUSERID)"));
        resp.put("pages", count.divide(new BigDecimal(pageSize), BigDecimal.ROUND_DOWN).setScale(0,BigDecimal.ROUND_UP));//可以分多少页
        resp.put("total",count);//多少页数据
        return CommonResponse.success("查询数据成功",resp);
    }


    /**
     * ncc财务项目基本分类树参照
     *
     * @return
     */
    @GetMapping(value = "getNCCProjectTypeTree")
    public List<Map<String, Object>> getNCCProjectTypeTree() {

        StringBuilder sql = new StringBuilder("SELECT DISTINCT PK_EPS AS \"id\", PK_EPS AS \"key\", EPS_CODE AS \"code\", EPS_NAME AS \"name\" ");
        sql.append(" FROM NCC2105.V_ERJIAN_PROJECT ORDER BY LENGTH(\"code\"), \"code\" ASC");

        return queryBySql(sql.toString());
    }


    /**
     * Ncc财务项目分页列表
     *
     * @param pageNumber
     * @param pageSize
     * @param relyCondition
     * @param searchText
     * @return
     */
    @GetMapping(value = "getNCCFinancialOrgProjectList")
    public CommonResponse<JSONObject> getNCCFinancialOrgProjectList(@RequestParam Integer pageNumber,
                                                                           @RequestParam Integer pageSize,
                                                                           @RequestParam(required = false) String relyCondition,
                                                                           @RequestParam(required = false)  String searchText) {
        int startLine = (pageNumber - 1) < 0 ? 0 : pageNumber - 1;
        JSONObject resp = new JSONObject();

        StringBuilder sql = new StringBuilder("SELECT * FROM ( SELECT t.*, ROW_NUMBER() OVER ( ORDER BY LENGTH( \"code\" ), \"code\" ) AS rn");
        sql.append(" FROM (")
           .append("    SELECT ")
           .append("        PK_PROJECT AS \"nccPK\",")
           .append("        PROJECT_CODE AS \"code\",")
           .append("        PROJECT_NAME AS \"name\",")
           .append("        regexp_substr ( PROJECT_CODE, '[0-9]+' ) AS \"id\" ")
           .append("    FROM NCC2105.V_ERJIAN_PROJECT ")
           .append("    WHERE 1 = 1");

        if(StringUtils.isNotBlank(relyCondition)) {
            sql.append(" AND PK_EPS =").append(" '").append(relyCondition.split("=")[1]).append("'");
        }
       if(StringUtils.isNotBlank(searchText)) {
           sql.append(" AND (PROJECT_CODE LIKE '%").append(searchText).append("%'")
              .append(" OR PROJECT_NAME LIKE '%").append(searchText).append("%' ) ");
       }
       sql.append(" GROUP BY PK_PROJECT, PROJECT_CODE, PROJECT_NAME ) t ) ")
          .append("  WHERE rn BETWEEN ").append(startLine * pageSize + 1).append(" AND ").append((startLine+1) * pageSize)
          .append(" ORDER BY rn ");
       logger.info("sql: {}", sql.toString());
       List<Map<String, Object>> dataList = queryBySql(sql.toString());

       if(!CollectionUtils.isEmpty(dataList)) {
           dataList.forEach(item -> {
               item.put("id", Long.valueOf(item.get("id").toString()));
           });
       }

       resp.put("records", dataList);
       if(CollectionUtils.isEmpty(dataList)) {
           resp.put("pages", 0);//可以分多少页
           resp.put("total", 0);//多少页数据
           resp.put("current", pageNumber);
           resp.put("pageSize", pageSize);

           return CommonResponse.success(resp);
       }

        //查询条数
        StringBuilder countSql = new StringBuilder("SELECT COUNT(1) AS \"total\" FROM ( SELECT t.*, ROW_NUMBER() OVER ( ORDER BY LENGTH( \"code\" ), \"code\" ) AS rn");
        countSql.append(" FROM (")
                .append("    SELECT ")
                .append("        PK_PROJECT AS \"nccPK\",")
                .append("        PROJECT_CODE AS \"code\",")
                .append("        PROJECT_NAME AS \"name\",")
                .append("        regexp_substr ( PROJECT_CODE, '[0-9]+' ) AS \"id\" ")
                .append("    FROM NCC2105.V_ERJIAN_PROJECT ")
                .append("    WHERE 1 = 1");

        if(StringUtils.isNotBlank(relyCondition)) {
            countSql.append(" AND PK_EPS =").append(" '").append(relyCondition.split("=")[1]).append("'");
        }
        if(StringUtils.isNotBlank(searchText)) {
            countSql.append(" AND (PROJECT_CODE LIKE '%").append(searchText).append("%'")
                    .append(" OR PROJECT_NAME LIKE '%").append(searchText).append("%' ) ");
        }
        countSql.append(" GROUP BY PK_PROJECT, PROJECT_CODE, PROJECT_NAME ) t ) ");

        List<Map<String, Object>> countList = queryBySql(countSql.toString());
        BigDecimal count = ((BigDecimal) countList.get(0).get("total"));
        resp.put("pages", count.divide(new BigDecimal(pageSize), BigDecimal.ROUND_DOWN).setScale(0,BigDecimal.ROUND_UP));//可以分多少页
        resp.put("total",count);//多少页数据
        resp.put("current", pageNumber);
        resp.put("pageSize", pageSize);

        return CommonResponse.success(resp);
    }

    /**
     * 查询财务组织树
     *
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping(value = "getNCCFinancialOrgTree")
    public List<Map<String, Object>> getNCCFinancialOrgTree(@RequestParam(required = false) String condition,
                                                            @RequestParam(required = false) String searchText) {

        StringBuilder sql = new StringBuilder("SELECT SUBSTR(code, 0, LENGTH(CODE)-1) AS \"id\", PK_ORG AS \"nccPK\", CODE AS \"code\", CODE || ' ' || NAME AS \"name\",PK_FATHERORG AS \"nccPid\"");
        sql.append(" FROM NCC2105.V_ERJIAN_ORG")
            .append(" WHERE (CODE like '101021%' OR CODE = '10102Z')")
            .append(" START WITH CODE = '10102Z'")
            .append(" CONNECT BY PRIOR PK_ORG = PK_FATHERORG")
            .append(" ORDER BY LENGTH(CODE),CODE");

        List<Map<String, Object>> orgList = queryBySql(sql.toString());
        return ResultAsTreeNew.createTreeData(orgList, "nccPid", "nccPK");

    }
    public List<Map<String, Object>> queryBySql(String sql) {
        List<Map<String, Object>> list = new ArrayList<>();
        Map<String, Object> map = new HashMap();
        map.put("ip",IP);
        map.put("port",PORT);
        map.put("dbName",DBNAME);
        map.put("userName",USERNAME);
        map.put("driver",DRIVER);
        map.put("databaseType",DATABASETYPE);
        map.put("password",PASSWORD);
        DataSource dataSource = DynamicDataSourceDruidUtil.getDataSource(map);
        DBUtil2 db = new DBUtil2(dataSource);
        try {
            list = db.queryForListCommonMethod(sql);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}
