package com.ejianc.business.profinance.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.profinance.bean.PaymentApplyEntity;
import com.ejianc.business.profinance.service.IPaymentApplyService;
import com.ejianc.business.profinance.service.IPaymentRegisterService;
import com.ejianc.business.profinance.vo.ContractPaymentResultVO;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * PM支付主实体
 *
 * @author generator
 */
@RestController
@RequestMapping("/api/paymentApplyApi/")
public class PaymentApplyApi implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPaymentApplyService service;

    @Autowired
    private IPaymentRegisterService paymentRegisterService;

    /**
     * 通过合同id查询相应的付款申请单
     * @param contractId
     * @return
     */
    @GetMapping("queryListByContractId")
    CommonResponse<List<PaymentApplyVO>> queryListByContractId(@RequestParam(value = "contractId") Long contractId) {
        logger.info("查询付款申请单条件：contractId - ", contractId);
        List<PaymentApplyVO> vos = service.queryListByContractId(contractId);
        logger.info("查询付款申请单结果：{}", JSONObject.toJSONString(vos, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        return CommonResponse.success("查询付款申请单成功！", vos);
    }

    /**
     * 通过合同id查询相应的付款申请单
     * @param contractId
     * @return
     */
    @GetMapping("queryJsonByContractId")
    CommonResponse<ContractPaymentResultVO> queryJsonByContractId(@RequestParam(value = "id") Long contractId) {
        logger.info("查询付款申请单条件：contractId - ", contractId);
        return service.queryJsonByContractId(contractId);
    }

    /**
     * 按月份查询实付金额
     *
     * @param queryParam
     * @return
     */
    @PostMapping(value = "queryActualPayGroupByMonth")
    public CommonResponse<List<Map<String, BigDecimal>>> queryActualPayGroupByMonth(@RequestBody QueryParam queryParam) {
        List<Map<String, BigDecimal>> resp = new ArrayList<>();
        logger.info("按月份查询实付金额条件：{}", JSONObject.toJSONString(queryParam));
        Map<String, BigDecimal> rs = paymentRegisterService.queryActualPayGroupByMonth(queryParam);
        logger.info("按月份查询实付金额结果：{}", JSONObject.toJSONString(rs));
        resp.add(rs);
        return CommonResponse.success(resp);
    }

    /**
     * 通过合同id判断能否新增付款申请单
     * @param contractId
     * @return
     */
    @GetMapping(value = "queryAddFlagContractId")
    CommonResponse<String> queryAddFlagContractId(@RequestParam(value = "contractId") Long contractId){
        QueryWrapper<PaymentApplyEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("contract_id", contractId);
        listQuery.eq("bill_state", BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        int resultCount = service.count(listQuery);
        if (resultCount > 0) {
            return CommonResponse.success("查询能否新增付款申请单成功，当前合同已存在未生效的付款申请单，不能新增！", "0");
        }
        return CommonResponse.success("查询能否新增付款申请单成功，可以新增！", "1");
    }

    /**
     * 通过合同id  供应商id 查询该供应商合同的累计付款
     * @param supplierId
     * @param contractId
     * @return
     */
    @GetMapping(value = "querySumApplyMny")
    CommonResponse<JSONObject> querySumApplyMny(@RequestParam(value = "supplierId") Long supplierId,@RequestParam(value = "contractId") Long contractId){
        JSONObject data = new JSONObject();
        QueryWrapper<PaymentApplyEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("contract_id", contractId);
        listQuery.eq("supplier_id", supplierId);
        listQuery.eq("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<PaymentApplyEntity> list = service.list(listQuery);
        BigDecimal sumApplyMny = list.stream().map(PaymentApplyEntity::getApplyMny).reduce(BigDecimal.ZERO,BigDecimal::add);
        data.put("sumApplyMny",sumApplyMny);
        return CommonResponse.success("查询累计付款申请成功！", data);
    }

    @RequestMapping(value = "querySumMny", method = RequestMethod.POST)
    public CommonResponse<Map<Long,BigDecimal>> querySumMny(@RequestBody Map<String,List<Long>> param) {
        Map<Long, BigDecimal> longBigDecimalMap = service.querySumMny(param);
        if(null == longBigDecimalMap){
            return CommonResponse.error("查询失败！");
        }
        return CommonResponse.success(longBigDecimalMap);
    }
}
