package com.ejianc.business.profinance.mapper;

import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.profinance.bean.PaymentApplyEntity;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 付款申请主实体
 * 
 * @author generator
 * 
 */
@Mapper
public interface PaymentApplyMapper extends BaseCrudMapper<PaymentApplyEntity> {
    /**
     * 查找申请日期最大值
     *
     */
    Date selectMaxPaymentApplyDate(Integer paymentType, Long projectId, Long supplierId) ;
    /**
     * 查找有合同日期最大值
     *
     */
    Date selectMaxDate(Integer paymentType, Long projectId, Long contractId) ;

    List<PaymentApplyEntity> querySumMny(@Param("suplyIds") List<Long> suplyIds, @Param("orgIds") List<Long> orgIds);
    
}
