package com.ejianc.business.profinance.projectloan.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 借款管理-项目还款明细
 *
 * @author baipengyan
 */
@TableName("ejc_profinance_project_repay_detail")
public class ProjectRepayDetailEntity extends BaseEntity {
	private static final long serialVersionUID = -4781531469826188747L;

	@TableField(value = "source_id")
	private Long sourceId; // 借款单id
	@TableField(value = "source_bill_code")
	private String sourceBillCode; // 借款单号
	@TableField(value = "source_loan_unit_id")
	private Long sourceLoanUnitId; // 出借单位id
	@TableField(value = "source_loan_unit_code")
	private String sourceLoanUnitCode; // 出借单位编码
	@TableField(value = "source_loan_unit_name")
	private String sourceLoanUnitName; // 出借单位名称
	@TableField(value = "source_loan_date")
	private Date sourceLoanDate; // 借款日期
	@TableField(value = "source_loan_mny")
	private BigDecimal sourceLoanMny; // 借款金额
	@TableField(value = "source_repaid_loan_mny")
	private BigDecimal sourceRepaidLoanMny; // 已还款金额
	@TableField(value = "source_left_loan_mny")
	private BigDecimal sourceLeftLoanMny; // 借款余额
	@TableField(value = "source_expect_repay_date")
	private Date sourceExpectRepayDate; // 预计还款日期
	@TableField(value = "cur_repay_mny")
	private BigDecimal curRepayMny; // 本次还款金额
	@TableField(value = "memo")
	private String memo; // 备注
	@TableField(value = "project_repay_id")
	private Long projectRepayId; // 项目还款id


	public Long getSourceId() {
		return sourceId;
	}

	public void setSourceId(Long sourceId) {
		this.sourceId = sourceId;
	}

	public String getSourceBillCode() {
		return sourceBillCode;
	}

	public void setSourceBillCode(String sourceBillCode) {
		this.sourceBillCode = sourceBillCode;
	}

	public Long getSourceLoanUnitId() {
		return sourceLoanUnitId;
	}

	public void setSourceLoanUnitId(Long sourceLoanUnitId) {
		this.sourceLoanUnitId = sourceLoanUnitId;
	}

	public String getSourceLoanUnitCode() {
		return sourceLoanUnitCode;
	}

	public void setSourceLoanUnitCode(String sourceLoanUnitCode) {
		this.sourceLoanUnitCode = sourceLoanUnitCode;
	}

	public String getSourceLoanUnitName() {
		return sourceLoanUnitName;
	}

	public void setSourceLoanUnitName(String sourceLoanUnitName) {
		this.sourceLoanUnitName = sourceLoanUnitName;
	}

	public Date getSourceLoanDate() {
		return sourceLoanDate;
	}

	public void setSourceLoanDate(Date sourceLoanDate) {
		this.sourceLoanDate = sourceLoanDate;
	}

	public BigDecimal getSourceLoanMny() {
		return sourceLoanMny;
	}

	public void setSourceLoanMny(BigDecimal sourceLoanMny) {
		this.sourceLoanMny = sourceLoanMny;
	}

	public BigDecimal getSourceRepaidLoanMny() {
		return sourceRepaidLoanMny;
	}

	public void setSourceRepaidLoanMny(BigDecimal sourceRepaidLoanMny) {
		this.sourceRepaidLoanMny = sourceRepaidLoanMny;
	}

	public BigDecimal getSourceLeftLoanMny() {
		return sourceLeftLoanMny;
	}

	public void setSourceLeftLoanMny(BigDecimal sourceLeftLoanMny) {
		this.sourceLeftLoanMny = sourceLeftLoanMny;
	}

	public Date getSourceExpectRepayDate() {
		return sourceExpectRepayDate;
	}

	public void setSourceExpectRepayDate(Date sourceExpectRepayDate) {
		this.sourceExpectRepayDate = sourceExpectRepayDate;
	}

	public BigDecimal getCurRepayMny() {
		return curRepayMny;
	}

	public void setCurRepayMny(BigDecimal curRepayMny) {
		this.curRepayMny = curRepayMny;
	}

	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}

	public Long getProjectRepayId() {
		return projectRepayId;
	}

	public void setProjectRepayId(Long projectRepayId) {
		this.projectRepayId = projectRepayId;
	}

}
