package com.ejianc.business.profinance.projectloan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.profinance.projectloan.mapper.ProjectRepayMapper;
import com.ejianc.business.profinance.projectloan.bean.ProjectRepayEntity;
import com.ejianc.business.profinance.projectloan.service.IProjectRepayService;

import java.math.BigDecimal;
import java.util.Map;

/**
 * 借款管理-项目还款实体
 *
 * @author baipengyan
 */
@Service("projectRepayService")
public class ProjectRepayServiceImpl extends BaseServiceImpl<ProjectRepayMapper, ProjectRepayEntity> implements IProjectRepayService {

	/**
	 * 金额合计
	 *
	 * @param param 查询参数
	 *
	 * @return 金额合计
	 */
	@Override
	public Map<String, BigDecimal> fetchTotalMny(QueryParam param) {
		QueryWrapper wrapper = changeToQueryWrapper(param);
		wrapper.select("ifnull(sum(cur_total_repay_mny), 0) as totalCurTotalRepayMny");
		return super.getMap(wrapper);
	}

}
