package com.ejianc.business.profinance.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.profinance.vo.PaymentRegisterVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.profinance.bean.PaymentRegisterEntity;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 付款登记主实体
 * 
 * @author generator
 * 
 */
public interface IPaymentRegisterService extends IBaseService<PaymentRegisterEntity> {

    List<PaymentRegisterEntity> queryPaymentRegisterByContractId(Long contractId);

    Map<String, BigDecimal> queryAlreadyPayMny(Long contractId);

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response);

    String saveImportExcel(HttpServletRequest request, List<PaymentRegisterVO> importVOS);

    BigDecimal getTotalPaidMny(QueryParam param);
    void writeBack(PaymentRegisterEntity entity, boolean check);
    void  checkStatus(PaymentRegisterVO entity);
    void  updateStatus(PaymentRegisterEntity entity, int flag);

    /**
     * 按月份查询实付金额
     *
     * @param queryParam
     * @return
     */
    Map<String, BigDecimal> queryActualPayGroupByMonth(QueryParam queryParam);

    /**
     *  查询指定合同
     *  1、在指定范围内产生付款登记的总金额
     *  2、上一年度付款金额
     *  3、合同开工付款登记总金额
     *
     * @param curStartDate 本期开始日期
     * @param curEndDate 本期结束日期
     * @param lastYearStartDate 上一年度开始日期
     * @param lastYearEndDate 上一年度结束日期
     * @param contractIds   合同Id列表
     * @param contractTypeMap  合同类型列表
     * @param curYear
     * @return
     */
    List<Map<String, Object>> getContractPayInfo(String curStartDate, String curEndDate, String lastYearStartDate, String lastYearEndDate, List<Long> contractIds, List<JSONObject> contractTypeMap, String groupByFields, String curYear);
}
