package com.ejianc.business.profinance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.profinance.bean.SalaryPayApplyEntity;
import com.ejianc.business.profinance.service.ISalaryPayApplyService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("salaryPayApply")
public class SalaryPayApplyBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISalaryPayApplyService salaryPayApplyService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return bpmBackCheck(billId, state, billTypeCode);
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success("工资支付申请终审回调成功！");
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }


    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        // 查询当前申请单是否是当前所属合同下的申请单中的最新的一个，如果不是，不允许撤回
        SalaryPayApplyEntity salaryPayApplyEntity = salaryPayApplyService.selectById(billId);
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(salaryPayApplyEntity.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(salaryPayApplyEntity.getBillState())){
            QueryWrapper<SalaryPayApplyEntity> salaryPayApplyEntityQueryWrapper = new QueryWrapper<>();
            salaryPayApplyEntityQueryWrapper
                    .eq("dr", 0)
                    .eq("tenant_id", InvocationInfoProxy.getTenantid())
                    .eq("contract_id", salaryPayApplyEntity.getContractId())
                    .orderByDesc("create_time")
                    .last("limit 1");
            List<SalaryPayApplyEntity> salaryPayApplyEntityList = salaryPayApplyService.list(salaryPayApplyEntityQueryWrapper);
            if (CollectionUtils.isNotEmpty(salaryPayApplyEntityList)) {
                SalaryPayApplyEntity lastSalaryPayEntity = salaryPayApplyEntityList.get(0);
                if (!billId.equals(lastSalaryPayEntity.getId())) {
                    // 当前申请单不是当前所属合同下最新的一个申请单，不允许撤回
                    return CommonResponse.error("当前申请单不是当前合同下最新的申请单，不允许弃审");
                }
            }
        }
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

}
