package com.ejianc.business.profinance.utils;


import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

/**
 * @author CJ
 * @Description:
 * @date 2022/1/5 17:29
 */
public class ReferTool {

    public static Map<String, Parameter> parseCondition(String relyCondition) {
        Map<String, Parameter> map = new HashMap();
        if (relyCondition != null) {
            List<String> conditions = new ArrayList();
            split(relyCondition, conditions, "and");
            String[] kv = null;
            Iterator var4 = conditions.iterator();

            while(var4.hasNext()) {
                String cond = (String)var4.next();
                if (cond.indexOf("=") != -1) {
                    kv = cond.split("=");
                    map.put(StringUtils.trim(kv[0]), new Parameter(QueryParam.EQ, StringUtils.trim(kv[1])));
                } else if (cond.indexOf("like") != -1) {
                    kv = cond.split("like");
                    map.put(StringUtils.trim(kv[0]), new Parameter(QueryParam.LIKE, StringUtils.trim(kv[1])));
                } else if (cond.indexOf("LIKE") != -1) {
                    kv = cond.split("LIKE");
                    map.put(StringUtils.trim(kv[0]), new Parameter(QueryParam.LIKE, StringUtils.trim(kv[1])));
                } else if (cond.indexOf(">") != -1) {
                    kv = cond.split(">");
                    map.put(StringUtils.trim(kv[0]), new Parameter(QueryParam.GT, StringUtils.trim(kv[1])));
                } else if (cond.indexOf(">=") != -1) {
                    kv = cond.split(">=");
                    map.put(StringUtils.trim(kv[0]), new Parameter(QueryParam.GE, StringUtils.trim(kv[1])));
                } else if (cond.indexOf("<") != -1) {
                    kv = cond.split("<");
                    map.put(StringUtils.trim(kv[0]), new Parameter(QueryParam.LT, StringUtils.trim(kv[1])));
                } else if (cond.indexOf("<=") != -1) {
                    kv = cond.split("<=");
                    map.put(StringUtils.trim(kv[0]), new Parameter(QueryParam.LE, StringUtils.trim(kv[1])));
                }
            }
        }

        return map;
    }

    public static void split(String originString, List<String> ret, String... spliters) {
        String sp = spliters[0];
        String[] arr = originString.split(sp);
        List<String> list = new ArrayList(Arrays.asList(spliters));
        list.remove(sp);
        spliters = (String[])list.toArray(new String[spliters.length - 1]);
        list = null;
        String[] var6 = arr;
        int var7 = arr.length;

        for(int var8 = 0; var8 < var7; ++var8) {
            String str = var6[var8];
            if (spliters.length != 0 && more(str, spliters)) {
                if (spliters.length == 0) {
                    return;
                }

                split(str, ret, spliters);
            } else {
                ret.add(str);
            }
        }

    }

    private static boolean more(String str, String... flags) {
        boolean ret = false;
        String[] var3 = flags;
        int var4 = flags.length;

        for(int var5 = 0; var5 < var4; ++var5) {
            String flg = var3[var5];
            if (str.indexOf(flg) != -1) {
                ret |= true;
                break;
            }
        }

        return ret;
    }

}
