package com.ejianc.business.receipt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.pro.recipetApply.api.IWbRecipetApplyApi;
import com.ejianc.business.receipt.bean.ReceiptRegisterEntity;
import com.ejianc.business.receipt.service.IReceiptRegisterService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("receiptRegister") 
public class ReceiptRegisterBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IReceiptRegisterService service;

	@Autowired
	private IContractPoolApi contractPoolApi;

	@Autowired
	private IWbRecipetApplyApi wbrecip;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//回写合同池
		ReceiptRegisterEntity entity = service.selectById(billId);
		contractPoolApi.updateActualPayRecMny(entity.getContractId(),entity.getSumReceivedMny(),entity.getSumReceivedMny(),true);
		//回写收款申请单实际收款金额
		if (entity.getRecipetApplyId()!=null){
			wbrecip.wbActualReceivedMny(entity.getSumReceivedMny(),entity.getRecipetApplyId(),true);
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//回写合同池
		ReceiptRegisterEntity entity = service.selectById(billId);
		contractPoolApi.updateActualPayRecMny(entity.getContractId(),entity.getSumReceivedMny(),entity.getSumReceivedMny(),false);
		//回写收款申请单实际收款金额
		if (entity.getRecipetApplyId()!=null){
			wbrecip.wbActualReceivedMny(entity.getSumReceivedMny(),entity.getRecipetApplyId(),false);
		}
		return CommonResponse.success();
	}

	//撤回、弃审回调方法
	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		ReceiptRegisterEntity entity = service.selectById(billId);
		if(entity.getSourceFlag()!=null){
			return CommonResponse.error("工程收款不允许弃审！");
		}
		if (entity == null) {
			return CommonResponse.error("查询不到该单据信息！");
		}
		//有合同付款申请 撤回校验
		if (entity.getReceiptContractFlag()==0){
			//查询当前合同是否存在自由态的单据
			QueryWrapper<ReceiptRegisterEntity> listQuery = new QueryWrapper<>();
			listQuery.eq("contract_id", entity.getContractId());
			listQuery.eq("bill_state", BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
			int resultCount = service.count(listQuery);
			if (resultCount > 0) {
				return CommonResponse.error("当前合同已存在自由态的收款登记 不能弃审/撤回！");
			}
			QueryWrapper<ReceiptRegisterEntity> listQueryOrderByTime = new QueryWrapper<>();
			listQueryOrderByTime.eq("contract_id", entity.getContractId());
			listQueryOrderByTime.in("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
			listQueryOrderByTime.orderByDesc("create_time");
			List<ReceiptRegisterEntity> listOrderByTime = service.list(listQueryOrderByTime);
			if (CollectionUtils.isNotEmpty(listOrderByTime) && null != listOrderByTime.get(0)){
				if (!listOrderByTime.get(0).getId().equals(billId)){
					return CommonResponse.error("当前单据不是最新的收款登记，不能弃审/撤回！");
				}
			}
		}
		return CommonResponse.success("弃审/撤回前校验回调成功！");
	}

}
