package com.ejianc.business.profinance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.profinance.bean.PaymentRegisterEntity;
import com.ejianc.business.profinance.bean.RegisterDetailEntity;
import com.ejianc.business.profinance.enums.PaymentContractEnum;
import com.ejianc.business.profinance.service.IPaymentRegisterService;
import com.ejianc.business.profinance.vo.PaymentRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 付款登记主实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("paymentRegister")
public class PaymentRegisterController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PAYMENT_REGISTER";//此处需要根据实际修改

    @Autowired
    private IPaymentRegisterService service;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PaymentRegisterVO> saveOrUpdate(@RequestBody PaymentRegisterVO paymentRegisterVO) {
    	PaymentRegisterEntity entity = BeanMapper.map(paymentRegisterVO, PaymentRegisterEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), paymentRegisterVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(!billCode.isSuccess()) {
                logger.error("保存付款登记失败，自动生成付款登记单编码失败: {}", billCode.getMsg());
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setBillCode(billCode.getData());
            if (entity.getSourceId()!=null){
                service.checkStatus(paymentRegisterVO);

            }
        }
        if(entity.getPaymentContractFlag()!=0||entity.getPaymentContractFlag()!=1){
            service.updateStatus(entity,0);
        }
        if (CollectionUtils.isNotEmpty(entity.getDetailList())){
            for (RegisterDetailEntity detail: entity.getDetailList()){
                detail.setBillState(0);
            }
        }
        service.saveOrUpdate(entity, false);
    	PaymentRegisterVO vo = BeanMapper.map(entity, PaymentRegisterVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PaymentRegisterVO> queryDetail(Long id) {
    	PaymentRegisterEntity entity = service.selectById(id);
    	PaymentRegisterVO vo = BeanMapper.map(entity, PaymentRegisterVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PaymentRegisterVO> vos) {
        for (PaymentRegisterVO vo:vos){
            PaymentRegisterEntity paymentRegisterEntity = service.selectById(vo.getId());
            if(paymentRegisterEntity.getPaymentContractFlag()!=0&&paymentRegisterEntity.getPaymentContractFlag()!=1){
                service.updateStatus(paymentRegisterEntity,1);
            }

        }
        service.removeByIds(vos.stream().map(PaymentRegisterVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();

        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        //搜索：项目所属单位，项目名称，合同名称，收款单位


        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //查询本下范围内日的合同
        Long orgId = null;
        if(null == param.getParams().get("orgId")) {
            orgId = InvocationInfoProxy.getOrgId();
            //若当前上下文为项目部，则根据项目部Id来进行查询
            if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            } else {
                CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if(!orgResp.isSuccess()) {
                    return CommonResponse.error("查询失败，获取组织信息失败！");
                }
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                        orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }

        String projectRange = null != param.getParams().get("projectRange") ? param.getParams().get("projectRange").getValue().toString() : null;
        String dateIn = null != param.getParams().get("dateIn") ? param.getParams().get("dateIn").getValue().toString() : null;
        param.getParams().remove("dateIn");
        param.getParams().remove("projectRange");

        if(StringUtils.isNotBlank(projectRange) || StringUtils.isNotBlank(dateIn)) {
            CommonResponse<List<Long>> projectIdsResp = projectPoolApi.queryProjectIdsByorgId(InvocationInfoProxy.getOrgId(),
                    projectRange, dateIn);

            if(!projectIdsResp.isSuccess()) {
                logger.error("根据组织Id-{}查询其下在建项目列表失败, {}", JSONObject.toJSONString(projectIdsResp));
                return CommonResponse.error("查询失败，获取组织下项目信息失败！");
            }

            if(CollectionUtils.isNotEmpty(projectIdsResp.getData())) {
                param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIdsResp.getData()));
            } else {
                logger.info("根据组织Id-{}查询其下在建项目列表为空, 则返回空的数据列表！");

                resp.put("current", param.getPageIndex());
                resp.put("size", param.getPageSize());
                resp.put("pages", 0);
                resp.put("totalMny", 0);
                resp.put("total", 0);
                resp.put("records", new ArrayList<>());
                return CommonResponse.success("查询列表数据成功！", resp);
            }
        }

        IPage<PaymentRegisterEntity> page = service.queryPage(param,false);

        resp.put("current", page.getCurrent());
        resp.put("size", page.getSize());
        resp.put("pages", page.getPages());
        resp.put("total", page.getTotal());
        resp.put("totalMny", service.getTotalPaidMny(param));
        resp.put("records", BeanMapper.mapList(page.getRecords(), PaymentRegisterVO.class));

        return CommonResponse.success("查询列表数据成功！",resp);
    }

    /**
     * @Description querySumPayMny 查询累计付款
     *      2024-3-21添加
     *      由于门户后端调用只要payMny,使用queryList,数据量太大,现在直接返回同样类型数据，只包含PayMny
     * @param param
     */
    @RequestMapping(value = "/querySumPayMny", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> querySumPayMny(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();

        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        //搜索：项目所属单位，项目名称，合同名称，收款单位


        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //查询本下范围内日的合同
        Long orgId = null;
        if(null == param.getParams().get("orgId")) {
            orgId = InvocationInfoProxy.getOrgId();
            //若当前上下文为项目部，则根据项目部Id来进行查询
            if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            } else {
                CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if(!orgResp.isSuccess()) {
                    return CommonResponse.error("查询失败，获取组织信息失败！");
                }
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                        orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }

        String projectRange = null != param.getParams().get("projectRange") ? param.getParams().get("projectRange").getValue().toString() : null;
        String dateIn = null != param.getParams().get("dateIn") ? param.getParams().get("dateIn").getValue().toString() : null;
        param.getParams().remove("dateIn");
        param.getParams().remove("projectRange");

        if(StringUtils.isNotBlank(projectRange) || StringUtils.isNotBlank(dateIn)) {
            CommonResponse<List<Long>> projectIdsResp = projectPoolApi.queryProjectIdsByorgId(InvocationInfoProxy.getOrgId(),
                    projectRange, dateIn);

            if(!projectIdsResp.isSuccess()) {
                logger.error("根据组织Id-{}查询其下在建项目列表失败, {}", JSONObject.toJSONString(projectIdsResp));
                return CommonResponse.error("查询失败，获取组织下项目信息失败！");
            }

            if(CollectionUtils.isNotEmpty(projectIdsResp.getData())) {
                param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIdsResp.getData()));
            } else {
                logger.info("根据组织Id-{}查询其下在建项目列表为空, 则返回空的数据列表！");

                resp.put("current", param.getPageIndex());
                resp.put("size", param.getPageSize());
                resp.put("pages", 0);
                resp.put("totalMny", 0);
                resp.put("total", 0);
                resp.put("records", new ArrayList<>());
                return CommonResponse.success("查询列表数据成功！", resp);
            }
        }

        List<PaymentRegisterVO> vos = new ArrayList<>();
        BigDecimal totalPaidMny = service.getTotalPaidMny(param);
        PaymentRegisterVO paymentRegisterVO = new PaymentRegisterVO();
        paymentRegisterVO.setPayMny(totalPaidMny);
        vos.add(paymentRegisterVO);
        resp.put("current", param.getPageIndex());
        resp.put("size", param.getPageSize());
//        resp.put("pages", param.get());
        resp.put("total", vos.size());
//        resp.put("totalMny", service.getTotalPaidMny(param));
        resp.put("records", vos);

        return CommonResponse.success("查询列表数据成功！",resp);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = queryList(param);
        List<PaymentRegisterVO> paymentRegisterVOList = new ArrayList<>();
        if (null != commonResponse.getData()) {
            paymentRegisterVOList = (List<PaymentRegisterVO>) commonResponse.getData().get("records");
            //流程状态
            if (CollectionUtils.isNotEmpty(paymentRegisterVOList)){
                for (PaymentRegisterVO paymentRegisterVO : paymentRegisterVOList) {
                    paymentRegisterVO.setBillStateName(BillStateEnum.getEnumByStateCode(paymentRegisterVO.getBillState()).getDescription());
                    paymentRegisterVO.setPaymentContractFlagName(PaymentContractEnum.getByCode(paymentRegisterVO.getPaymentContractFlag()).getName());
                }
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", paymentRegisterVOList);
        ExcelExport.getInstance().export("paymentRegister-export.xlsx", beans, response);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "paymentRegister-import.xlsx", "付款登记单-导入模板");
    }


    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = service.excelImport(request,response);
        return commonResponse;
    }


    /**
     * 导入数据保存
     * @param request
     * @param importVOS
     * @return
     */
    @RequestMapping(value = "/saveImportExcel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<PaymentRegisterVO> importVOS) {
        return CommonResponse.success(service.saveImportExcel(request, importVOS));
    }


    /**
     * 查询当前合同下是否有自由态的付款登记单
     * @param contractId
     * @return
     */
    @GetMapping("/queryPaymentRegisterByContractId")
    @ResponseBody
    public CommonResponse<List<PaymentRegisterVO>> queryPaymentRegisterByContractId(@RequestParam Long contractId) {
        List<PaymentRegisterEntity> paymentRegisterEntityList = service.queryPaymentRegisterByContractId(contractId);
        return CommonResponse.success("查询成功", BeanMapper.mapList(paymentRegisterEntityList, PaymentRegisterVO.class));
    }


    /**
     * 查询当前合同下已申请的金额
     * @param contractId
     * @return
     */
    @GetMapping(value = "/queryAlreadyPayMny")
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> queryAlreadyPayMny(@RequestParam Long contractId) {
        Map<String, BigDecimal> alreadyPayMnyMap = service.queryAlreadyPayMny(contractId);
        return CommonResponse.success(alreadyPayMnyMap);
    }

    @PostMapping(value = "/getTotalPaidMny")
    @ResponseBody
    public CommonResponse<BigDecimal> getTotalPaidMny(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime", QueryParam.DESC);
        String projectRange = null != param.getParams().get("projectRange") ? param.getParams().get("projectRange").getValue().toString() : null;
        String dateIn = null != param.getParams().get("dateIn") ? param.getParams().get("dateIn").getValue().toString() : null;
        param.getParams().remove("dateIn");
        param.getParams().remove("projectRange");
        if(StringUtils.isNotBlank(projectRange) || StringUtils.isNotBlank(dateIn)) {
            CommonResponse<List<Long>> projectIdsResp = projectPoolApi.queryProjectIdsByorgId(InvocationInfoProxy.getOrgId(),
                    projectRange, dateIn);
            if(!projectIdsResp.isSuccess()) {
                logger.error("根据组织Id-{}查询其下在建项目列表失败, {}", JSONObject.toJSONString(projectIdsResp));
                return CommonResponse.error("查询失败，获取组织下项目信息失败！");
            }
            if(CollectionUtils.isNotEmpty(projectIdsResp.getData())) {
                param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIdsResp.getData()));
                param.getParams().remove("projectRange");
            } else {
                logger.info("根据组织Id-{}查询其下在建项目列表为空, 则返回空的数据列表！");
                return CommonResponse.success("查询列表数据成功！", BigDecimal.ZERO);
            }
        }

        return CommonResponse.success("查询成功！", service.getTotalPaidMny(param));
    }
}
